/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationGutterIconBuilder<T> {
    @NonNls
    private static final String PATTERN = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
    private static final NotNullFunction<PsiElement, Collection<? extends PsiElement>> DEFAULT_PSI_CONVERTOR = ContainerUtil::createMaybeSingletonList;
    private final Icon myIcon;
    private final NotNullFunction<T, Collection<? extends PsiElement>> myConverter;
    protected NotNullLazyValue<Collection<T>> myTargets;
    protected boolean myLazy;
    private String myTooltipText;
    private String myPopupTitle;
    private String myEmptyText;
    private String myTooltipTitle;
    private GutterIconRenderer.Alignment myAlignment;
    private Computable<PsiElementListCellRenderer> myCellRenderer;
    private NullableFunction<T, String> myNamer;
    protected final NotNullFunction<T, Collection<? extends GotoRelatedItem>> myGotoRelatedItemProvider;
    public static final NotNullFunction<DomElement, Collection<? extends PsiElement>> DEFAULT_DOM_CONVERTOR = o -> ContainerUtil.createMaybeSingletonList((Object)o.getXmlElement());
    public static final NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> DOM_GOTO_RELATED_ITEM_PROVIDER = dom -> {
        if (dom.getXmlElement() != null) {
            return Collections.singletonList(new DomGotoRelatedItem(dom));
        }
        return Collections.emptyList();
    };
    public static final NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>> PSI_GOTO_RELATED_ITEM_PROVIDER = dom -> Collections.singletonList(new GotoRelatedItem(dom, "XML"));

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter2) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(0);
        }
        if (converter2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(1);
        }
        this(icon, converter2, null);
    }

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter2, @Nullable NotNullFunction<T, Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(2);
        }
        if (converter2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(3);
        }
        this.myAlignment = GutterIconRenderer.Alignment.CENTER;
        this.myNamer = ElementPresentationManager.namer();
        this.myIcon = icon;
        this.myConverter = converter2;
        this.myGotoRelatedItemProvider = gotoRelatedItemProvider;
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(4);
        }
        NavigationGutterIconBuilder<PsiElement> navigationGutterIconBuilder = NavigationGutterIconBuilder.create(icon, DEFAULT_PSI_CONVERTOR, PSI_GOTO_RELATED_ITEM_PROVIDER);
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(5);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter2) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(6);
        }
        if (converter2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(7);
        }
        NavigationGutterIconBuilder<T> navigationGutterIconBuilder = NavigationGutterIconBuilder.create(icon, converter2, null);
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(8);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter2, @Nullable NotNullFunction<T, Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(9);
        }
        if (converter2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(10);
        }
        NavigationGutterIconBuilder<T> navigationGutterIconBuilder = new NavigationGutterIconBuilder<T>(icon, converter2, gotoRelatedItemProvider);
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(11);
        }
        return navigationGutterIconBuilder;
    }

    public NavigationGutterIconBuilder<T> setTarget(@Nullable T target2) {
        return this.setTargets(ContainerUtil.createMaybeSingletonList(target2));
    }

    public NavigationGutterIconBuilder<T> setTargets(T ... targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(12);
        }
        return this.setTargets((Collection<? extends T>)Arrays.asList(targets));
    }

    public NavigationGutterIconBuilder<T> setTargets(@NotNull NotNullLazyValue<Collection<? extends T>> targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(13);
        }
        this.myTargets = targets;
        this.myLazy = true;
        return this;
    }

    public NavigationGutterIconBuilder<T> setTargets(@NotNull Collection<? extends T> targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(14);
        }
        this.myTargets = NotNullLazyValue.createConstantValue(targets);
        return this;
    }

    public NavigationGutterIconBuilder<T> setTooltipText(@NotNull String tooltipText) {
        if (tooltipText == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(15);
        }
        this.myTooltipText = tooltipText;
        return this;
    }

    public NavigationGutterIconBuilder<T> setAlignment(@NotNull GutterIconRenderer.Alignment alignment) {
        if (alignment == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(16);
        }
        this.myAlignment = alignment;
        return this;
    }

    public NavigationGutterIconBuilder<T> setPopupTitle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String popupTitle) {
        if (popupTitle == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(17);
        }
        this.myPopupTitle = popupTitle;
        return this;
    }

    public NavigationGutterIconBuilder<T> setEmptyPopupText(@NotNull String emptyText) {
        if (emptyText == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(18);
        }
        this.myEmptyText = emptyText;
        return this;
    }

    public NavigationGutterIconBuilder<T> setTooltipTitle(@NotNull String tooltipTitle) {
        if (tooltipTitle == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(19);
        }
        this.myTooltipTitle = tooltipTitle;
        return this;
    }

    public NavigationGutterIconBuilder<T> setNamer(@NotNull NullableFunction<T, String> namer) {
        if (namer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(20);
        }
        this.myNamer = namer;
        return this;
    }

    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull PsiElementListCellRenderer cellRenderer) {
        if (cellRenderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(21);
        }
        this.myCellRenderer = new Computable.PredefinedValueComputable((Object)cellRenderer);
        return this;
    }

    @Nullable
    public Annotation install(@NotNull DomElementAnnotationHolder holder, @Nullable DomElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(22);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createAnnotation(element, HighlightSeverity.INFORMATION, null), element.getManager().getProject());
    }

    @Nullable
    public Annotation install(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(23);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createInfoAnnotation(element, null), element.getProject());
    }

    private Annotation doInstall(@NotNull Annotation annotation, @NotNull Project project2) {
        if (annotation == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(25);
        }
        MyNavigationGutterIconRenderer renderer = this.createGutterIconRenderer(project2);
        annotation.setGutterIconRenderer((GutterIconRenderer)renderer);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(26);
        }
        MyNavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject());
        String tooltip = renderer.getTooltipText();
        NotNullLazyValue<Collection<GotoRelatedItem>> gotoTargets = this.getGotoTargets();
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = new RelatedItemLineMarkerInfo(element, element.getTextRange(), renderer.getIcon(), 11, (Function)(tooltip == null ? null : new ConstantFunction((Object)tooltip)), (GutterIconNavigationHandler)(renderer.isNavigateAction() ? renderer : null), renderer.getAlignment(), gotoTargets);
        if (relatedItemLineMarkerInfo == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(27);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    protected NotNullLazyValue<Collection<? extends GotoRelatedItem>> getGotoTargets() {
        NotNullLazyValue<Collection<GotoRelatedItem>> notNullLazyValue = NavigationGutterIconBuilder.createGotoTargetsThunk(this.myLazy, this.myGotoRelatedItemProvider, NavigationGutterIconBuilder.evaluateAndForget(this.myTargets));
        if (notNullLazyValue == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(28);
        }
        return notNullLazyValue;
    }

    private static <T> NotNullLazyValue<Collection<? extends GotoRelatedItem>> createGotoTargetsThunk(boolean lazy, final NotNullFunction<T, Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider, final Factory<Collection<T>> factory) {
        if (gotoRelatedItemProvider == null) {
            return NotNullLazyValue.createConstantValue(Collections.emptyList());
        }
        if (lazy) {
            return new NotNullLazyValue<Collection<? extends GotoRelatedItem>>(){

                @NotNull
                protected Collection<? extends GotoRelatedItem> compute() {
                    List list2 = ContainerUtil.concat((Iterable)((Iterable)factory.create()), (Function)gotoRelatedItemProvider);
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$1", "compute"));
                }
            };
        }
        List concat2 = ContainerUtil.concat((Iterable)((Iterable)factory.create()), gotoRelatedItemProvider);
        return NotNullLazyValue.createConstantValue((Object)concat2);
    }

    private void checkBuilt() {
        assert (this.myTargets != null) : "Must have called .setTargets() before calling create()";
    }

    protected static <T> Factory<T> evaluateAndForget(NotNullLazyValue<T> lazyValue) {
        final Ref ref = Ref.create(lazyValue);
        return new Factory<T>(){
            volatile T result;

            public T create() {
                if (this.result == null) {
                    this.result = ((NotNullLazyValue)ref.get()).getValue();
                    ref.set(null);
                }
                return this.result;
            }
        };
    }

    protected MyNavigationGutterIconRenderer createGutterIconRenderer(@NotNull Project project2) {
        if (project2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(29);
        }
        this.checkBuilt();
        NotNullLazyValue<List<SmartPsiElementPointer>> pointers = NavigationGutterIconBuilder.createPointersThunk(this.myLazy, project2, NavigationGutterIconBuilder.evaluateAndForget(this.myTargets), this.myConverter);
        boolean empty = this.isEmpty();
        if (this.myTooltipText == null && !this.myLazy) {
            TreeSet<String> names = new TreeSet<String>();
            for (Object t : (Collection)this.myTargets.getValue()) {
                String text2 = (String)this.myNamer.fun(t);
                if (text2 == null) continue;
                names.add(MessageFormat.format(PATTERN, text2));
            }
            StringBuilder sb = new StringBuilder("<html><body>");
            if (this.myTooltipTitle != null) {
                sb.append(this.myTooltipTitle).append("<br>");
            }
            for (String name2 : names) {
                sb.append(name2).append("<br>");
            }
            sb.append("</body></html>");
            this.myTooltipText = sb.toString();
        }
        Computable<PsiElementListCellRenderer> renderer = this.myCellRenderer == null ? DefaultPsiElementCellRenderer::new : this.myCellRenderer;
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer, empty);
    }

    @NotNull
    private static <T> NotNullLazyValue<List<SmartPsiElementPointer>> createPointersThunk(boolean lazy, final Project project2, final Factory<Collection<T>> targets, final NotNullFunction<T, Collection<? extends PsiElement>> converter2) {
        if (!lazy) {
            NotNullLazyValue notNullLazyValue = NotNullLazyValue.createConstantValue(NavigationGutterIconBuilder.calcPsiTargets(project2, (Collection)targets.create(), converter2));
            if (notNullLazyValue == null) {
                NavigationGutterIconBuilder.$$$reportNull$$$0(30);
            }
            return notNullLazyValue;
        }
        NotNullLazyValue<List<SmartPsiElementPointer>> notNullLazyValue = new NotNullLazyValue<List<SmartPsiElementPointer>>(){

            @NotNull
            public List<SmartPsiElementPointer> compute() {
                List list2 = NavigationGutterIconBuilder.calcPsiTargets(project2, (Collection)targets.create(), converter2);
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$3", "compute"));
            }
        };
        if (notNullLazyValue == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(31);
        }
        return notNullLazyValue;
    }

    private static <T> List<SmartPsiElementPointer> calcPsiTargets(Project project2, Collection<? extends T> targets, NotNullFunction<T, Collection<? extends PsiElement>> converter2) {
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
        THashSet elements = new THashSet();
        ArrayList<SmartPsiElementPointer> list2 = new ArrayList<SmartPsiElementPointer>(targets.size());
        for (T target2 : targets) {
            for (PsiElement psiElement : (Collection)converter2.fun(target2)) {
                if (!elements.add(psiElement) || !psiElement.isValid()) continue;
                list2.add(manager.createSmartPsiElementPointer(psiElement));
            }
        }
        return list2;
    }

    private boolean isEmpty() {
        if (this.myLazy) {
            return false;
        }
        THashSet elements = new THashSet();
        Collection targets = (Collection)this.myTargets.getValue();
        for (Object target2 : targets) {
            for (PsiElement psiElement : (Collection)this.myConverter.fun(target2)) {
                if (!elements.add(psiElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipTitle";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarkerInfo";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoTargets";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointersThunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTargets";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setAlignment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setPopupTitle";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyPopupText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipTitle";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setNamer";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doInstall";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarkerInfo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createGutterIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNavigationGutterIconRenderer
    extends NavigationGutterIconRenderer {
        private final GutterIconRenderer.Alignment myAlignment;
        private final Icon myIcon;
        private final String myTooltipText;
        private final boolean myEmpty;

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder builder, GutterIconRenderer.Alignment alignment, Icon icon, @Nullable String tooltipText, @NotNull NotNullLazyValue<List<SmartPsiElementPointer>> pointers, Computable<PsiElementListCellRenderer> cellRenderer, boolean empty) {
            if (builder == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(0);
            }
            if (pointers == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(1);
            }
            super(builder.myPopupTitle, builder.myEmptyText, cellRenderer, pointers);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty;
        }

        @Override
        public boolean isNavigateAction() {
            return !this.myEmpty;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltipText;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = this.myAlignment;
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return alignment;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyNavigationGutterIconRenderer that = (MyNavigationGutterIconRenderer)((Object)o);
            if (this.myAlignment != that.myAlignment) {
                return false;
            }
            if (this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null) {
                return false;
            }
            return !(this.myTooltipText != null ? !this.myTooltipText.equals(that.myTooltipText) : that.myTooltipText != null);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myAlignment != null ? this.myAlignment.hashCode() : 0);
            result2 = 31 * result2 + (this.myIcon != null ? this.myIcon.hashCode() : 0);
            result2 = 31 * result2 + (this.myTooltipText != null ? this.myTooltipText.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointers";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

