/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class TemplateBuilderImpl
implements TemplateBuilder {
    private final RangeMarker myContainerElement;
    private final Map<RangeMarker, Expression> myExpressions;
    private final Map<RangeMarker, String> myVariableExpressions;
    private final Map<RangeMarker, Boolean> myAlwaysStopAtMap;
    private final Map<RangeMarker, Boolean> mySkipOnStartMap;
    private final Map<RangeMarker, String> myVariableNamesMap;
    private final Set<RangeMarker> myElements;
    private RangeMarker myEndElement;
    private RangeMarker mySelection;
    private final Document myDocument;
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance(TemplateBuilderImpl.class);

    public TemplateBuilderImpl(@NotNull PsiElement element) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myExpressions = new HashMap<RangeMarker, Expression>();
        this.myVariableExpressions = new HashMap<RangeMarker, String>();
        this.myAlwaysStopAtMap = new HashMap<RangeMarker, Boolean>();
        this.mySkipOnStartMap = new HashMap<RangeMarker, Boolean>();
        this.myVariableNamesMap = new HashMap<RangeMarker, String>();
        this.myElements = new TreeSet<RangeMarker>(RangeMarker.BY_START_OFFSET);
        this.myFile = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element);
        this.myDocument = this.myFile.getViewProvider().getDocument();
        this.myContainerElement = this.wrapElement(element);
    }

    public int getElementsCount() {
        return this.myElements.size();
    }

    public void replaceElement(PsiElement element, Expression expression2, boolean alwaysStopAt) {
        RangeMarker key2 = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.replaceElement(key2, expression2);
    }

    private RangeMarker wrapElement(PsiElement element) {
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        return this.myDocument.createRangeMarker(range);
    }

    private RangeMarker wrapReference(PsiReference ref) {
        PsiElement element = ref.getElement();
        return this.myDocument.createRangeMarker(ref.getRangeInElement().shiftRight(InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).injectedToHost(element, element.getTextRange().getStartOffset())));
    }

    public void replaceElement(PsiElement element, String varName, Expression expression2, boolean alwaysStopAt) {
        this.replaceElement(element, varName, expression2, alwaysStopAt, false);
    }

    public void replaceElement(PsiReference ref, String varName, Expression expression2, boolean alwaysStopAt) {
        RangeMarker key2 = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.replaceElement(key2, expression2);
    }

    public void replaceElement(@NotNull PsiElement element, @NotNull TextRange textRange, String varName, Expression expression2, boolean alwaysStopAt) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(1);
        }
        if (textRange == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(2);
        }
        TextRange elementTextRange = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        RangeMarker key2 = this.myDocument.createRangeMarker(textRange.shiftRight(elementTextRange.getStartOffset()));
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.replaceElement(key2, expression2);
    }

    private void replaceElement(RangeMarker key2, Expression expression2) {
        this.myExpressions.put(key2, expression2);
        this.myElements.add(key2);
    }

    public void replaceElement(PsiElement element, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key2 = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.myVariableExpressions.put(key2, dependantVariableName);
        this.myElements.add(key2);
    }

    public void replaceElement(PsiReference ref, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key2 = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.myVariableExpressions.put(key2, dependantVariableName);
        this.myElements.add(key2);
    }

    public void replaceElement(PsiElement element, TextRange textRange, String primaryVariableName, String otherVariableName, boolean alwaysStopAt) {
        TextRange elementTextRange = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        RangeMarker key2 = this.myDocument.createRangeMarker(textRange.shiftRight(elementTextRange.getStartOffset()));
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, primaryVariableName);
        this.myVariableExpressions.put(key2, otherVariableName);
        this.myElements.add(key2);
    }

    public void replaceElement(@NotNull PsiElement element, Expression expression2) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(3);
        }
        RangeMarker key2 = this.wrapElement(element);
        this.replaceElement(key2, expression2);
    }

    public void replaceElement(@NotNull PsiElement element, TextRange rangeWithinElement, Expression expression2) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(4);
        }
        RangeMarker key2 = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        this.replaceElement(key2, expression2);
    }

    public void replaceRange(TextRange rangeWithinElement, String replacementText) {
        RangeMarker key2 = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        ConstantNode value2 = new ConstantNode(replacementText);
        this.replaceElement(key2, (Expression)value2);
    }

    public void replaceRange(TextRange rangeWithinElement, Expression expression2) {
        RangeMarker key2 = this.myDocument.createRangeMarker(rangeWithinElement);
        this.replaceElement(key2, expression2);
    }

    public void setEndVariableAfter(PsiElement element) {
        element = PsiTreeUtil.nextLeaf((PsiElement)element);
        this.setEndVariableBefore(element);
    }

    public void setEndVariableBefore(PsiElement element) {
        if (this.myEndElement != null) {
            this.myElements.remove(this.myEndElement);
        }
        this.myEndElement = this.wrapElement(element);
        this.myElements.add(this.myEndElement);
    }

    public void setSelection(PsiElement element) {
        this.mySelection = this.wrapElement(element);
        this.myElements.add(this.mySelection);
    }

    public Template buildInlineTemplate() {
        Template template = this.buildTemplate();
        template.setInline(true);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (RangeMarker element : this.myElements) {
            if (element == this.myEndElement) continue;
            this.myDocument.deleteString(element.getStartOffset(), element.getEndOffset());
        }
        return template;
    }

    public Template buildTemplate() {
        String variableName;
        Expression expression2;
        boolean alwaysStopAt;
        Boolean stop2;
        TemplateManager manager = TemplateManager.getInstance(this.myFile.getProject());
        Template template = manager.createTemplate("", "");
        String text2 = this.getDocumentTextFragment(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset());
        int containerStart = this.myContainerElement.getStartOffset();
        int start = 0;
        for (RangeMarker element : this.myElements) {
            int offset = element.getStartOffset() - containerStart;
            if (start > offset) {
                LOG.error("file: " + this.myFile + " container: " + this.myContainerElement + " markers: " + StringUtil.join(this.myElements, rangeMarker -> {
                    String docString = this.myDocument.getText(new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
                    return "[[" + docString + "]" + rangeMarker.getStartOffset() + ", " + rangeMarker.getEndOffset() + "]";
                }, (String)", "));
            }
            template.addTextSegment(text2.substring(start, offset));
            if (element == this.mySelection) {
                template.addSelectionStartVariable();
                template.addTextSegment(this.getDocumentTextFragment(this.mySelection.getStartOffset(), this.mySelection.getEndOffset()));
                template.addSelectionEndVariable();
            } else {
                if (element == this.myEndElement) {
                    template.addEndVariable();
                    start = offset;
                    continue;
                }
                stop2 = this.myAlwaysStopAtMap.get(element);
                alwaysStopAt = stop2 == null || stop2 != false;
                expression2 = this.myExpressions.get(element);
                String string = variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression2.hashCode()) : this.myVariableNamesMap.get(element);
                if (expression2 != null) {
                    Boolean skipOnStart = this.mySkipOnStartMap.get(element);
                    template.addVariable(variableName, expression2, expression2, alwaysStopAt, skipOnStart != null && skipOnStart != false);
                } else {
                    template.addVariableSegment(variableName);
                }
            }
            start = element.getEndOffset() - containerStart;
        }
        template.addTextSegment(text2.substring(start));
        for (RangeMarker element : this.myElements) {
            String dependantVariable = this.myVariableExpressions.get(element);
            if (dependantVariable == null) continue;
            stop2 = this.myAlwaysStopAtMap.get(element);
            alwaysStopAt = stop2 == null || stop2 != false;
            expression2 = this.myExpressions.get(element);
            variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression2.hashCode()) : this.myVariableNamesMap.get(element);
            template.addVariable(variableName, dependantVariable, dependantVariable, alwaysStopAt);
        }
        template.setToIndent(false);
        template.setToReformat(false);
        return template;
    }

    private String getDocumentTextFragment(int startOffset, int endOffset) {
        return this.myDocument.getCharsSequence().subSequence(startOffset, endOffset).toString();
    }

    public void replaceElement(@NotNull PsiElement element, String replacementText) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(5);
        }
        this.replaceElement(element, (Expression)new ConstantNode(replacementText));
    }

    public void replaceElement(@NotNull PsiElement element, TextRange rangeWithinElement, String replacementText) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(6);
        }
        RangeMarker key2 = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        ConstantNode value2 = new ConstantNode(replacementText);
        this.replaceElement(key2, (Expression)value2);
    }

    public void run() {
        Project project2 = this.myFile.getProject();
        VirtualFile file2 = this.myFile.getVirtualFile();
        assert (file2 != null) : "Virtual file is null for " + this.myFile;
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, file2);
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
        assert (editor != null) : "Editor is null";
        this.run(editor, false);
    }

    public void run(@NotNull Editor editor, boolean inline) {
        Template template;
        if (editor == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(7);
        }
        if (inline) {
            template = this.buildInlineTemplate();
        } else {
            template = this.buildTemplate();
            editor.getDocument().replaceString(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset(), (CharSequence)"");
        }
        editor.getCaretModel().moveToOffset(this.myContainerElement.getStartOffset());
        TemplateManager.getInstance(this.myFile.getProject()).startTemplate(editor, template);
    }

    public void replaceElement(PsiElement element, String varName, Expression expression2, boolean alwaysStopAt, boolean skipOnStart) {
        RangeMarker key2 = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.mySkipOnStartMap.put(key2, skipOnStart);
        this.replaceElement(key2, expression2);
    }

    public void replaceRange(TextRange rangeWithinElement, String varName, Expression expression2, boolean alwaysStopAt) {
        RangeMarker key2 = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.replaceElement(key2, expression2);
    }

    public void replaceElement(TextRange rangeWithinElement, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key2 = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        this.myAlwaysStopAtMap.put(key2, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key2, varName);
        this.myVariableExpressions.put(key2, dependantVariableName);
        this.myElements.add(key2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/TemplateBuilderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

