/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateContext {
    private final Map<String, Boolean> myContextStates = ContainerUtil.newTroveMap();

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates.putAll(this.myContextStates);
        return cloneResult;
    }

    @Nullable
    TemplateContextType getDifference(@NotNull TemplateContext defaultContext) {
        if (defaultContext == null) {
            TemplateContext.$$$reportNull$$$0(0);
        }
        return (TemplateContextType)ContainerUtil.find((Object[])TemplateManagerImpl.getAllContextTypes(), type2 -> {
            if (defaultContext == null) {
                TemplateContext.$$$reportNull$$$0(9);
            }
            return this.isEnabled((TemplateContextType)type2) != defaultContext.isEnabled((TemplateContextType)type2);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(1);
        }
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            Boolean storedValue = this.getOwnValue(contextType);
            if (storedValue == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                TemplateContextType baseContextType = contextType.getBaseContextType();
                return baseContextType != null && this.isEnabled(baseContextType);
            }
            return storedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean getOwnValue(TemplateContextType contextType) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            return this.myContextStates.get(contextType.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value2) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            this.myContextStates.put(contextType.getContextId(), value2);
        }
    }

    @VisibleForTesting
    public void setDefaultContext(@NotNull TemplateContext defContext) {
        if (defContext == null) {
            TemplateContext.$$$reportNull$$$0(2);
        }
        THashMap copy = new THashMap(this.myContextStates);
        this.myContextStates.clear();
        this.myContextStates.putAll(defContext.myContextStates);
        this.myContextStates.putAll((Map<String, Boolean>)copy);
    }

    @VisibleForTesting
    public void readTemplateContext(@NotNull Element element) {
        if (element == null) {
            TemplateContext.$$$reportNull$$$0(3);
        }
        for (Element option : element.getChildren("option")) {
            String name2 = option.getAttributeValue("name");
            String value2 = option.getAttributeValue("value");
            if (name2 == null || value2 == null) continue;
            this.myContextStates.put((String)ContainerUtil.getOrElse((Map)ContextInterner.internMap, (Object)name2, (Object)name2), Boolean.parseBoolean(value2));
        }
        this.myContextStates.putAll(this.makeInheritanceExplicit());
    }

    @NotNull
    private Map<String, Boolean> makeInheritanceExplicit() {
        THashMap explicitStates = new THashMap();
        for (TemplateContextType type2 : ContainerUtil.filter((Object[])TemplateManagerImpl.getAllContextTypes(), this::isDisabledByInheritance)) {
            explicitStates.put(type2.getContextId(), false);
        }
        THashMap tHashMap = explicitStates;
        if (tHashMap == null) {
            TemplateContext.$$$reportNull$$$0(4);
        }
        return tHashMap;
    }

    private boolean isDisabledByInheritance(TemplateContextType type2) {
        return !this.hasOwnValue(type2) && !this.isEnabled(type2) && JBIterable.generate((Object)type2, TemplateContextType::getBaseContextType).filter(this::hasOwnValue).first() != null;
    }

    private boolean hasOwnValue(TemplateContextType t) {
        return this.getOwnValue(t) != null;
    }

    public Element writeTemplateContext(@Nullable TemplateContext defaultContext) {
        return this.writeTemplateContext(defaultContext, TemplateContext.getIdToType());
    }

    @VisibleForTesting
    @Nullable
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext, @NotNull Lazy<Map<String, TemplateContextType>> idToType) {
        if (idToType == null) {
            TemplateContext.$$$reportNull$$$0(5);
        }
        if (this.myContextStates.isEmpty()) {
            return null;
        }
        Element element = new Element("context");
        ArrayList<Map.Entry<String, Boolean>> entries = new ArrayList<Map.Entry<String, Boolean>>(this.myContextStates.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : entries) {
            Boolean ownValue = (Boolean)entry.getValue();
            if (ownValue == null) continue;
            TemplateContextType type2 = (TemplateContextType)((Map)idToType.getValue()).get(entry.getKey());
            if (type2 == null) {
                JdomKt.addOptionTag((Element)element, (String)((String)entry.getKey()), (String)ownValue.toString());
                continue;
            }
            if (!this.isValueChanged(ownValue, type2, defaultContext)) continue;
            JdomKt.addOptionTag((Element)element, (String)type2.getContextId(), (String)ownValue.toString());
        }
        return element;
    }

    @NotNull
    public static Lazy<Map<String, TemplateContextType>> getIdToType() {
        Lazy lazy = LazyKt.lazy((Function0)new Function0<Map<String, TemplateContextType>>(){

            public Map<String, TemplateContextType> invoke() {
                THashMap idToType = new THashMap();
                for (TemplateContextType type2 : TemplateManagerImpl.getAllContextTypes()) {
                    idToType.put(type2.getContextId(), type2);
                }
                return idToType;
            }
        });
        if (lazy == null) {
            TemplateContext.$$$reportNull$$$0(6);
        }
        return lazy;
    }

    private boolean isValueChanged(@NotNull Boolean ownValue, @NotNull TemplateContextType type2, @Nullable TemplateContext defaultContext) {
        Boolean defaultValue;
        if (ownValue == null) {
            TemplateContext.$$$reportNull$$$0(7);
        }
        if (type2 == null) {
            TemplateContext.$$$reportNull$$$0(8);
        }
        Boolean bl = defaultValue = defaultContext == null ? null : defaultContext.getOwnValue(type2);
        if (defaultValue == null) {
            TemplateContextType base = type2.getBaseContextType();
            boolean baseEnabled = base != null && this.isEnabled(base);
            return ownValue != baseEnabled;
        }
        return !ownValue.equals(defaultValue);
    }

    public String toString() {
        return this.myContextStates.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeInheritanceExplicit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdToType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDifference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateContext";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeTemplateContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValueChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDifference$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContextInterner {
        private static final Map<String, String> internMap = Arrays.stream(TemplateContextType.EP_NAME.getExtensions()).map(TemplateContextType::getContextId).distinct().collect(Collectors.toMap(Function.identity(), Function.identity()));

        private ContextInterner() {
        }
    }
}

