/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class GroovyScriptMacro
extends Macro {
    public String getName() {
        return "groovyScript";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.groovy.script", (Object[])new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            GroovyScriptMacro.$$$reportNull$$$0(0);
        }
        if (params.length == 0) {
            return null;
        }
        Object o = GroovyScriptMacro.runIt(params, context);
        if (o != null) {
            return new TextResult(o.toString());
        }
        return null;
    }

    private static Object runIt(Expression[] params, ExpressionContext context) {
        try {
            Result result2 = params[0].calculateResult(context);
            if (result2 == null) {
                return result2;
            }
            String text2 = result2.toString();
            GroovyShell shell = new GroovyShell();
            File possibleFile = new File(text2);
            Script script = possibleFile.exists() ? shell.parse(possibleFile) : shell.parse(text2);
            Binding binding = new Binding();
            for (int i = 1; i < params.length; ++i) {
                Result paramResult = params[i].calculateResult(context);
                Object value2 = null;
                if (paramResult instanceof ListResult) {
                    value2 = ContainerUtil.map2List(((ListResult)paramResult).getComponents(), result1 -> result1.toString());
                } else if (paramResult != null) {
                    value2 = paramResult.toString();
                }
                binding.setVariable("_" + i, value2);
            }
            binding.setVariable("_editor", (Object)context.getEditor());
            script.setBinding(binding);
            Object o = script.run();
            return o != null ? StringUtil.convertLineSeparators((String)o.toString()) : null;
        }
        catch (Exception e) {
            return new TextResult(StringUtil.convertLineSeparators((String)e.getLocalizedMessage()));
        }
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            GroovyScriptMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        Object o;
        if (params == null) {
            GroovyScriptMacro.$$$reportNull$$$0(2);
        }
        if ((o = GroovyScriptMacro.runIt(params, context)) != null) {
            LinkedHashSet<LookupElementBuilder> set2 = new LinkedHashSet<LookupElementBuilder>();
            set2.add(LookupElementBuilder.create((String)o.toString()));
            return set2.toArray(new LookupElement[set2.size()]);
        }
        return LookupElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/codeInsight/template/macro/GroovyScriptMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

