/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class TypeOfVariableMacro
extends Macro {
    public String getName() {
        return "typeOfVariable";
    }

    public String getPresentableName() {
        return "typeOfVariable(VAR)";
    }

    @NotNull
    public String getDefaultValue() {
        if ("A" == null) {
            TypeOfVariableMacro.$$$reportNull$$$0(0);
        }
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            TypeOfVariableMacro.$$$reportNull$$$0(1);
        }
        if (params.length == 0) {
            return null;
        }
        Project project2 = context.getProject();
        Result result2 = params[0].calculateQuickResult(context);
        if (result2 instanceof PsiElementResult) {
            PsiElement element = ((PsiElementResult)result2).getElement();
            if (element instanceof PsiVariable) {
                return new PsiTypeResult(((PsiVariable)element).getType(), project2);
            }
        } else if (result2 instanceof TextResult) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
            PsiElement place = file2.findElementAt(context.getStartOffset());
            PsiVariable[] vars = MacroUtil.getVariablesVisibleAt(place, "");
            String name2 = result2.toString();
            for (PsiVariable var : vars) {
                if (!name2.equals(var.getName())) continue;
                return new PsiTypeResult(var.getType(), project2);
            }
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            TypeOfVariableMacro.$$$reportNull$$$0(2);
        }
        return this.calculateResult(params, context);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/macro/TypeOfVariableMacro";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/macro/TypeOfVariableMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateQuickResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

