/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.JavaPsiElementResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.codeInsight.template.macro.VariableTypeCalculator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableOfTypeMacro
extends Macro {
    public String getName() {
        return "variableOfType";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.variable.of.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            VariableOfTypeMacro.$$$reportNull$$$0(0);
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement[] vars;
        if (params == null) {
            VariableOfTypeMacro.$$$reportNull$$$0(1);
        }
        if ((vars = this.getVariables(params, context)) == null || vars.length == 0) {
            return null;
        }
        return new JavaPsiElementResult(vars[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement[] vars;
        if (params == null) {
            VariableOfTypeMacro.$$$reportNull$$$0(2);
        }
        if ((vars = this.getVariables(params, context)) == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElement> set2 = new LinkedHashSet<LookupElement>();
        for (PsiElement var : vars) {
            JavaTemplateUtil.addElementLookupItem(set2, var);
        }
        return set2.toArray(new LookupElement[set2.size()]);
    }

    @Nullable
    protected PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        if (params.length != 1) {
            return null;
        }
        Result result2 = params[0].calculateResult(context);
        if (result2 == null) {
            return null;
        }
        Project project2 = context.getProject();
        int offset = context.getStartOffset();
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        PsiType type2 = MacroUtil.resultToPsiType(result2, context);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file2.findElementAt(offset);
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt(place, "");
        PsiManager manager = PsiManager.getInstance((Project)project2);
        for (PsiVariable var : variables) {
            TextRange range;
            PsiClass placeClass;
            PsiClass varClass;
            if (var instanceof PsiField && var.hasModifierProperty("static") ? !manager.areElementsEquivalent((PsiElement)(varClass = ((PsiField)var).getContainingClass()), (PsiElement)(placeClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class))) : var instanceof PsiLocalVariable && (range = var.getNameIdentifier().getTextRange()) != null && range.contains(offset)) continue;
            PsiType type1 = VariableTypeCalculator.getVarTypeAt(var, place);
            if (type2 != null && !type2.isAssignableFrom(type1)) continue;
            array.add(var);
        }
        Object[] expressions2 = MacroUtil.getStandardExpressionsOfType(place, type2);
        ContainerUtil.addAll(array, (Object[])expressions2);
        return PsiUtilCore.toPsiElementArray(array);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/macro/VariableOfTypeMacro";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/macro/VariableOfTypeMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateLookupItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

