/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalPostfixTemplate
extends StringBasedPostfixTemplate {
    public OptionalPostfixTemplate() {
        super("opt", "Optional.ofNullable(expr)", JavaPostfixTemplatesUtils.atLeastJava8Selector(JavaPostfixTemplatesUtils.selectorTopmost(JavaPostfixTemplatesUtils.IS_NON_VOID)));
    }

    @Override
    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            OptionalPostfixTemplate.$$$reportNull$$$0(0);
        }
        String className = "Optional";
        PsiType type2 = ((PsiExpression)element).getType();
        if (type2 instanceof PsiPrimitiveType) {
            if (PsiType.INT.equals((Object)type2)) {
                className = "OptionalInt";
            } else if (PsiType.DOUBLE.equals((Object)type2)) {
                className = "OptionalDouble";
            } else if (PsiType.LONG.equals((Object)type2)) {
                className = "OptionalLong";
            }
        }
        String methodName = Nullness.NOT_NULL.equals((Object)NullnessUtil.getExpressionNullness((PsiExpression)element)) ? "of" : "ofNullable";
        return "java.util." + className + "." + methodName + "($expr$)";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/postfix/templates/OptionalPostfixTemplate", "getTemplateString"));
    }
}

