/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperimentalVarSupportFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @Override
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            ExperimentalVarSupportFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            ExperimentalVarSupportFixProvider.$$$reportNull$$$0(1);
        }
        if (PsiUtil.getLanguageLevel((PsiElement)ref).isAtLeast(LanguageLevel.JDK_X)) {
            return;
        }
        if (!"var".equals(ref.getReferenceName())) {
            return;
        }
        registrar.register(new IntentionAction(){

            @Nls
            @NotNull
            public String getText() {
                String string = this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Enable support for beta java version" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Enable support for beta java version";
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                boolean result2 = true;
                if (Registry.is((String)"java.experimental.support", (boolean)false) || new LegalNoticeDialog(project2).showAndGet()) {
                    result2 = false;
                }
                if (!result2) {
                    Registry.get((String)"java.experimental.support").setValue(true);
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
                    if (module2 != null) {
                        WriteAction.run(() -> {
                            if (project2 == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            JavaProjectModelModificationService.getInstance(project2).changeLanguageLevel(module2, LanguageLevel.JDK_X);
                        });
                    }
                }
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ExperimentalVarSupportFixProvider$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ExperimentalVarSupportFixProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$invoke$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Override
    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            ExperimentalVarSupportFixProvider.$$$reportNull$$$0(2);
        }
        return PsiJavaCodeReferenceElement.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExperimentalVarSupportFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExperimentalVarSupportFixProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LegalNoticeDialog
    extends DialogWrapper {
        public LegalNoticeDialog(@Nullable Project project2) {
            super(project2, false);
            this.setTitle("Experimental Feature Alert");
            this.init();
            this.setOKButtonText("Accept");
            this.setCancelButtonText("Decline");
            this.pack();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout());
            JPanel iconPanel = new JPanel(new BorderLayout());
            iconPanel.add((Component)new JBLabel(AllIcons.General.WarningDialog), "North");
            iconPanel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            panel2.add((Component)iconPanel, "West");
            JEditorPane message2 = new JEditorPane();
            message2.setEditorKit(UIUtil.getHTMLEditorKit());
            message2.setEditable(false);
            message2.setBackground(UIUtil.getOptionPaneBackground());
            message2.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
            message2.setText(UIUtil.toHtml((String)"You must accept the terms of legal notice of beta Java specification to enable support for local variable type inference, i.e. recognition of keyword 'var' and inspections to replace explicit types with 'var' and return.<br/><br/><b>The implementation of an early-draft specification developed under the Java Community Process (JCP) is made available for testing and evaluation purposes only and is not compatible with any specification of the JCP.</b>"));
            panel2.add((Component)message2, "Center");
            return panel2;
        }
    }
}

