/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(OptionalIsPresentInspection.class);
    private static final OptionalIsPresentCase[] CASES = new OptionalIsPresentCase[]{new ReturnCase(), new AssignmentCase(), new ConsumerCase(), new TernaryCase()};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                PsiVariable optionalVariable;
                super.visitConditionalExpression(expression2);
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getCondition());
                if (condition2 == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition2;
                if (BoolUtils.isNegation(condition2)) {
                    strippedCondition = BoolUtils.getNegated(condition2);
                    invert = true;
                }
                if ((optionalVariable = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiExpression thenExpression2 = invert ? expression2.getElseExpression() : expression2.getThenExpression();
                PsiExpression elseExpression2 = invert ? expression2.getThenExpression() : expression2.getElseExpression();
                this.check(condition2, optionalVariable, (PsiElement)thenExpression2, (PsiElement)elseExpression2);
            }

            public void visitIfStatement(PsiIfStatement statement2) {
                PsiVariable optionalVariable;
                super.visitIfStatement(statement2);
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement2.getCondition());
                if (condition2 == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition2;
                if (BoolUtils.isNegation(condition2)) {
                    strippedCondition = BoolUtils.getNegated(condition2);
                    invert = true;
                }
                if ((optionalVariable = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiStatement thenStatement = OptionalIsPresentInspection.extractThenStatement(statement2, invert);
                PsiStatement elseStatement = OptionalIsPresentInspection.extractElseStatement(statement2, invert);
                this.check(condition2, optionalVariable, (PsiElement)thenStatement, (PsiElement)elseStatement);
            }

            void check(PsiExpression condition2, PsiVariable optionalVariable, PsiElement thenElement, PsiElement elseElement) {
                for (OptionalIsPresentCase scenario : CASES) {
                    scenario.getProblemType(optionalVariable, thenElement, elseElement).registerProblem(holder, condition2, scenario);
                }
            }
        };
        if (javaElementVisitor == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static boolean isRaw(PsiVariable variable) {
        PsiType type2 = variable.getType();
        return type2 instanceof PsiClassType && ((PsiClassType)type2).isRaw();
    }

    @Nullable
    private static PsiStatement extractThenStatement(PsiIfStatement ifStatement, boolean invert) {
        if (invert) {
            return OptionalIsPresentInspection.extractElseStatement(ifStatement, false);
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    private static PsiStatement extractElseStatement(PsiIfStatement ifStatement, boolean invert) {
        PsiElement nextElement;
        PsiStatement thenStatement;
        if (invert) {
            return OptionalIsPresentInspection.extractThenStatement(ifStatement, false);
        }
        PsiStatement statement2 = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (statement2 == null && (thenStatement = OptionalIsPresentInspection.extractThenStatement(ifStatement, false)) instanceof PsiReturnStatement && (nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement)) instanceof PsiStatement) {
            statement2 = ControlFlowUtils.stripBraces((PsiStatement)nextElement);
        }
        return statement2;
    }

    @Contract(value="null -> null")
    static PsiVariable extractOptionalFromIfPresentCheck(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        if (call.getArgumentList().getExpressions().length != 0) {
            return null;
        }
        if (!"isPresent".equals(call.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.util.Optional".equals(containingClass.getQualifiedName())) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)qualifier).resolve();
        if (!(element instanceof PsiVariable) || OptionalIsPresentInspection.isRaw((PsiVariable)element)) {
            return null;
        }
        return (PsiVariable)element;
    }

    @Contract(value="null, _ -> false")
    static boolean isOptionalGetCall(PsiElement element, PsiVariable variable) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        return "get".equals(methodExpression.getReferenceName()) && ExpressionUtils.isReferenceTo(methodExpression.getQualifierExpression(), variable);
    }

    @NotNull
    static ProblemType getTypeByLambdaCandidate(PsiVariable optionalVariable, PsiElement lambdaCandidate, PsiExpression falseExpression) {
        if (lambdaCandidate == null) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(3);
            }
            return problemType;
        }
        if (lambdaCandidate instanceof PsiReferenceExpression && ((PsiReferenceExpression)lambdaCandidate).isReferenceTo((PsiElement)optionalVariable) && OptionalUtil.isOptionalEmptyCall(falseExpression)) {
            ProblemType problemType = ProblemType.WARNING;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(4);
            }
            return problemType;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate, optionalVariable::equals)) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(5);
            }
            return problemType;
        }
        Ref hasOptionalReference = new Ref((Object)Boolean.FALSE);
        boolean hasNoBadRefs = PsiTreeUtil.processElements((PsiElement)lambdaCandidate, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiElement element = ((PsiReferenceExpression)e).resolve();
            if (element != optionalVariable) {
                return true;
            }
            hasOptionalReference.set((Object)Boolean.TRUE);
            return OptionalIsPresentInspection.isOptionalGetCall(e.getParent().getParent(), optionalVariable);
        });
        if (!hasNoBadRefs) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(6);
            }
            return problemType;
        }
        if (!((Boolean)hasOptionalReference.get()).booleanValue() || !(lambdaCandidate instanceof PsiExpression)) {
            ProblemType problemType = ProblemType.INFO;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(7);
            }
            return problemType;
        }
        PsiExpression expression2 = (PsiExpression)lambdaCandidate;
        if (falseExpression != null && NullnessUtil.getExpressionNullness(expression2) != Nullness.NOT_NULL) {
            ProblemType problemType = ProblemType.INFO;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(8);
            }
            return problemType;
        }
        ProblemType problemType = ProblemType.WARNING;
        if (problemType == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(9);
        }
        return problemType;
    }

    @NotNull
    static String generateOptionalLambda(PsiElementFactory factory, CommentTracker ct, PsiVariable optionalVariable, PsiElement trueValue) {
        PsiType type2 = optionalVariable.getType();
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)trueValue.getProject());
        SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type2);
        String baseName = (String)ObjectUtils.coalesce((Object)ArrayUtil.getFirstElement((Object[])info.names), (Object)"value");
        String paramName = javaCodeStyleManager.suggestUniqueVariableName(baseName, trueValue, true);
        if (trueValue instanceof PsiExpressionStatement) {
            trueValue = ((PsiExpressionStatement)trueValue).getExpression();
        }
        ct.markUnchanged(trueValue);
        PsiElement copy = trueValue.copy();
        for (PsiElement getCall : PsiTreeUtil.collectElements((PsiElement)copy, e -> OptionalIsPresentInspection.isOptionalGetCall(e, optionalVariable))) {
            PsiElement result2 = getCall.replace((PsiElement)factory.createIdentifier(paramName));
            if (copy != getCall) continue;
            copy = result2;
        }
        if (copy instanceof PsiStatement && !(copy instanceof PsiBlockStatement)) {
            String string = paramName + "->{" + copy.getText() + "}";
            if (string == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = paramName + "->" + copy.getText();
        if (string == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(11);
        }
        return string;
    }

    static String generateOptionalUnwrap(PsiElementFactory factory, CommentTracker ct, PsiVariable optionalVariable, PsiExpression trueValue, PsiExpression falseValue, PsiType targetType) {
        if (ExpressionUtils.isReferenceTo(trueValue, optionalVariable) && OptionalUtil.isOptionalEmptyCall(falseValue)) {
            trueValue = factory.createExpressionFromText("java.util.Optional.of(" + optionalVariable.getName() + ".get())", (PsiElement)trueValue);
        }
        if (ExpressionUtils.isReferenceTo(falseValue, optionalVariable)) {
            falseValue = factory.createExpressionFromText("java.util.Optional.empty()", (PsiElement)falseValue);
        }
        String lambdaText = OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalVariable, (PsiElement)trueValue);
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)factory.createExpressionFromText(lambdaText, (PsiElement)trueValue);
        return OptionalUtil.generateOptionalUnwrap(optionalVariable.getName(), (PsiVariable)lambda2.getParameterList().getParameters()[0], (PsiExpression)lambda2.getBody(), ct.markUnchanged(falseValue), targetType, true);
    }

    static boolean isSimpleOrUnchecked(PsiExpression expression2) {
        return ExpressionUtils.isSimpleExpression(expression2) || LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)expression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByLambdaCandidate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOptionalLambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ConsumerCase
    implements OptionalIsPresentCase {
        ConsumerCase() {
        }

        @Override
        public ProblemType getProblemType(PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            if (falseElement != null && !(falseElement instanceof PsiEmptyStatement)) {
                return ProblemType.NONE;
            }
            if (!(trueElement instanceof PsiStatement)) {
                return ProblemType.NONE;
            }
            if (trueElement instanceof PsiExpressionStatement) {
                PsiExpression expression2 = ((PsiExpressionStatement)trueElement).getExpression();
                if (OptionalIsPresentInspection.isOptionalGetCall((PsiElement)expression2, optionalVariable)) {
                    return ProblemType.NONE;
                }
                trueElement = expression2;
            }
            return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, trueElement, null);
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, CommentTracker ct, PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            return optionalVariable.getName() + ".ifPresent(" + OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalVariable, trueElement) + ");";
        }
    }

    static class TernaryCase
    implements OptionalIsPresentCase {
        TernaryCase() {
        }

        @Override
        public ProblemType getProblemType(PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            if (!(trueElement instanceof PsiExpression) || !(falseElement instanceof PsiExpression)) {
                return ProblemType.NONE;
            }
            PsiExpression trueExpression = (PsiExpression)trueElement;
            PsiExpression falseExpression = (PsiExpression)falseElement;
            PsiType trueType = trueExpression.getType();
            PsiType falseType = falseExpression.getType();
            if (trueType == null || falseType == null || !trueType.isAssignableFrom(falseType) || !OptionalIsPresentInspection.isSimpleOrUnchecked(falseExpression)) {
                return ProblemType.NONE;
            }
            return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueExpression, falseExpression);
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, CommentTracker ct, PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            PsiExpression ternary = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)trueElement, PsiConditionalExpression.class);
            LOG.assertTrue(ternary != null);
            PsiExpression trueExpression = (PsiExpression)trueElement;
            PsiExpression falseExpression = (PsiExpression)falseElement;
            return OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueExpression, falseExpression, ternary.getType());
        }
    }

    static class AssignmentCase
    implements OptionalIsPresentCase {
        AssignmentCase() {
        }

        @Override
        public ProblemType getProblemType(PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueElement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseElement);
            if (trueAssignment == null || falseAssignment == null) {
                return ProblemType.NONE;
            }
            PsiExpression falseVal = falseAssignment.getRExpression();
            PsiExpression trueVal = trueAssignment.getRExpression();
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueAssignment.getLExpression(), (PsiElement)falseAssignment.getLExpression()) && OptionalIsPresentInspection.isSimpleOrUnchecked(falseVal)) {
                return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueVal, falseVal);
            }
            return ProblemType.NONE;
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, CommentTracker ct, PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueElement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseElement);
            LOG.assertTrue(trueAssignment != null);
            LOG.assertTrue(falseAssignment != null);
            PsiExpression lValue = trueAssignment.getLExpression();
            PsiExpression trueValue = trueAssignment.getRExpression();
            PsiExpression falseValue = falseAssignment.getRExpression();
            LOG.assertTrue(falseValue != null);
            return lValue.getText() + " = " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueValue, falseValue, lValue.getType()) + ";";
        }
    }

    static class ReturnCase
    implements OptionalIsPresentCase {
        ReturnCase() {
        }

        @Override
        public ProblemType getProblemType(PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            if (!(trueElement instanceof PsiReturnStatement) || !(falseElement instanceof PsiReturnStatement)) {
                return ProblemType.NONE;
            }
            PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
            PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
            if (!OptionalIsPresentInspection.isSimpleOrUnchecked(falseValue)) {
                return ProblemType.NONE;
            }
            return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueValue, falseValue);
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, CommentTracker ct, PsiVariable optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
            PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
            LOG.assertTrue(trueValue != null);
            LOG.assertTrue(falseValue != null);
            return "return " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueValue, falseValue, PsiTypesUtil.getMethodReturnType((PsiElement)trueElement)) + ";";
        }
    }

    static interface OptionalIsPresentCase {
        public ProblemType getProblemType(PsiVariable var1, PsiElement var2, PsiElement var3);

        public String generateReplacement(PsiElementFactory var1, CommentTracker var2, PsiVariable var3, PsiElement var4, PsiElement var5);
    }

    static class OptionalIsPresentFix
    implements LocalQuickFix {
        private final OptionalIsPresentCase myScenario;

        public OptionalIsPresentFix(OptionalIsPresentCase scenario) {
            this.myScenario = scenario;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Optional.isPresent() condition with functional style expression" == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(0);
            }
            return "Replace Optional.isPresent() condition with functional style expression";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiStatement elseElement;
            PsiStatement thenElement;
            PsiVariable optionalVariable;
            PsiElement element;
            if (project2 == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor2.getStartElement()) instanceof PsiExpression)) {
                return;
            }
            PsiExpression condition2 = (PsiExpression)element;
            boolean invert = false;
            if (BoolUtils.isNegation(condition2)) {
                condition2 = BoolUtils.getNegated(condition2);
                invert = true;
            }
            if ((optionalVariable = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(condition2)) == null) {
                return;
            }
            PsiElement cond = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class});
            if (cond instanceof PsiIfStatement) {
                thenElement = OptionalIsPresentInspection.extractThenStatement((PsiIfStatement)cond, invert);
                elseElement = OptionalIsPresentInspection.extractElseStatement((PsiIfStatement)cond, invert);
            } else if (cond instanceof PsiConditionalExpression) {
                thenElement = invert ? ((PsiConditionalExpression)cond).getElseExpression() : ((PsiConditionalExpression)cond).getThenExpression();
                elseElement = invert ? ((PsiConditionalExpression)cond).getThenExpression() : ((PsiConditionalExpression)cond).getElseExpression();
            } else {
                return;
            }
            if (this.myScenario.getProblemType(optionalVariable, (PsiElement)thenElement, (PsiElement)elseElement) == ProblemType.NONE) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            CommentTracker ct = new CommentTracker();
            String replacementText = this.myScenario.generateReplacement(factory, ct, optionalVariable, (PsiElement)thenElement, (PsiElement)elseElement);
            if (thenElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)thenElement, (boolean)true)) {
                ct.delete((PsiElement)thenElement);
            }
            if (elseElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)elseElement, (boolean)true)) {
                ct.delete((PsiElement)elseElement);
            }
            PsiElement result2 = ct.replaceAndRestoreComments(cond, replacementText);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result2);
            CodeStyleManager.getInstance((Project)project2).reformat(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum ProblemType {
        WARNING,
        INFO,
        NONE;


        void registerProblem(ProblemsHolder holder, PsiExpression condition2, OptionalIsPresentCase scenario) {
            if (this != NONE) {
                holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)condition2, "Can be replaced with single expression in functional style", this != INFO, this == INFO ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new OptionalIsPresentFix(scenario)}));
            }
        }
    }
}

