/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProblemDescriptorUtil {
    public static final int NONE = 0;
    public static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_END = 2;
    public static final int TRIM_AT_TREE_END = 4;
    public static Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor2, PsiElement psiElement) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (descriptor2 instanceof ProblemDescriptorBase) {
            TextRange textRange = ((ProblemDescriptorBase)descriptor2).getTextRange();
            TextRange elementRange = psiElement.getTextRange();
            if (textRange != null && elementRange != null && (textRange = textRange.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && textRange.getEndOffset() <= elementRange.getLength()) {
                ref = textRange.substring(ref);
            }
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first((String)ref, (int)100, (boolean)true);
        return ref.trim().replaceAll("\\s+", " ");
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, PsiElement element, boolean appendLineNumber) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, appendLineNumber ? 1 : 0);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, PsiElement element, @FlagConstant int flags) {
        int endIndex;
        int lineNumber;
        String message2;
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        if ((message2 = descriptor2.getDescriptionTemplate()) == null) {
            return "";
        }
        if ((flags & 1) != 0 && descriptor2 instanceof ProblemDescriptor && !message2.contains("#ref") && message2.contains("#loc") && (lineNumber = ((ProblemDescriptor)descriptor2).getLineNumber()) >= 0) {
            message2 = StringUtil.replace((String)message2, (String)"#loc", (String)("(" + InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + (lineNumber + 1) + ")"));
        }
        message2 = ProblemDescriptorUtil.unescapeTags(message2);
        message2 = StringUtil.replace((String)message2, (String)"#loc ", (String)"");
        message2 = StringUtil.replace((String)message2, (String)" #loc", (String)"");
        if ((message2 = StringUtil.replace((String)message2, (String)"#loc", (String)"")).contains("#ref")) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor2, element);
            message2 = StringUtil.replace((String)message2, (String)"#ref", (String)ref);
        }
        int n = (flags & 2) != 0 ? message2.indexOf("#end") : (endIndex = (flags & 4) != 0 ? message2.indexOf("#treeend") : -1);
        if (endIndex > 0) {
            message2 = message2.substring(0, endIndex);
        }
        message2 = StringUtil.replace((String)message2, (String)"#end", (String)"");
        message2 = StringUtil.replace((String)message2, (String)"#treeend", (String)"");
        return message2.trim();
    }

    public static String unescapeTags(String message2) {
        message2 = StringUtil.replace((String)message2, (String)"<code>", (String)"'");
        message2 = (message2 = StringUtil.replace((String)message2, (String)"</code>", (String)"'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message2) : StringUtil.unescapeXml((String)message2);
        return message2;
    }

    private static String unescapeXmlCode(String message2) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message2, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder.append(StringUtil.unescapeXml((String)string));
        }
        return builder.toString();
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, PsiElement element) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(4);
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, false);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        TextAttributesKey attributes;
        ProblemHighlightType highlightType;
        HighlightInfoType highlightInfoType;
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(7);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        if ((highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType(highlightType = problemDescriptor.getHighlightType(), severity, severityRegistrar)) == HighlightSeverity.INFORMATION && (attributes = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes()) != null) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, attributes);
            if (highlightInfoTypeImpl == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(9);
            }
            return highlightInfoTypeImpl;
        }
        HighlightInfoType highlightInfoType2 = highlightInfoType;
        if (highlightInfoType2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        return highlightInfoType2;
    }

    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(11);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                return HighlightInfoType.INFO;
            }
            case WEAK_WARNING: {
                return HighlightInfoType.WEAK_WARNING;
            }
            case ERROR: {
                return HighlightInfoType.WRONG_REF;
            }
            case GENERIC_ERROR: {
                return HighlightInfoType.ERROR;
            }
            case INFORMATION: {
                return HighlightInfoType.INFORMATION;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightTypeFromDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface FlagConstant {
    }
}

