/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class ProblematicWhitespaceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ProblematicWhitespaceInspection.$$$reportNull$$$0(0);
        }
        ProblematicWhitespaceVisitor problematicWhitespaceVisitor = new ProblematicWhitespaceVisitor(holder, isOnTheFly);
        if (problematicWhitespaceVisitor == null) {
            ProblematicWhitespaceInspection.$$$reportNull$$$0(1);
        }
        return problematicWhitespaceVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblematicWhitespaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblematicWhitespaceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProblematicWhitespaceVisitor
    extends PsiElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        public ProblematicWhitespaceVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitFile(PsiFile file2) {
            super.visitFile(file2);
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                return;
            }
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file2.getProject());
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(fileType);
            boolean useTabs = indentOptions.USE_TAB_CHARACTER;
            boolean smartTabs = indentOptions.SMART_TABS;
            Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
            if (document == null) {
                return;
            }
            int lineCount = document.getLineCount();
            int previousLineIndent = 0;
            block0: for (int i = 0; i < lineCount; ++i) {
                int startOffset = document.getLineStartOffset(i);
                int endOffset = document.getLineEndOffset(i);
                String line = document.getText(new TextRange(startOffset, endOffset));
                boolean spaceSeen = false;
                int length = line.length();
                for (int j = 0; j < length; ++j) {
                    char c = line.charAt(j);
                    if (c == '\t') {
                        if (!(useTabs ? smartTabs && spaceSeen && this.registerError(file2, startOffset, true) : this.registerError(file2, startOffset, false))) continue;
                        return;
                    }
                    if (c == ' ') {
                        if (useTabs) {
                            if (!smartTabs) {
                                if (this.registerError(file2, startOffset, true)) {
                                    return;
                                }
                            } else if (!spaceSeen) {
                                int currentIndent = Math.max(0, j);
                                if (currentIndent < previousLineIndent && this.registerError(file2, startOffset, true)) {
                                    return;
                                }
                                previousLineIndent = currentIndent;
                            }
                        }
                        spaceSeen = true;
                        continue;
                    }
                    if (spaceSeen) continue block0;
                    previousLineIndent = Math.max(0, j);
                    continue block0;
                }
            }
        }

        private boolean registerError(PsiFile file2, int startOffset, boolean tab) {
            String description;
            PsiElement element = file2.findElementAt(startOffset);
            if (element != null && ProblematicWhitespaceInspection.this.isSuppressedFor(element)) {
                return false;
            }
            String string = description = tab ? InspectionsBundle.message((String)"problematic.whitespace.spaces.problem.descriptor", (Object[])new Object[]{file2.getName()}) : InspectionsBundle.message((String)"problematic.whitespace.tabs.problem.descriptor", (Object[])new Object[]{file2.getName()});
            if (this.myIsOnTheFly) {
                this.myHolder.registerProblem((PsiElement)file2, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ShowWhitespaceFix()});
            } else {
                this.myHolder.registerProblem((PsiElement)file2, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            return true;
        }
    }

    private static class ShowWhitespaceFix
    implements LocalQuickFix {
        private ShowWhitespaceFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"problematic.whitespace.show.whitespaces.quickfix", (Object[])new Object[0]);
            if (string == null) {
                ShowWhitespaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            EditorSettings settings;
            FileEditorManager editorManager;
            Editor editor;
            if (project2 == null) {
                ShowWhitespaceFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ShowWhitespaceFix.$$$reportNull$$$0(2);
            }
            if ((editor = (editorManager = FileEditorManager.getInstance((Project)project2)).getSelectedTextEditor()) == null) {
                return;
            }
            settings.setWhitespacesShown(!(settings = editor.getSettings()).isWhitespacesShown());
            editor.getComponent().repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ProblematicWhitespaceInspection$ShowWhitespaceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ProblematicWhitespaceInspection$ShowWhitespaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

