/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.FList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020#2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0010H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/codeInspection/dataFlow/ControlTransferHandler;", "", "state", "Lcom/intellij/codeInspection/dataFlow/DfaMemoryState;", "runner", "Lcom/intellij/codeInspection/dataFlow/DataFlowRunner;", "target", "Lcom/intellij/codeInspection/dataFlow/TransferTarget;", "(Lcom/intellij/codeInspection/dataFlow/DfaMemoryState;Lcom/intellij/codeInspection/dataFlow/DataFlowRunner;Lcom/intellij/codeInspection/dataFlow/TransferTarget;)V", "getRunner", "()Lcom/intellij/codeInspection/dataFlow/DataFlowRunner;", "getState", "()Lcom/intellij/codeInspection/dataFlow/DfaMemoryState;", "getTarget", "()Lcom/intellij/codeInspection/dataFlow/TransferTarget;", "throwableState", "Lcom/intellij/codeInspection/dataFlow/DfaVariableState;", "getThrowableState", "()Lcom/intellij/codeInspection/dataFlow/DfaVariableState;", "setThrowableState", "(Lcom/intellij/codeInspection/dataFlow/DfaVariableState;)V", "allCaughtTypes", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaTypeValue;", "param", "Lcom/intellij/psi/PsiParameter;", "goToFinally", "Lcom/intellij/codeInspection/dataFlow/DfaInstructionState;", "offset", "", "traps", "Lcom/intellij/util/containers/FList;", "Lcom/intellij/codeInspection/dataFlow/Trap;", "initVariableState", "throwable", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "iteration", "leaveFinally", "processCatches", "tryCatch", "Lcom/intellij/codeInspection/dataFlow/Trap$TryCatch;", "thrownValue", "stateForCatchClause", "varState", "transferToTarget", "java-analysis-impl"})
final class ControlTransferHandler {
    @Nullable
    private DfaVariableState throwableState;
    @NotNull
    private final DfaMemoryState state;
    @NotNull
    private final DataFlowRunner runner;
    @NotNull
    private final TransferTarget target;

    @Nullable
    public final DfaVariableState getThrowableState() {
        return this.throwableState;
    }

    public final void setThrowableState(@Nullable DfaVariableState dfaVariableState) {
        this.throwableState = dfaVariableState;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DfaInstructionState> iteration(@NotNull FList<Trap> traps) {
        List<DfaInstructionState> list2;
        void head;
        Intrinsics.checkParameterIsNotNull(traps, (String)"traps");
        Pair pair2 = TuplesKt.to((Object)traps.getHead(), (Object)traps.getTail());
        Trap trap = (Trap)pair2.component1();
        FList tail = (FList)pair2.component2();
        pair2 = head;
        if (pair2 == null) {
            list2 = this.transferToTarget();
        } else if (pair2 instanceof Trap.TryCatch) {
            if (this.target instanceof ExceptionTransfer) {
                Trap.TryCatch tryCatch = (Trap.TryCatch)head;
                DfaValue dfaValue = ((ExceptionTransfer)this.target).getThrowable();
                FList fList = tail;
                Intrinsics.checkExpressionValueIsNotNull((Object)fList, (String)"tail");
                list2 = this.processCatches(tryCatch, dfaValue, (FList<Trap>)fList);
            } else {
                FList fList = tail;
                Intrinsics.checkExpressionValueIsNotNull((Object)fList, (String)"tail");
                list2 = this.iteration((FList<Trap>)fList);
            }
        } else if (pair2 instanceof Trap.TryFinally) {
            int n = ((Trap.TryFinally)head).getJumpOffset().getInstructionOffset();
            FList fList = tail;
            Intrinsics.checkExpressionValueIsNotNull((Object)fList, (String)"tail");
            list2 = this.goToFinally(n, (FList<Trap>)fList);
        } else if (pair2 instanceof Trap.InsideFinally) {
            FList fList = tail;
            Intrinsics.checkExpressionValueIsNotNull((Object)fList, (String)"tail");
            list2 = this.leaveFinally((FList<Trap>)fList);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    private final List<DfaInstructionState> transferToTarget() {
        List list2;
        TransferTarget transferTarget = this.target;
        if (transferTarget instanceof InstructionTransfer) {
            Iterable $receiver$iv = ((InstructionTransfer)this.target).getToFlush();
            for (Object element$iv : $receiver$iv) {
                DfaVariableValue it = (DfaVariableValue)element$iv;
                this.state.flushVariable(it);
            }
            list2 = CollectionsKt.listOf((Object)new DfaInstructionState(this.runner.getInstruction(((InstructionTransfer)this.target).getOffset().getInstructionOffset()), this.state));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final List<DfaInstructionState> goToFinally(int offset, FList<Trap> traps) {
        this.state.push(this.runner.getFactory().controlTransfer(this.target, traps));
        return CollectionsKt.listOf((Object)new DfaInstructionState(this.runner.getInstruction(offset), this.state));
    }

    private final List<DfaInstructionState> leaveFinally(FList<Trap> traps) {
        DfaValue dfaValue = this.state.pop();
        if (dfaValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInspection.dataFlow.DfaControlTransferValue");
        }
        DfaControlTransferValue cfr_ignored_0 = (DfaControlTransferValue)dfaValue;
        return this.iteration(traps);
    }

    private final List<DfaInstructionState> processCatches(Trap.TryCatch tryCatch, DfaValue thrownValue, FList<Trap> traps) {
        ArrayList<DfaInstructionState> result2 = new ArrayList<DfaInstructionState>();
        Map map = tryCatch.getClauses();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            PsiParameter param;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            PsiCatchSection catchSection = (PsiCatchSection)entry2.getKey();
            entry2 = entry;
            ControlFlow.ControlFlowOffset jumpOffset = (ControlFlow.ControlFlowOffset)entry2.getValue();
            if (catchSection.getParameter() == null) {
                continue;
            }
            if (this.throwableState == null) {
                PsiParameter psiParameter = param;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"param");
                this.throwableState = this.initVariableState(psiParameter, thrownValue);
            }
            PsiParameter psiParameter = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"param");
            for (DfaTypeValue caughtType : this.allCaughtTypes(psiParameter)) {
                DfaVariableState dfaVariableState;
                DfaVariableState dfaVariableState2 = this.throwableState;
                if (dfaVariableState2 != null && (dfaVariableState2 = dfaVariableState2.withInstanceofValue(caughtType)) != null) {
                    DfaVariableState dfaVariableState3;
                    DfaVariableState varState = dfaVariableState3 = dfaVariableState2;
                    Instruction instruction = this.runner.getInstruction(jumpOffset.getInstructionOffset());
                    DfaVariableState dfaVariableState4 = varState;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dfaVariableState4, (String)"varState");
                    result2.add(new DfaInstructionState(instruction, this.stateForCatchClause(param, dfaVariableState4)));
                }
                if ((dfaVariableState = this.throwableState) == null || (dfaVariableState = dfaVariableState.withNotInstanceofValue(caughtType)) == null) {
                    return result2;
                }
                this.throwableState = dfaVariableState;
            }
        }
        return CollectionsKt.plus((Collection)result2, (Iterable)this.iteration(traps));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DfaTypeValue> allCaughtTypes(PsiParameter param) {
        Iterable $receiver$iv$iv;
        List list2;
        PsiType psiType = param.getType();
        Object it = psiType;
        if (it instanceof PsiDisjunctionType) {
            List list3 = ((PsiDisjunctionType)it).getDisjunctions();
            list2 = list3;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"it.disjunctions");
        } else {
            list2 = CollectionsKt.listOfNotNull((Object)it);
        }
        List psiTypes = list2;
        Iterable $receiver$iv = psiTypes;
        it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            PsiType psiType2 = (PsiType)item$iv$iv;
            Collection collection = destination$iv$iv;
            DfaValue dfaValue = this.runner.getFactory().createTypeValue((PsiType)it2, Nullness.NOT_NULL);
            collection.add(dfaValue);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof DfaTypeValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DfaMemoryState stateForCatchClause(PsiParameter param, DfaVariableState varState) {
        DfaMemoryState dfaMemoryState = this.state.createCopy();
        if (dfaMemoryState == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl");
        }
        DfaMemoryStateImpl catchingCopy = (DfaMemoryStateImpl)dfaMemoryState;
        catchingCopy.setVariableState(catchingCopy.getFactory().getVarFactory().createVariableValue((PsiVariable)param, false), varState);
        return catchingCopy;
    }

    private final DfaVariableState initVariableState(PsiParameter param, DfaValue throwable) {
        DfaVariableState dfaVariableState;
        DfaMemoryState dfaMemoryState = this.state;
        if (dfaMemoryState == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl");
        }
        DfaVariableValue sampleVar = ((DfaMemoryStateImpl)dfaMemoryState).getFactory().getVarFactory().createVariableValue((PsiVariable)param, false);
        DfaVariableState varState = ((DfaMemoryStateImpl)this.state).createVariableState(sampleVar).withFact(DfaFactType.CAN_BE_NULL, false);
        if (throwable instanceof DfaTypeValue) {
            DfaVariableState dfaVariableState2 = varState.withInstanceofValue((DfaTypeValue)throwable);
            if (dfaVariableState2 == null) {
                Intrinsics.throwNpe();
            }
            dfaVariableState = dfaVariableState2;
            Intrinsics.checkExpressionValueIsNotNull((Object)dfaVariableState2, (String)"varState.withInstanceofValue(throwable)!!");
        } else {
            DfaVariableState dfaVariableState3 = varState;
            dfaVariableState = dfaVariableState3;
            Intrinsics.checkExpressionValueIsNotNull((Object)dfaVariableState3, (String)"varState");
        }
        return dfaVariableState;
    }

    @NotNull
    public final DfaMemoryState getState() {
        return this.state;
    }

    @NotNull
    public final DataFlowRunner getRunner() {
        return this.runner;
    }

    @NotNull
    public final TransferTarget getTarget() {
        return this.target;
    }

    public ControlTransferHandler(@NotNull DfaMemoryState state, @NotNull DataFlowRunner runner, @NotNull TransferTarget target2) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)runner, (String)"runner");
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        this.state = state;
        this.runner = runner;
        this.target = target2;
    }
}

