/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.inliner.ComparatorModel;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class StreamChainInliner
implements CallInliner {
    private static final String[] TERMINALS = new String[]{"count", "sum", "summaryStatistics", "reduce", "collect", "findFirst", "findAny", "anyMatch", "allMatch", "noneMatch", "toArray", "average", "forEach", "forEachOrdered", "min", "max", "toList", "toSet"};
    private static final CallMatcher TERMINAL_CALL = CallMatcher.instanceCall("java.util.stream.BaseStream", TERMINALS);
    private static final CallMatcher FOR_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "forEach", "forEachOrdered").parameterCount(1);
    private static final CallMatcher MATCH_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "anyMatch", "allMatch", "noneMatch").parameterCount(1);
    private static final CallMatcher SUM_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "sum", "count").parameterCount(0);
    private static final CallMatcher OPTIONAL_TERMINAL = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.BaseStream", "min", "max").parameterCount(0), CallMatcher.instanceCall("java.util.stream.BaseStream", "reduce").parameterCount(1), CallMatcher.instanceCall("java.util.stream.BaseStream", "findFirst", "findAny").parameterCount(0));
    private static final CallMatcher MIN_MAX_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "min", "max", "reduce").parameterCount(1);
    private static final CallMatcher SKIP_STEP = CallMatcher.instanceCall("java.util.stream.BaseStream", "unordered", "parallel", "sequential").parameterCount(0);
    private static final CallMatcher SORTED = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.Stream", "sorted").parameterCount(1), CallMatcher.instanceCall("java.util.stream.Stream", "sorted").parameterCount(0));
    private static final CallMatcher FILTER = CallMatcher.instanceCall("java.util.stream.BaseStream", "filter").parameterCount(1);
    private static final CallMatcher STATE_FILTER = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.BaseStream", "distinct").parameterCount(0), CallMatcher.instanceCall("java.util.stream.BaseStream", "skip", "limit").parameterCount(1));
    private static final CallMatcher BOXED = CallMatcher.instanceCall("java.util.stream.BaseStream", "boxed").parameterCount(0);
    private static final CallMatcher MAP = CallMatcher.instanceCall("java.util.stream.BaseStream", "map", "mapToInt", "mapToLong", "mapToDouble", "mapToObj").parameterCount(1);
    private static final CallMatcher FLAT_MAP = CallMatcher.instanceCall("java.util.stream.BaseStream", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble").parameterCount(1);
    private static final CallMatcher PEEK = CallMatcher.instanceCall("java.util.stream.BaseStream", "peek").parameterCount(1);
    private static final CallMatcher STREAM_GENERATE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.IntStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.LongStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.DoubleStream", "generate").parameterCount(1));
    private static final CallMatcher STREAM_EMPTY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "empty").parameterCount(0), CallMatcher.staticCall("java.util.stream.IntStream", "empty").parameterCount(0), CallMatcher.staticCall("java.util.stream.LongStream", "empty").parameterCount(0), CallMatcher.staticCall("java.util.stream.DoubleStream", "empty").parameterCount(0));
    private static final CallMatcher STREAM_OF = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T"), CallMatcher.staticCall("java.util.stream.IntStream", "of").parameterTypes("int"), CallMatcher.staticCall("java.util.stream.LongStream", "of").parameterTypes("long"), CallMatcher.staticCall("java.util.stream.DoubleStream", "of").parameterTypes("double"));
    private static final CallMatcher STREAM_OF_ARRAY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T[]"), CallMatcher.staticCall("java.util.stream.IntStream", "of").parameterTypes("int[]"), CallMatcher.staticCall("java.util.stream.LongStream", "of").parameterTypes("long[]"), CallMatcher.staticCall("java.util.stream.DoubleStream", "of").parameterTypes("double[]"));
    private static final CallMatcher ARRAYS_STREAM = CallMatcher.staticCall("java.util.Arrays", "stream").parameterCount(1);
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall("java.util.Collection", "stream").parameterCount(0);
    private static final CallMapper<UnaryOperator<Step>> INTERMEDIATE_STEP_MAPPER = new CallMapper<Function<PsiMethodCallExpression, UnaryOperator>>().register(FILTER, call -> next -> new FilterStep((PsiMethodCallExpression)call, (Step)next)).register(MAP, call -> next -> new MapStep((PsiMethodCallExpression)call, (Step)next)).register(FLAT_MAP, call -> next -> new FlatMapStep((PsiMethodCallExpression)call, (Step)next)).register(PEEK, call -> next -> new PeekStep((PsiMethodCallExpression)call, (Step)next)).register(SORTED, call -> next -> new SortedStep((PsiMethodCallExpression)call, (Step)next)).register(BOXED, call -> next -> new BoxedStep((PsiMethodCallExpression)call, (Step)next)).register(STATE_FILTER, call -> next -> new StateFilterStep((PsiMethodCallExpression)call, (Step)next));
    private static final CallMapper<Step> TERMINAL_STEP_MAPPER = new CallMapper<Function<PsiMethodCallExpression, Step>>().register(FOR_TERMINAL, LambdaTerminalStep::new).register(MATCH_TERMINAL, MatchTerminalStep::new).register(SUM_TERMINAL, SumTerminalStep::new).register(MIN_MAX_TERMINAL, MinMaxTerminalStep::new).register(OPTIONAL_TERMINAL, OptionalTerminalStep::new);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            StreamChainInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            StreamChainInliner.$$$reportNull$$$0(1);
        }
        if (!TERMINAL_CALL.test(call)) {
            return false;
        }
        PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
        Step terminalStep = StreamChainInliner.createTerminalStep(call);
        Step firstStep = StreamChainInliner.buildChain(qualifierCall, terminalStep);
        PsiExpression originalQualifier = firstStep.myCall.getMethodExpression().getQualifierExpression();
        if (originalQualifier == null) {
            return false;
        }
        StreamChainInliner.buildStreamCFG(builder, firstStep, originalQualifier);
        firstStep.pushResult(builder);
        return true;
    }

    static void buildStreamCFG(CFGBuilder builder, Step firstStep, PsiExpression originalQualifier) {
        DfaValue qualifierValue;
        PsiExpression qualifierExpression2;
        PsiType inType = StreamApiUtil.getStreamElementType(originalQualifier.getType());
        PsiMethodCallExpression sourceCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)originalQualifier), PsiMethodCallExpression.class);
        if (STREAM_GENERATE.test(sourceCall)) {
            PsiExpression fn = sourceCall.getArgumentList().getExpressions()[0];
            builder.evaluateFunction(fn).chain(firstStep::before).doWhile().pushVariable(builder.createTempVariable(inType)).invokeFunction(0, fn).assign().chain(firstStep::iteration).endWhileUnknown();
            return;
        }
        boolean empty = STREAM_EMPTY.test(sourceCall);
        boolean array = ARRAYS_STREAM.test(sourceCall);
        boolean single = STREAM_OF.test(sourceCall);
        if (STREAM_OF_ARRAY.test(sourceCall)) {
            PsiExpression[] args = sourceCall.getArgumentList().getExpressions();
            if (args.length == 0) {
                empty = true;
            } else if (args.length == 1) {
                if (MethodCallUtils.isVarArgCall(sourceCall)) {
                    single = true;
                } else {
                    array = true;
                }
            } else {
                builder.pushExpression(originalQualifier).pop().chain(firstStep::before).chain(b -> StreamChainInliner.makeMainLoop(b, firstStep, inType));
                return;
            }
        }
        if (empty) {
            builder.chain(firstStep::before);
            return;
        }
        if (single) {
            builder.pushExpression(sourceCall.getArgumentList().getExpressions()[0]).chain(firstStep::before).chain(firstStep::iteration);
            return;
        }
        if (array) {
            qualifierExpression2 = sourceCall.getArgumentList().getExpressions()[0];
            qualifierValue = builder.getFactory().createValue(qualifierExpression2);
            if (qualifierValue != null) {
                builder.pushExpression(qualifierExpression2).chain(firstStep::before).checkNotNull(qualifierExpression2, NullabilityProblem.passingNullableToNotNullParameter).pop().push(SpecialField.ARRAY_LENGTH.createValue(builder.getFactory(), qualifierValue)).push(builder.getFactory().getInt(0)).ifCondition(JavaTokenType.GT).chain(b -> StreamChainInliner.makeMainLoop(b, firstStep, inType)).endIf();
                return;
            }
        }
        if (COLLECTION_STREAM.test(sourceCall)) {
            qualifierExpression2 = sourceCall.getMethodExpression().getQualifierExpression();
            qualifierValue = builder.getFactory().createValue(qualifierExpression2);
            if (qualifierValue != null) {
                builder.pushExpression(qualifierExpression2).chain(firstStep::before).checkNotNull((PsiExpression)sourceCall, NullabilityProblem.callNPE).pop().push(SpecialField.COLLECTION_SIZE.createValue(builder.getFactory(), qualifierValue)).push(builder.getFactory().getInt(0)).ifCondition(JavaTokenType.GT).chain(b -> StreamChainInliner.makeMainLoop(b, firstStep, inType)).endIf();
                return;
            }
        }
        builder.pushExpression(originalQualifier).checkNotNull((PsiExpression)firstStep.myCall, NullabilityProblem.callNPE).pop().chain(firstStep::before).pushUnknown().ifConditionIs(true).chain(b -> StreamChainInliner.makeMainLoop(b, firstStep, inType)).endIf();
    }

    private static void makeMainLoop(CFGBuilder builder, Step firstStep, PsiType inType) {
        builder.doWhile().pushVariable(builder.createTempVariable(inType)).push(builder.getFactory().createTypeValue(inType, DfaPsiUtil.getTypeNullability(inType))).assign().chain(firstStep::iteration).endWhileUnknown();
    }

    static Step buildChain(PsiMethodCallExpression qualifierCall, Step terminalStep) {
        Step curStep = terminalStep;
        while (qualifierCall != null) {
            if (!SKIP_STEP.test(qualifierCall)) {
                Step nextStep = StreamChainInliner.createIntermediateStep(curStep, qualifierCall);
                if (nextStep == null) break;
                curStep = nextStep;
            }
            qualifierCall = MethodCallUtils.getQualifierMethodCall(qualifierCall);
        }
        return curStep;
    }

    private static Step createIntermediateStep(Step nextStep, PsiMethodCallExpression call) {
        UnaryOperator<Step> stepFactory = INTERMEDIATE_STEP_MAPPER.mapFirst(call);
        if (stepFactory == null) {
            return null;
        }
        return (Step)stepFactory.apply(nextStep);
    }

    private static Step createTerminalStep(PsiMethodCallExpression call) {
        Step step = TERMINAL_STEP_MAPPER.mapFirst(call);
        return step == null ? new UnknownTerminalStep(call) : step;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class BoxedStep
    extends Step {
        BoxedStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                BoxedStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
        }

        @Override
        void iteration(CFGBuilder builder) {
            PsiType outType = StreamApiUtil.getStreamElementType(this.myCall.getType());
            PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)outType);
            if (primitiveType != null) {
                builder.boxUnbox((PsiExpression)this.myCall, (PsiType)primitiveType, outType).assignTo(builder.createTempVariable(outType));
            }
            this.myNext.iteration(builder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$BoxedStep", "<init>"));
        }
    }

    static class SortedStep
    extends Step {
        private final ComparatorModel myComparatorModel;

        SortedStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                SortedStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
            this.myComparatorModel = ComparatorModel.from((PsiExpression)ArrayUtil.getFirstElement((Object[])this.myCall.getArgumentList().getExpressions()));
        }

        @Override
        void before(CFGBuilder builder) {
            this.myComparatorModel.evaluate(builder);
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup();
            this.myComparatorModel.invoke(builder);
            this.myNext.iteration(builder);
        }

        @Override
        boolean expectNotNull() {
            return this.myComparatorModel.failsOnNull() || this.myNext.expectNotNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$SortedStep", "<init>"));
        }
    }

    static class StateFilterStep
    extends Step {
        StateFilterStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                StateFilterStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
        }

        @Override
        void before(CFGBuilder builder) {
            for (PsiExpression arg : this.myCall.getArgumentList().getExpressions()) {
                builder.pushExpression(arg).pop();
            }
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pushUnknown().ifConditionIs(true).chain(this.myNext::iteration).elseBranch().pop().endIf();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$StateFilterStep", "<init>"));
        }
    }

    static class PeekStep
    extends Step {
        PeekStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                PeekStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup().invokeFunction(1, this.myFunction).pop().chain(this.myNext::iteration);
        }

        @Override
        boolean expectNotNull() {
            return this.myNext.expectNotNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$PeekStep", "<init>"));
        }
    }

    static class FlatMapStep
    extends Step {
        private final Step myChain;
        private final PsiParameter myParameter;
        private final PsiExpression myStreamSource;

        FlatMapStep(@NotNull PsiMethodCallExpression call, Step next) {
            PsiExpression body2;
            if (call == null) {
                FlatMapStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myCall.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
            Step chain = null;
            PsiParameter parameter2 = null;
            PsiExpression streamSource = null;
            if (lambda2 != null && (parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters())) != null && (body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()))) != null) {
                streamSource = body2;
                chain = next;
                if (body2 instanceof PsiMethodCallExpression) {
                    Step filteredNext = new Step(call, next, null){

                        @Override
                        void before(CFGBuilder builder) {
                        }

                        @Override
                        void iteration(CFGBuilder builder) {
                            this.myNext.iteration(builder);
                        }
                    };
                    chain = StreamChainInliner.buildChain((PsiMethodCallExpression)body2, filteredNext);
                    streamSource = chain != filteredNext ? chain.myCall.getMethodExpression().getQualifierExpression() : body2;
                }
            }
            this.myStreamSource = streamSource;
            this.myChain = chain;
            this.myParameter = parameter2;
        }

        @Override
        void before(CFGBuilder builder) {
            if (this.myStreamSource == null) {
                PsiExpression arg = this.myCall.getArgumentList().getExpressions()[0];
                builder.pushExpression(arg).checkNotNull(arg, NullabilityProblem.passingNullableToNotNullParameter).pop();
            }
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            if (this.myStreamSource != null) {
                builder.assignTo((PsiVariable)this.myParameter).pop();
                StreamChainInliner.buildStreamCFG(builder, this.myChain, this.myStreamSource);
            } else {
                PsiType outType = StreamApiUtil.getStreamElementType(this.myCall.getType());
                builder.pop().doWhile().push(builder.getFactory().createTypeValue(outType, Nullness.UNKNOWN)).chain(this.myNext::iteration).endWhileUnknown();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$FlatMapStep", "<init>"));
        }
    }

    static class MapStep
    extends Step {
        MapStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                MapStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.invokeFunction(1, this.myFunction, this.myNext.expectNotNull() ? Nullness.NOT_NULL : Nullness.UNKNOWN).assignTo(builder.createTempVariable(StreamApiUtil.getStreamElementType(this.myCall.getType()))).chain(this.myNext::iteration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$MapStep", "<init>"));
        }
    }

    static class FilterStep
    extends Step {
        FilterStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                FilterStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup().invokeFunction(1, this.myFunction).ifConditionIs(true).chain(this.myNext::iteration).elseBranch().pop().endIf();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$FilterStep", "<init>"));
        }
    }

    static class MatchTerminalStep
    extends TerminalStep {
        MatchTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                MatchTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.push(builder.getFactory().getBoolean(!"anyMatch".equals(this.myCall.getMethodExpression().getReferenceName())));
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.invokeFunction(1, this.myFunction).ifConditionIs(!"allMatch".equals(this.myCall.getMethodExpression().getReferenceName())).pushVariable(this.myResult).push(builder.getFactory().getBoolean("anyMatch".equals(this.myCall.getMethodExpression().getReferenceName()))).assign().pop().endIf();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$MatchTerminalStep", "<init>"));
        }
    }

    static class MinMaxTerminalStep
    extends TerminalStep {
        private final ComparatorModel myComparatorModel;

        MinMaxTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                MinMaxTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null);
            this.myComparatorModel = ComparatorModel.from(call.getArgumentList().getExpressions()[0]);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.push(builder.getFactory().getOptionalFactory().getOptional(false));
        }

        @Override
        void before(CFGBuilder builder) {
            this.myComparatorModel.evaluate(builder);
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            this.myComparatorModel.invoke(builder);
            builder.pushVariable(this.myResult).push(builder.getFactory().getOptionalFactory().getOptional(true)).assign().pop();
        }

        @Override
        boolean expectNotNull() {
            return this.myComparatorModel.failsOnNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$MinMaxTerminalStep", "<init>"));
        }
    }

    static class OptionalTerminalStep
    extends TerminalStep {
        OptionalTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                OptionalTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions()));
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.push(builder.getFactory().getOptionalFactory().getOptional(false));
        }

        @Override
        void iteration(CFGBuilder builder) {
            if (this.myFunction != null) {
                builder.pushUnknown().invokeFunction(2, this.myFunction);
            }
            builder.pushVariable(this.myResult).push(builder.getFactory().getOptionalFactory().getOptional(true)).assign().splice(2, new int[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$OptionalTerminalStep", "<init>"));
        }
    }

    static class SumTerminalStep
    extends TerminalStep {
        SumTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                SumTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            PsiType type2 = this.myCall.getType();
            Object value2 = PsiTypesUtil.getDefaultValue((PsiType)type2);
            builder.push(builder.getFactory().getConstFactory().createFromValue(value2, type2, null));
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pushVariable(this.myResult).pushUnknown().assign().splice(2, new int[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$SumTerminalStep", "<init>"));
        }
    }

    static class LambdaTerminalStep
    extends Step {
        LambdaTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                LambdaTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.invokeFunction(1, this.myFunction).pop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$LambdaTerminalStep", "<init>"));
        }
    }

    static abstract class TerminalStep
    extends Step {
        PsiVariable myResult;

        TerminalStep(@NotNull PsiMethodCallExpression call, PsiExpression function) {
            if (call == null) {
                TerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null, function);
        }

        @Override
        void before(CFGBuilder builder) {
            this.myResult = builder.createTempVariable(this.myCall.getType());
            builder.pushVariable(this.myResult).chain(this::pushInitialValue).assign().pop().chain(x$0 -> super.before((CFGBuilder)x$0));
        }

        protected abstract void pushInitialValue(CFGBuilder var1);

        @Override
        void pushResult(CFGBuilder builder) {
            builder.push(builder.getFactory().getVarFactory().createVariableValue(this.myResult, false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$TerminalStep", "<init>"));
        }
    }

    static class UnknownTerminalStep
    extends Step {
        UnknownTerminalStep(PsiMethodCallExpression call) {
            super(call, null, null);
        }

        @Override
        void before(CFGBuilder builder) {
            for (PsiExpression arg : this.myCall.getArgumentList().getExpressions()) {
                builder.pushExpression(arg).pop();
            }
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pop().flushFields();
        }
    }

    static abstract class Step {
        final Step myNext;
        @NotNull
        final PsiMethodCallExpression myCall;
        final PsiExpression myFunction;

        Step(@NotNull PsiMethodCallExpression call, Step next, PsiExpression function) {
            if (call == null) {
                Step.$$$reportNull$$$0(0);
            }
            this.myNext = next;
            this.myCall = call;
            this.myFunction = function;
        }

        void before(CFGBuilder builder) {
            if (this.myFunction != null) {
                builder.evaluateFunction(this.myFunction);
            }
            if (this.myNext != null) {
                this.myNext.before(builder);
            }
        }

        abstract void iteration(CFGBuilder var1);

        void pushResult(CFGBuilder builder) {
            if (this.myNext != null) {
                this.myNext.pushResult(builder);
            } else {
                builder.push(builder.getFactory().createTypeValue(this.myCall.getType(), DfaPsiUtil.getElementNullability(this.myCall.getType(), (PsiModifierListOwner)this.myCall.resolveMethod())));
            }
        }

        boolean expectNotNull() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/inliner/StreamChainInliner$Step", "<init>"));
        }
    }
}

