/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HTMLExportFrameMaker {
    private final String myRootFolder;
    private final Project myProject;
    private final List<InspectionToolWrapper> myInspectionToolWrappers = new ArrayList<InspectionToolWrapper>();

    public HTMLExportFrameMaker(String rootFolder, Project project2) {
        this.myRootFolder = rootFolder;
        this.myProject = project2;
    }

    public void start() {
        StringBuffer buf = new StringBuffer();
        buf.append("<HTML><BODY></BODY></HTML>");
        HTMLExportUtil.writeFile(this.myRootFolder, "empty.html", buf, this.myProject);
    }

    public void done() {
        StringBuffer buf = new StringBuffer();
        if (this.myInspectionToolWrappers.isEmpty()) {
            buf.append("Everything is fine. Nothing is ruined.");
        } else {
            for (InspectionToolWrapper toolWrapper : this.myInspectionToolWrappers) {
                buf.append("<A HREF=\"");
                buf.append(toolWrapper.getFolderName());
                buf.append("-index.html\">");
                buf.append(toolWrapper.getDisplayName());
                buf.append("</A><BR>");
            }
        }
        HTMLExportUtil.writeFile(this.myRootFolder, "index.html", buf, this.myProject);
    }

    public void startInspection(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            HTMLExportFrameMaker.$$$reportNull$$$0(0);
        }
        this.myInspectionToolWrappers.add(toolWrapper);
        StringBuffer buf = new StringBuffer();
        buf.append("<HTML><HEAD><TITLE>");
        buf.append(ApplicationNamesInfo.getInstance().getFullProductName());
        buf.append(" ");
        buf.append(InspectionsBundle.message((String)"inspection.export.title", (Object[])new Object[0]));
        buf.append("</TITLE></HEAD>");
        buf.append("<FRAMESET cols=\"30%,70%\"><FRAMESET rows=\"30%,70%\">");
        buf.append("<FRAME src=\"");
        buf.append(toolWrapper.getFolderName());
        buf.append("/index.html\" name=\"inspectionFrame\">");
        buf.append("<FRAME src=\"empty.html\" name=\"packageFrame\">");
        buf.append("</FRAMESET>");
        buf.append("<FRAME src=\"empty.html\" name=\"elementFrame\">");
        buf.append("</FRAMESET></BODY></HTML>");
        HTMLExportUtil.writeFile(this.myRootFolder, toolWrapper.getFolderName() + "-index.html", buf, this.myProject);
    }

    public String getRootFolder() {
        return this.myRootFolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/export/HTMLExportFrameMaker", "startInspection"));
    }
}

