/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInsight.intention.impl.config.ActionUsagePanel;
import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.codeInspection.java18StreamApi.StaticPseudoFunctionalStyleMethodOptions;
import com.intellij.codeInspection.java18StreamApi.StreamApiConstants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.ClassNameReferenceEditor;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddMethodsDialog.class);
    @NotNull
    private final Project myProject;
    private JPanel myPanel;
    private ComboBox myTemplatesCombo;
    private ClassNameReferenceEditor myClassNameEditor;
    private ComboBox myMethodNameCombo;
    private ActionUsagePanel myBeforeActionPanel;
    private ActionUsagePanel myAfterActionPanel;
    private JPanel myExamplePanel;

    protected AddMethodsDialog(final @NotNull Project project2, @NotNull Component parent, boolean canBeParent) {
        if (project2 == null) {
            AddMethodsDialog.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            AddMethodsDialog.$$$reportNull$$$0(1);
        }
        super(parent, canBeParent);
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myTemplatesCombo.setEnabled(false);
        this.myTemplatesCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<PseudoLambdaReplaceTemplate>(){

            protected void customizeCellRenderer(@NotNull JList list2, PseudoLambdaReplaceTemplate template, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (template == null) {
                    return;
                }
                this.append("stream.");
                String streamApiMethodName = template.getStreamApiMethodName();
                if (((Set)StreamApiConstants.STREAM_STREAM_API_METHODS.getValue()).contains(streamApiMethodName)) {
                    this.append(streamApiMethodName + "()", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    LOG.assertTrue("#findMatched".equals(streamApiMethodName));
                    this.append(String.format("filter(%s).findFirst().get()", "condition"), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    this.append(" or ");
                    this.append(".orElseGet(() -> defaultValue)", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInspection/java18StreamApi/AddMethodsDialog$1", "customizeCellRenderer"));
            }
        });
        this.myTemplatesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PseudoLambdaReplaceTemplate template = (PseudoLambdaReplaceTemplate)e.getItem();
                Collection methods = (Collection)AddMethodsDialog.this.myMethodNameCombo.getSelectedItem();
                if (methods == null) {
                    return;
                }
                for (PsiMethod method : methods) {
                    if (template.validate(method) == null) continue;
                    AddMethodsDialog.this.showTemplateExample(template, method);
                    break;
                }
            }
        });
        this.myMethodNameCombo.setModel(new DefaultComboBoxModel());
        this.myMethodNameCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AddMethodsDialog.this.myExamplePanel.isEnabled()) {
                    AddMethodsDialog.this.myExamplePanel.setEnabled(true);
                }
                LinkedHashSet<PseudoLambdaReplaceTemplate> suitableTemplates = new LinkedHashSet<PseudoLambdaReplaceTemplate>();
                Collection methods = (Collection)e.getItem();
                for (PseudoLambdaReplaceTemplate template : PseudoLambdaReplaceTemplate.getAllTemplates()) {
                    for (PsiMethod method : methods) {
                        if (template.validate(method) == null) continue;
                        if (suitableTemplates.isEmpty()) {
                            AddMethodsDialog.this.showTemplateExample(template, method);
                        }
                        suitableTemplates.add(template);
                    }
                }
                if (!AddMethodsDialog.this.myTemplatesCombo.isEnabled()) {
                    AddMethodsDialog.this.myTemplatesCombo.setEnabled(true);
                }
                LOG.assertTrue(!suitableTemplates.isEmpty());
                ArrayList templatesAsList = new ArrayList(suitableTemplates);
                AddMethodsDialog.this.myTemplatesCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(templatesAsList));
                AddMethodsDialog.this.myTemplatesCombo.setSelectedItem(templatesAsList.get(0));
            }
        });
        this.myMethodNameCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Collection<PsiMethod>>(){

            public void customize(JList list2, Collection<PsiMethod> methods, int index, boolean selected, boolean hasFocus) {
                if (methods != null) {
                    LOG.assertTrue(!methods.isEmpty());
                    this.setText(((PsiMethod)ContainerUtil.getFirstItem(methods)).getName());
                }
            }
        });
        this.myClassNameEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                String classFqn = e.getDocument().getText();
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project2).findClass(classFqn, GlobalSearchScope.allScope((Project)project2));
                DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)AddMethodsDialog.this.myMethodNameCombo.getModel();
                comboBoxModel.removeAllElements();
                if (aClass == null) {
                    AddMethodsDialog.this.enable(false);
                } else {
                    List<PseudoLambdaReplaceTemplate> possibleTemplates = PseudoLambdaReplaceTemplate.getAllTemplates();
                    LinkedMultiMap nameToMethod = new LinkedMultiMap();
                    for (PsiMethod m : ContainerUtil.filter((Object[])aClass.getMethods(), method -> {
                        if (method.isConstructor() || !method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                            return false;
                        }
                        boolean templateFound = false;
                        for (PseudoLambdaReplaceTemplate template : possibleTemplates) {
                            if (template.validate((PsiMethod)method) == null) continue;
                            templateFound = true;
                        }
                        return templateFound;
                    })) {
                        nameToMethod.putValue((Object)m.getName(), (Object)m);
                    }
                    for (Map.Entry entry : nameToMethod.entrySet()) {
                        comboBoxModel.addElement(entry.getValue());
                    }
                    boolean isSuitableMethodsFound = comboBoxModel.getSize() != 0;
                    AddMethodsDialog.this.enable(isSuitableMethodsFound);
                }
            }
        });
        this.setOKActionEnabled(false);
        this.init();
    }

    private void enable(boolean isEnabled) {
        this.myMethodNameCombo.setEnabled(isEnabled);
        this.myTemplatesCombo.setEnabled(isEnabled);
        this.setOKActionEnabled(isEnabled);
        this.myExamplePanel.setEnabled(isEnabled);
        if (!isEnabled) {
            this.myBeforeActionPanel.reset("", (FileType)StdFileTypes.JAVA);
            this.myAfterActionPanel.reset("", (FileType)StdFileTypes.JAVA);
        }
    }

    private void showTemplateExample(PseudoLambdaReplaceTemplate template, PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        LOG.assertTrue(aClass != null);
        String fqn = aClass.getQualifiedName();
        LOG.assertTrue(fqn != null);
        String parameters2 = StringUtil.join((Collection)ContainerUtil.map((Object[])method.getParameterList().getParameters(), parameter2 -> parameter2.getName()), (String)", ");
        String expressionText = fqn + "." + method.getName() + "(" + parameters2 + ")";
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(expressionText, null);
        LOG.assertTrue(psiExpression instanceof PsiMethodCallExpression);
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)psiExpression;
        template.convertToStream(methodCallExpression, method, false);
        this.myBeforeActionPanel.reset("void example() {\n  <spot>" + methodCallExpression.getText() + "</spot>;\n}", (FileType)StdFileTypes.JAVA);
        this.myAfterActionPanel.reset("void example() {\n  <spot>" + template.convertToStream(methodCallExpression, method, true).getText() + "</spot>\n}", (FileType)StdFileTypes.JAVA);
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myBeforeActionPanel);
        Disposer.dispose((Disposable)this.myAfterActionPanel);
        super.dispose();
    }

    private void createUIComponents() {
        this.myClassNameEditor = new ClassNameReferenceEditor(this.myProject, null);
    }

    public StaticPseudoFunctionalStyleMethodOptions.PipelineElement getSelectedElement() {
        return new StaticPseudoFunctionalStyleMethodOptions.PipelineElement(this.myClassNameEditor.getText(), ((PsiMethod)ContainerUtil.getFirstItem((Collection)((Collection)this.myMethodNameCombo.getSelectedItem()))).getName(), (PseudoLambdaReplaceTemplate)this.myTemplatesCombo.getSelectedItem());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/java18StreamApi/AddMethodsDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ActionUsagePanel actionUsagePanel;
        ActionUsagePanel actionUsagePanel2;
        JPanel jPanel;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Fully qualified class name:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Method name:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Stream API replacement:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTemplatesCombo = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myMethodNameCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, new Dimension(200, -1), null, null));
        ClassNameReferenceEditor classNameReferenceEditor = this.myClassNameEditor;
        jPanel3.add((Component)((Object)classNameReferenceEditor), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myExamplePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myBeforeActionPanel = actionUsagePanel2 = new ActionUsagePanel();
        jPanel.add((Component)actionUsagePanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 50), null, null));
        this.myAfterActionPanel = actionUsagePanel = new ActionUsagePanel();
        jPanel.add((Component)actionUsagePanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 50), null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Before quick fix:");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setOpaque(false);
        titledSeparator2.setText("After quick fix:");
        jPanel.add((Component)titledSeparator2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

