/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.sameParameterValue.SameParameterValueInspectionBase;
import com.intellij.codeInspection.unusedSymbol.VisibilityModifierChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameParameterValueInspection
extends SameParameterValueInspectionBase {
    private static final Logger LOG = Logger.getInstance(SameParameterValueInspectionBase.class);

    @Nullable
    public JComponent createOptionsPanel() {
        LabeledComponent component = LabeledComponent.create((JComponent)new VisibilityModifierChooser(() -> true, this.highestModifier, (Consumer<String>)((Consumer)newModifier -> {
            this.highestModifier = newModifier;
        })), (String)"Methods to report:", (String)"West");
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 12, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    @Override
    protected LocalQuickFix createFix(String paramName, String value2) {
        return new InlineParameterValueFix(paramName, value2);
    }

    public static class InlineParameterValueFix
    implements LocalQuickFix {
        private final String myValue;
        private final String myParameterName;

        private InlineParameterValueFix(String parameterName, String value2) {
            this.myValue = value2;
            this.myParameterName = parameterName;
        }

        public String toString() {
            return this.getParamName() + " " + this.getValue();
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.name", (Object[])new Object[]{this.myParameterName, StringUtil.unquoteString((String)this.myValue)});
            if (string == null) {
                InlineParameterValueFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                InlineParameterValueFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiExpression defToInline;
            PsiElement element;
            PsiMethod method;
            if (project2 == null) {
                InlineParameterValueFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                InlineParameterValueFix.$$$reportNull$$$0(3);
            }
            if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), PsiMethod.class)) == null) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
            if (parameter2 == null) {
                PsiParameter[] parameters2;
                for (PsiParameter psiParameter : parameters2 = method.getParameterList().getParameters()) {
                    if (!Comparing.strEqual((String)psiParameter.getName(), (String)this.myParameterName)) continue;
                    parameter2 = psiParameter;
                    break;
                }
            }
            if (parameter2 == null) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)parameter2)) {
                return;
            }
            try {
                defToInline = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(this.myValue, (PsiElement)parameter2);
            }
            catch (IncorrectOperationException e) {
                return;
            }
            PsiParameter parameterToInline = parameter2;
            InlineParameterValueFix.inlineSameParameterValue(method, parameterToInline, defToInline);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public static void inlineSameParameterValue(PsiMethod method, PsiParameter parameter2, PsiExpression defToInline) {
            MultiMap conflicts = new MultiMap();
            JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, method, parameter2);
            if (!conflicts.isEmpty()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                        throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
                    }
                } else if (!new ConflictsDialog(parameter2.getProject(), (MultiMap<PsiElement, String>)conflicts).showAndGet()) {
                    return;
                }
            }
            Collection refsToInline = ReferencesSearch.search((PsiElement)parameter2).findAll();
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    PsiExpression[] exprs = new PsiExpression[refsToInline.size()];
                    int idx = 0;
                    for (PsiReference reference : refsToInline) {
                        if (!(reference instanceof PsiJavaCodeReferenceElement)) continue;
                        exprs[idx++] = InlineUtil.inlineVariable((PsiVariable)parameter2, defToInline, (PsiJavaCodeReferenceElement)reference);
                    }
                    for (PsiExpression expr : exprs) {
                        if (expr == null) continue;
                        InlineUtil.tryToInlineArrayCreationForVarargs(expr);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            InlineParameterValueFix.removeParameter(method, parameter2);
        }

        public static void removeParameter(PsiMethod method, PsiParameter parameter2) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
            int paramIdx = 0;
            String paramName = parameter2.getName();
            for (PsiParameter param : parameters2) {
                if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                    psiParameters.add(new ParameterInfoImpl(paramIdx, param.getName(), param.getType()));
                }
                ++paramIdx;
            }
            new ChangeSignatureProcessor(method.getProject(), method, false, null, method.getName(), method.getReturnType(), psiParameters.toArray(new ParameterInfoImpl[psiParameters.size()])).run();
        }

        public String getValue() {
            return this.myValue;
        }

        public String getParamName() {
            return this.myParameterName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

