/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseStreamApiMigration {
    private boolean myShouldWarn;
    private final String myReplacement;

    protected BaseStreamApiMigration(boolean shouldWarn, String replacement) {
        this.myShouldWarn = shouldWarn;
        this.myReplacement = replacement;
    }

    public String getReplacement() {
        return this.myReplacement;
    }

    abstract PsiElement migrate(@NotNull Project var1, @NotNull PsiElement var2, @NotNull TerminalBlock var3);

    public boolean isShouldWarn() {
        return this.myShouldWarn;
    }

    public void setShouldWarn(boolean shouldWarn) {
        this.myShouldWarn = shouldWarn;
    }

    static PsiElement replaceWithOperation(PsiStatement loopStatement, PsiVariable var, String streamText, PsiType expressionType, OperationReductionMigration.ReductionOperation reductionOperation) {
        PsiExpression initializer;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)loopStatement.getProject());
        BaseStreamApiMigration.restoreComments(loopStatement, (PsiElement)(loopStatement instanceof PsiLoopStatement ? ((PsiLoopStatement)loopStatement).getBody() : loopStatement));
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(var, loopStatement);
        if (status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN && (initializer = var.getInitializer()) != null && reductionOperation.getInitializerExpressionRestriction().test(initializer)) {
            PsiType type2 = var.getType();
            String replacement = (type2.isAssignableFrom(expressionType) ? "" : "(" + type2.getCanonicalText() + ") ") + streamText;
            return BaseStreamApiMigration.replaceInitializer(loopStatement, var, initializer, replacement, status);
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + reductionOperation.getOperation() + "=" + streamText + ";", (PsiElement)loopStatement));
    }

    static PsiElement replaceInitializer(PsiStatement loopStatement, PsiVariable var, PsiExpression initializer, String replacement, ControlFlowUtils.InitializerUsageStatus status) {
        Project project2 = loopStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        if (status == ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE) {
            initializer.replace((PsiElement)elementFactory.createExpressionFromText(replacement, (PsiElement)loopStatement));
            BaseStreamApiMigration.removeLoop(loopStatement);
            return var;
        }
        if (status == ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
            initializer.delete();
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + " = " + replacement + ";", (PsiElement)loopStatement));
    }

    @Nullable
    static PsiElement replaceWithFindExtremum(@NotNull PsiStatement loopStatement, @NotNull PsiVariable extremumHolder, @NotNull String streamText, @Nullable PsiVariable keyExtremum) {
        if (loopStatement == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(0);
        }
        if (extremumHolder == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(1);
        }
        if (streamText == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(2);
        }
        BaseStreamApiMigration.restoreComments(loopStatement, (PsiElement)(loopStatement instanceof PsiLoopStatement ? ((PsiLoopStatement)loopStatement).getBody() : loopStatement));
        if (keyExtremum != null) {
            keyExtremum.delete();
        }
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(extremumHolder, loopStatement);
        return BaseStreamApiMigration.replaceInitializer(loopStatement, extremumHolder, extremumHolder.getInitializer(), streamText, status);
    }

    static void restoreComments(PsiStatement statement2, PsiElement body2) {
        if (statement2 instanceof PsiLoopStatement || statement2 instanceof PsiExpressionStatement) {
            PsiElement parent = statement2.getParent();
            for (PsiElement comment : PsiTreeUtil.findChildrenOfType((PsiElement)body2, PsiComment.class)) {
                parent.addBefore(comment, (PsiElement)statement2);
            }
        }
    }

    static void removeLoop(@NotNull PsiStatement statement2) {
        PsiElement parent;
        if (statement2 == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(3);
        }
        if ((parent = statement2.getParent()) instanceof PsiLabeledStatement) {
            parent.delete();
        } else {
            statement2.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extremumHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/streamMigration/BaseStreamApiMigration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithFindExtremum";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeLoop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

