/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.Java8MigrationUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectMigration
extends BaseStreamApiMigration {
    private static final Logger LOG = Logger.getInstance(CollectMigration.class);
    static final Map<String, String> INTERMEDIATE_STEPS = EntryStream.of((Object)"java.util.ArrayList", (Object)"", (Object)"java.util.LinkedList", (Object)"", (Object)"java.util.HashSet", (Object)".distinct()", (Object)"java.util.LinkedHashSet", (Object)".distinct()", (Object)"java.util.TreeSet", (Object)".distinct().sorted()").toMap();

    protected CollectMigration(boolean shouldWarn, String methodName) {
        super(shouldWarn, methodName);
    }

    @Nullable
    static PsiType getAddedElementType(PsiMethodCallExpression call) {
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        return resolveResult.getSubstitutor().substitute(parameters2[0].getType());
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiElement result2;
        if (project2 == null) {
            CollectMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            CollectMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            CollectMigration.$$$reportNull$$$0(2);
        }
        PsiStatement loopStatement = tb.getStreamSourceStatement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        CollectTerminal terminal = CollectMigration.extractCollectTerminal(tb, null);
        if (terminal == null) {
            return null;
        }
        String stream = tb.generate() + terminal.generateIntermediate() + terminal.generateTerminal();
        PsiElement toReplace = terminal.getElementToReplace();
        CollectMigration.restoreComments(loopStatement, body2);
        if (toReplace != null) {
            result2 = toReplace.replace((PsiElement)factory.createExpressionFromText(stream, toReplace));
            CollectMigration.removeLoop(loopStatement);
        } else {
            PsiLocalVariable variable = terminal.getTargetVariable();
            LOG.assertTrue(variable != null);
            result2 = CollectMigration.replaceInitializer(loopStatement, (PsiVariable)variable, variable.getInitializer(), stream, terminal.getStatus());
        }
        terminal.cleanUp();
        return result2;
    }

    private static boolean isHashMap(PsiLocalVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiClass initializerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)initializer.getType());
        PsiClass varClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType());
        return initializerClass != null && varClass != null && "java.util.HashMap".equals(initializerClass.getQualifiedName()) && "java.util.Map".equals(varClass.getQualifiedName()) && !ConstructionUtils.isCustomizedEmptyCollectionInitializer(initializer);
    }

    @Nullable
    static PsiLocalVariable extractQualifierVariable(TerminalBlock tb, PsiMethodCallExpression call) {
        PsiExpression qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)qualifierExpression2).resolve(), PsiLocalVariable.class);
        if (variable == null) {
            return null;
        }
        if (tb.getVariable() != variable && VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)call.getArgumentList())) {
            return null;
        }
        return variable;
    }

    @Nullable
    static CollectTerminal extractCollectTerminal(@NotNull TerminalBlock tb, @Nullable List<PsiVariable> nonFinalVariables) {
        GroupingTerminal groupingTerminal;
        if (tb == null) {
            CollectMigration.$$$reportNull$$$0(3);
        }
        if ((groupingTerminal = GroupingTerminal.tryExtract(tb, nonFinalVariables)) != null) {
            return groupingTerminal;
        }
        if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
            return null;
        }
        PsiMethodCallExpression call = tb.getSingleMethodCall();
        if (call == null) {
            return null;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (tb.dependsOn(qualifierExpression2)) {
            return null;
        }
        List<BiFunction> extractors = Arrays.asList(AddingTerminal::tryExtract, GroupingTerminal::tryExtractJava8Style, ToMapTerminal::tryExtract, AddingAllTerminal::tryExtractAddAll);
        CollectTerminal terminal = StreamEx.of(extractors).map(extractor -> {
            if (tb == null) {
                CollectMigration.$$$reportNull$$$0(8);
            }
            return (CollectTerminal)extractor.apply(tb, call);
        }).nonNull().findFirst().orElse(null);
        if (terminal != null) {
            if (terminal.getStatus() == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                return null;
            }
            terminal = CollectMigration.includePostStatements(terminal, PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)tb.getStreamSourceStatement()));
        }
        return terminal;
    }

    @NotNull
    static CollectTerminal includePostStatements(@NotNull CollectTerminal terminal, @Nullable PsiElement nextElement) {
        if (terminal == null) {
            CollectMigration.$$$reportNull$$$0(4);
        }
        if (nextElement == null) {
            CollectTerminal collectTerminal = terminal;
            if (collectTerminal == null) {
                CollectMigration.$$$reportNull$$$0(5);
            }
            return collectTerminal;
        }
        List<BiFunction> wrappers = Arrays.asList(SortingTerminal::tryWrap, ToArrayTerminal::tryWrap, NewListTerminal::tryWrap);
        while (true) {
            CollectTerminal wrapped = null;
            for (BiFunction wrapper : wrappers) {
                wrapped = (CollectTerminal)wrapper.apply(terminal, nextElement);
                if (wrapped == null) continue;
                terminal = wrapped;
                break;
            }
            if (wrapped == null) {
                CollectTerminal collectTerminal = terminal;
                if (collectTerminal == null) {
                    CollectMigration.$$$reportNull$$$0(6);
                }
                return collectTerminal;
            }
            nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextElement);
        }
    }

    @Contract(value="null -> false")
    static boolean hasLambdaCompatibleEmptyInitializer(@Nullable PsiLocalVariable target2) {
        return target2 != null && ConstructionUtils.isEmptyCollectionInitializer(target2.getInitializer()) && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)target2.getInitializer());
    }

    @NotNull
    private static String getCollectionCollector(PsiExpression initializer, PsiType type2) {
        String collector;
        PsiClassType rawVarType;
        PsiType initializerType = initializer.getType();
        PsiClassType rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
        PsiClassType psiClassType = rawVarType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : null;
        if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.ArrayList") && (rawVarType.equalsToText("java.util.List") || rawVarType.equalsToText("java.util.Collection")) && !ConstructionUtils.isCustomizedEmptyCollectionInitializer(initializer)) {
            collector = "toList()";
        } else if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.HashSet") && (rawVarType.equalsToText("java.util.Set") || rawVarType.equalsToText("java.util.Collection")) && !ConstructionUtils.isCustomizedEmptyCollectionInitializer(initializer)) {
            collector = "toSet()";
        } else {
            PsiExpression arg;
            PsiExpressionList argumentList;
            PsiExpression copy = JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createExpressionFromText(initializer.getText(), (PsiElement)initializer);
            if (copy instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)copy).getArgumentList()) != null && (arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])argumentList.getExpressions())) != null && !(arg.getType() instanceof PsiPrimitiveType)) {
                arg.delete();
            }
            collector = "toCollection(() -> " + copy.getText() + ")";
        }
        String string = "java.util.stream.Collectors." + collector;
        if (string == null) {
            CollectMigration.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/CollectMigration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/CollectMigration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "includePostStatements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractCollectTerminal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "includePostStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$extractCollectTerminal$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NewListTerminal
    extends RecreateTerminal {
        private final PsiType myResultType;

        NewListTerminal(CollectTerminal upstream, PsiLocalVariable variable, String intermediate, PsiNewExpression newListExpression, PsiType resultType) {
            super(upstream, variable, intermediate, (PsiExpression)newListExpression);
            this.myResultType = resultType;
        }

        @Override
        public String generateTerminal() {
            return ".collect(" + CollectMigration.getCollectionCollector(this.myCreateExpression, this.myResultType) + ")";
        }

        @Override
        StreamEx<String> fusedElements() {
            PsiJavaCodeReferenceElement reference = ((PsiNewExpression)this.myCreateExpression).getClassReference();
            return this.myUpstream.fusedElements().append((Object)Objects.requireNonNull(reference).getReferenceName());
        }

        @Nullable
        public static NewListTerminal tryWrap(CollectTerminal terminal, PsiElement element) {
            PsiType type2;
            PsiExpression candidate;
            if (terminal.getStatus() == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                return null;
            }
            String intermediateSteps = terminal.getIntermediateStepsFromCollection();
            if (intermediateSteps == null) {
                return null;
            }
            PsiLocalVariable var = null;
            if (element instanceof PsiReturnStatement) {
                candidate = ((PsiReturnStatement)element).getReturnValue();
                type2 = PsiTypesUtil.getMethodReturnType((PsiElement)element);
            } else {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
                if (assignment != null) {
                    candidate = assignment.getRExpression();
                    type2 = assignment.getType();
                } else if (element instanceof PsiDeclarationStatement) {
                    PsiElement[] elements = ((PsiDeclarationStatement)element).getDeclaredElements();
                    if (elements.length != 1 || !(elements[0] instanceof PsiLocalVariable)) {
                        return null;
                    }
                    var = (PsiLocalVariable)elements[0];
                    candidate = var.getInitializer();
                    type2 = var.getType();
                } else {
                    return null;
                }
                if (candidate != null && terminal.targetReferences().anyMatch(ref -> !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)ref, (boolean)false))) {
                    return null;
                }
            }
            if (!(candidate instanceof PsiNewExpression)) {
                return null;
            }
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection")) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)candidate;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1 || !terminal.isTargetReference(args[0])) {
                return null;
            }
            return new NewListTerminal(terminal, var, intermediateSteps, newExpression, type2);
        }
    }

    static class ToArrayTerminal
    extends RecreateTerminal {
        private final String mySupplier;

        ToArrayTerminal(CollectTerminal upstream, PsiLocalVariable variable, String intermediate, PsiMethodCallExpression toArrayExpression, String supplier) {
            super(upstream, variable, intermediate, (PsiExpression)toArrayExpression);
            this.mySupplier = supplier;
        }

        @Override
        public String getMethodName() {
            return "toArray";
        }

        @Override
        public String generateTerminal() {
            return ".toArray(" + this.mySupplier + ")";
        }

        @Override
        StreamEx<String> fusedElements() {
            return this.myUpstream.fusedElements().append((Object)"'toArray'");
        }

        @Contract(value="_, null -> null")
        @Nullable
        public static ToArrayTerminal tryWrap(CollectTerminal terminal, PsiElement element) {
            if (terminal.getStatus() == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                return null;
            }
            if (!(element instanceof PsiExpressionStatement || element instanceof PsiDeclarationStatement || element instanceof PsiReturnStatement)) {
                return null;
            }
            String intermediateSteps = terminal.getIntermediateStepsFromCollection();
            if (intermediateSteps == null) {
                return null;
            }
            List usages = terminal.targetReferences().toList();
            if (usages.isEmpty()) {
                return null;
            }
            PsiMethodCallExpression toArrayCandidate = StreamEx.of((Collection)usages).map(usage -> ExpressionUtils.getCallForQualifier((PsiExpression)ObjectUtils.tryCast((Object)usage, PsiExpression.class))).nonNull().findFirst().orElse(null);
            if (toArrayCandidate == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = toArrayCandidate.getMethodExpression();
            if (!"toArray".equals(methodExpression.getReferenceName())) {
                return null;
            }
            if (!(PsiUtil.skipParenthesizedExprUp((PsiElement)toArrayCandidate.getParent()) instanceof PsiReturnStatement) && usages.stream().anyMatch(usage -> !PsiTreeUtil.isAncestor((PsiElement)toArrayCandidate, (PsiElement)usage, (boolean)false))) {
                return null;
            }
            PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)toArrayCandidate.getParent()), PsiLocalVariable.class);
            String supplier = ToArrayTerminal.extractSupplier(toArrayCandidate, terminal);
            if (supplier == null) {
                return null;
            }
            return new ToArrayTerminal(terminal, var, intermediateSteps, toArrayCandidate, supplier);
        }

        @Nullable
        static String extractSupplier(PsiMethodCallExpression toArrayCandidate, CollectTerminal terminal) {
            PsiExpression[] args = toArrayCandidate.getArgumentList().getExpressions();
            if (args.length == 0) {
                return "";
            }
            if (args.length != 1 || !(args[0] instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newArray = (PsiNewExpression)args[0];
            PsiType arrayType = newArray.getType();
            if (arrayType == null) {
                return null;
            }
            String name2 = arrayType.getCanonicalText();
            PsiExpression[] dimensions = newArray.getArrayDimensions();
            if (dimensions.length != 1) {
                return null;
            }
            if (ExpressionUtils.isZero(dimensions[0])) {
                return name2 + "::new";
            }
            if (!(dimensions[0] instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression maybeSizeCall = (PsiMethodCallExpression)dimensions[0];
            if (!StreamApiMigrationInspection.isCallOf(maybeSizeCall, "java.util.Collection", "size")) {
                return null;
            }
            PsiExpression sizeQualifier = maybeSizeCall.getMethodExpression().getQualifierExpression();
            if (!terminal.isTargetReference(sizeQualifier)) {
                return null;
            }
            return name2 + "::new";
        }
    }

    static abstract class RecreateTerminal
    extends CollectTerminal {
        final CollectTerminal myUpstream;
        private final String myIntermediate;
        final PsiExpression myCreateExpression;

        RecreateTerminal(CollectTerminal upstream, PsiLocalVariable variable, String intermediate, PsiExpression createExpression) {
            super(variable, null, ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE);
            this.myUpstream = upstream;
            this.myIntermediate = intermediate;
            this.myCreateExpression = createExpression;
        }

        @Override
        public boolean isTrivial() {
            return false;
        }

        @Override
        @Nullable
        public PsiElement getElementToReplace() {
            return this.getTargetVariable() == null ? this.myCreateExpression : null;
        }

        @Override
        public String generateIntermediate() {
            return this.myUpstream.generateIntermediate() + this.myIntermediate;
        }

        @Override
        public void cleanUp() {
            PsiLocalVariable variable = this.myUpstream.getTargetVariable();
            if (variable != null && this.myUpstream.getStatus() != ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE) {
                variable.delete();
            }
            this.myUpstream.cleanUp();
        }
    }

    static class SortingTerminal
    extends CollectTerminal {
        private final CollectTerminal myDownstream;
        private final PsiExpression myComparator;
        private final PsiStatement myStatement;

        SortingTerminal(CollectTerminal downstream, PsiStatement statement2, PsiExpression comparator2) {
            super(downstream.getTargetVariable(), null, downstream.getStatus());
            this.myDownstream = downstream;
            this.myStatement = statement2;
            this.myComparator = comparator2;
        }

        @Override
        public String getMethodName() {
            return this.myDownstream.getMethodName();
        }

        @Override
        public String generateIntermediate() {
            return this.myDownstream.generateIntermediate() + ".sorted(" + (this.myComparator == null ? "" : this.myComparator.getText()) + ")";
        }

        @Override
        public String generateTerminal() {
            return this.myDownstream.generateTerminal();
        }

        @Override
        StreamEx<PsiElement> usedElements() {
            return this.myDownstream.usedElements().append((Object)this.myStatement);
        }

        @Override
        public void cleanUp() {
            this.myDownstream.cleanUp();
            this.myStatement.delete();
        }

        @Override
        StreamEx<String> fusedElements() {
            return this.myDownstream.fusedElements().append((Object)"'sort'");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public static CollectTerminal tryWrap(CollectTerminal terminal, PsiElement element) {
            PsiLocalVariable containerVariable = terminal.getTargetVariable();
            if (containerVariable == null || !(element instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)element).getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            if (!"sort".equals(methodExpression.getReferenceName())) {
                return null;
            }
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            PsiExpression containerExpression = null;
            PsiExpression comparatorExpression = null;
            if ("java.util.Collections".equals(containingClass.getQualifiedName()) || "java.util.Arrays".equals(containingClass.getQualifiedName())) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length == 1) {
                    containerExpression = args[0];
                } else {
                    if (args.length != 2) return null;
                    containerExpression = args[0];
                    comparatorExpression = args[1];
                }
            } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
                containerExpression = methodExpression.getQualifierExpression();
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return null;
                }
                comparatorExpression = args[0];
            }
            if (!(containerExpression instanceof PsiReferenceExpression) || !terminal.isTargetReference(containerExpression)) {
                return null;
            }
            if (!ExpressionUtils.isNullLiteral(comparatorExpression)) return new SortingTerminal(terminal, (PsiStatement)((PsiExpressionStatement)element), comparatorExpression);
            comparatorExpression = null;
            return new SortingTerminal(terminal, (PsiStatement)((PsiExpressionStatement)element), comparatorExpression);
        }
    }

    static class ToMapTerminal
    extends CollectTerminal {
        private final PsiMethodCallExpression myMapUpdateCall;
        private final PsiVariable myElementVariable;

        ToMapTerminal(PsiMethodCallExpression call, PsiVariable elementVariable, PsiLocalVariable variable, PsiStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            super(variable, loop, status);
            this.myMapUpdateCall = call;
            this.myElementVariable = elementVariable;
        }

        @Override
        String generateIntermediate() {
            return this.myElementVariable.getType() instanceof PsiPrimitiveType ? ".boxed()" : "";
        }

        @Override
        public String generateTerminal() {
            String merger;
            PsiExpression[] args = this.myMapUpdateCall.getArgumentList().getExpressions();
            LOG.assertTrue(args.length >= 2);
            String methodName = this.myMapUpdateCall.getMethodExpression().getReferenceName();
            LOG.assertTrue(methodName != null);
            Project project2 = this.myMapUpdateCall.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            String aVar = codeStyleManager.suggestUniqueVariableName("a", (PsiElement)this.myMapUpdateCall, true);
            String bVar = codeStyleManager.suggestUniqueVariableName("b", (PsiElement)this.myMapUpdateCall, true);
            switch (methodName) {
                case "put": {
                    merger = "(" + aVar + "," + bVar + ")->" + bVar;
                    break;
                }
                case "putIfAbsent": {
                    merger = "(" + aVar + "," + bVar + ")->" + aVar;
                    break;
                }
                case "merge": {
                    LOG.assertTrue(args.length == 3);
                    merger = args[2].getText();
                    break;
                }
                default: {
                    return null;
                }
            }
            StringBuilder collector = new StringBuilder(".collect(java.util.stream.Collectors.toMap(");
            collector.append(LambdaUtil.createLambda((PsiVariable)this.myElementVariable, (PsiExpression)args[0])).append(',').append(LambdaUtil.createLambda((PsiVariable)this.myElementVariable, (PsiExpression)args[1])).append(',').append(merger);
            PsiLocalVariable variable = Objects.requireNonNull(this.getTargetVariable());
            PsiExpression initializer = variable.getInitializer();
            LOG.assertTrue(initializer != null);
            if (!CollectMigration.isHashMap(variable)) {
                collector.append(",()->").append(initializer.getText());
            }
            collector.append("))");
            return collector.toString();
        }

        @Nullable
        static ToMapTerminal tryExtract(TerminalBlock tb, PsiMethodCallExpression call) {
            if (tb.getCountExpression() != null || !StreamApiMigrationInspection.isCallOf(call, "java.util.Map", "merge", "put", "putIfAbsent")) {
                return null;
            }
            PsiLocalVariable variable = CollectMigration.extractQualifierVariable(tb, call);
            if (!CollectMigration.hasLambdaCompatibleEmptyInitializer(variable)) {
                return null;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getStreamSourceStatement());
            return new ToMapTerminal(call, tb.getVariable(), variable, tb.getStreamSourceStatement(), status);
        }
    }

    static class GroupingTerminal
    extends CollectTerminal {
        private static final CallMatcher LIST_ADD = CallMatcher.instanceCall("java.util.List", "add").parameterCount(1);
        private static final CallMatcher COMPUTE_IF_ABSENT = CallMatcher.instanceCall("java.util.Map", "computeIfAbsent").parameterCount(2);
        private final AddingTerminal myDownstream;
        private final PsiExpression myKeyExpression;

        GroupingTerminal(@NotNull AddingTerminal downstream, @NotNull PsiLocalVariable target2, @NotNull PsiExpression expression2, @NotNull ControlFlowUtils.InitializerUsageStatus status) {
            if (downstream == null) {
                GroupingTerminal.$$$reportNull$$$0(0);
            }
            if (target2 == null) {
                GroupingTerminal.$$$reportNull$$$0(1);
            }
            if (expression2 == null) {
                GroupingTerminal.$$$reportNull$$$0(2);
            }
            if (status == null) {
                GroupingTerminal.$$$reportNull$$$0(3);
            }
            super(target2, null, status);
            this.myDownstream = downstream;
            this.myKeyExpression = expression2;
        }

        @Override
        public boolean isTrivial() {
            return false;
        }

        @Override
        String generateIntermediate() {
            return this.myDownstream.myElement.getType() instanceof PsiPrimitiveType ? ".boxed()" : "";
        }

        @Override
        public String generateTerminal() {
            String downstreamCollector = this.myDownstream.generateCollector();
            PsiVariable elementVariable = this.myDownstream.getElementVariable();
            if (!ExpressionUtils.isReferenceTo(this.myDownstream.getMapping(), this.myDownstream.getElementVariable())) {
                downstreamCollector = "java.util.stream.Collectors.mapping(" + this.myDownstream.getElementVariable().getName() + "->" + this.myDownstream.getMapping().getText() + "," + downstreamCollector + ")";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(".collect(java.util.stream.Collectors.groupingBy(").append(LambdaUtil.createLambda((PsiVariable)elementVariable, (PsiExpression)this.myKeyExpression));
            PsiLocalVariable variable = Objects.requireNonNull(this.getTargetVariable());
            PsiExpression initializer = variable.getInitializer();
            LOG.assertTrue(initializer != null);
            if (!CollectMigration.isHashMap(variable)) {
                builder.append(",()->").append(initializer.getText()).append(",").append(downstreamCollector);
            } else if (!"java.util.stream.Collectors.toList()".equals(downstreamCollector)) {
                builder.append(",").append(downstreamCollector);
            }
            builder.append("))");
            return builder.toString();
        }

        @Nullable
        static GroupingTerminal tryExtract(@NotNull TerminalBlock tb, @Nullable List<PsiVariable> nonFinalVariables) {
            PsiStatement[] statements;
            if (tb == null) {
                GroupingTerminal.$$$reportNull$$$0(4);
            }
            if ((statements = tb.getStatements()).length == 1) {
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                PsiMethodCallExpression call = tb.getSingleExpression(PsiMethodCallExpression.class);
                return GroupingTerminal.tryExtractJava8Style(tb, call);
            }
            if (statements.length == 2) {
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                return GroupingTerminal.tryExtractWithIntermediateVariable(tb);
            }
            return GroupingTerminal.tryExtractJava7Style(tb, statements, nonFinalVariables);
        }

        @Nullable
        private static GroupingTerminal tryExtractJava7Style(@NotNull TerminalBlock terminalBlock, @NotNull PsiStatement[] statements, @Nullable List<PsiVariable> nonFinalVariables) {
            if (terminalBlock == null) {
                GroupingTerminal.$$$reportNull$$$0(5);
            }
            if (statements == null) {
                GroupingTerminal.$$$reportNull$$$0(6);
            }
            if (nonFinalVariables != null && nonFinalVariables.size() != 1) {
                return null;
            }
            if (statements.length != 3) {
                return null;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statements[1], PsiIfStatement.class);
            if (ifStatement == null) {
                return null;
            }
            Java8MigrationUtils.MapCheckCondition condition2 = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)ifStatement, false);
            if (condition2 == null || !condition2.hasVariable()) {
                return null;
            }
            PsiStatement existsBranch = ControlFlowUtils.stripBraces(condition2.getExistsBranch(ifStatement.getThenBranch(), ifStatement.getElseBranch()));
            PsiStatement noneBranch = ControlFlowUtils.stripBraces(condition2.getNoneBranch(ifStatement.getThenBranch(), ifStatement.getElseBranch()));
            if (existsBranch != null) {
                return null;
            }
            PsiExpression lambdaCandidate = Java8MigrationUtils.extractLambdaCandidate(condition2, noneBranch);
            if (lambdaCandidate == null) {
                return null;
            }
            PsiExpressionStatement additionToListStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statements[2], PsiExpressionStatement.class);
            if (additionToListStatement == null) {
                return null;
            }
            PsiReferenceExpression valueReference = condition2.getValueReference();
            if (valueReference == null) {
                return null;
            }
            PsiLocalVariable listVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)valueReference.resolve(), PsiLocalVariable.class);
            if (nonFinalVariables != null && !nonFinalVariables.get(0).equals(listVar) || listVar == null || !InheritanceUtil.isInheritor((PsiType)listVar.getType(), (String)"java.util.List")) {
                return null;
            }
            PsiLocalVariable mapVariable = ExpressionUtils.resolveLocalVariable(condition2.getMapExpression());
            if (mapVariable == null) {
                return null;
            }
            PsiMethodCallExpression addCall = GroupingTerminal.extractAddMethod(terminalBlock, additionToListStatement);
            if (addCall == null) {
                return null;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)mapVariable, terminalBlock.getStreamSourceStatement());
            AddingTerminal adding = new AddingTerminal(listVar.getType(), lambdaCandidate, terminalBlock.getVariable(), addCall);
            return new GroupingTerminal(adding, mapVariable, condition2.getKeyExpression(), status);
        }

        @Nullable
        private static PsiMethodCallExpression extractAddMethod(@NotNull TerminalBlock terminalBlock, @NotNull PsiExpressionStatement additionToListStatement) {
            PsiMethodCallExpression additionToList;
            if (terminalBlock == null) {
                GroupingTerminal.$$$reportNull$$$0(7);
            }
            if (additionToListStatement == null) {
                GroupingTerminal.$$$reportNull$$$0(8);
            }
            if (!LIST_ADD.test(additionToList = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)additionToListStatement.getExpression(), PsiMethodCallExpression.class))) {
                return null;
            }
            PsiExpression[] additionArgs = additionToList.getArgumentList().getExpressions();
            PsiExpression arg = additionArgs[0];
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)arg, PsiReferenceExpression.class);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable savedVar = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            if (savedVar == null) {
                return null;
            }
            if (!savedVar.equals(terminalBlock.getVariable())) {
                return null;
            }
            return additionToList;
        }

        @Nullable
        public static GroupingTerminal tryExtractJava8Style(@NotNull TerminalBlock tb, @Nullable PsiMethodCallExpression call) {
            if (tb == null) {
                GroupingTerminal.$$$reportNull$$$0(9);
            }
            if (call == null) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return GroupingTerminal.tryExtractJava8Style(tb, (PsiMethodCallExpression)ObjectUtils.tryCast((Object)qualifier, PsiMethodCallExpression.class), (PsiMethodCallExpression)ObjectUtils.tryCast((Object)call, PsiMethodCallExpression.class));
        }

        @Nullable
        private static GroupingTerminal tryExtractWithIntermediateVariable(@NotNull TerminalBlock terminalBlock) {
            PsiStatement[] statements;
            PsiDeclarationStatement assignmentStmt;
            if (terminalBlock == null) {
                GroupingTerminal.$$$reportNull$$$0(10);
            }
            if ((assignmentStmt = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)(statements = terminalBlock.getStatements())[0], PsiDeclarationStatement.class)) == null) {
                return null;
            }
            PsiElement[] elements = assignmentStmt.getDeclaredElements();
            if (elements.length != 1) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
            if (variable == null) {
                return null;
            }
            PsiExpressionStatement addStmt = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statements[1], PsiExpressionStatement.class);
            if (addStmt == null) {
                return null;
            }
            PsiMethodCallExpression maybeAddCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)addStmt.getExpression(), PsiMethodCallExpression.class);
            if (maybeAddCall == null) {
                return null;
            }
            PsiExpression qualifier = maybeAddCall.getMethodExpression().getQualifierExpression();
            if (!ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)variable)) {
                return null;
            }
            return GroupingTerminal.tryExtractJava8Style(terminalBlock, (PsiMethodCallExpression)ObjectUtils.tryCast((Object)variable.getInitializer(), PsiMethodCallExpression.class), maybeAddCall);
        }

        @Nullable
        public static GroupingTerminal tryExtractJava8Style(@NotNull TerminalBlock tb, @Nullable PsiMethodCallExpression computeIfAbsentCall, @Nullable PsiMethodCallExpression addCall) {
            PsiLocalVariable variable;
            if (tb == null) {
                GroupingTerminal.$$$reportNull$$$0(11);
            }
            if (!LIST_ADD.test(addCall) || !COMPUTE_IF_ABSENT.test(computeIfAbsentCall)) {
                return null;
            }
            PsiExpression[] args = computeIfAbsentCall.getArgumentList().getExpressions();
            if (args.length != 2 || !(args[1] instanceof PsiLambdaExpression)) {
                return null;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)args[1];
            PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (ConstructionUtils.isEmptyCollectionInitializer(body2) && CollectMigration.hasLambdaCompatibleEmptyInitializer(variable = CollectMigration.extractQualifierVariable(tb, computeIfAbsentCall))) {
                PsiType mapType = variable.getType();
                PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)1, (boolean)false);
                if (valueType == null) {
                    return null;
                }
                AddingTerminal adding = new AddingTerminal(valueType, body2, tb.getVariable(), addCall);
                ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getStreamSourceStatement());
                return new GroupingTerminal(adding, variable, args[0], status);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "downstream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 4: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tb";
                    break;
                }
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminalBlock";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statements";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionToListStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/streamMigration/CollectMigration$GroupingTerminal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryExtract";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryExtractJava7Style";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractAddMethod";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryExtractJava8Style";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryExtractWithIntermediateVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AddingAllTerminal
    extends AddingTerminal {
        private final PsiMethodCallExpression myAddAllCall;

        AddingAllTerminal(PsiLocalVariable target2, PsiVariable element, PsiMethodCallExpression addAllCall, PsiStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            super(target2, element, null, loop, status);
            this.myAddAllCall = addAllCall;
        }

        @Override
        public String generateIntermediate() {
            PsiType[] typeParameters = this.myAddAllCall.getMethodExpression().getTypeParameters();
            String generic = "";
            if (typeParameters.length == 1) {
                generic = "<" + typeParameters[0].getCanonicalText() + ">";
            }
            String method = MethodCallUtils.isVarArgCall(this.myAddAllCall) ? "java.util.stream.Stream." + generic + "of" : "java.util.Arrays." + generic + "stream";
            String lambda2 = this.myElement.getName() + "->" + method + "(" + ((StreamEx)StreamEx.of((Object[])this.myAddAllCall.getArgumentList().getExpressions()).skip(1L)).map(PsiElement::getText).joining((CharSequence)",") + ")";
            return this.myElement.getType() instanceof PsiPrimitiveType ? ".mapToObj(" + lambda2 + ").flatMap(" + "java.util.function.Function" + ".identity())" : ".flatMap(" + lambda2 + ")";
        }

        @Nullable
        static AddingAllTerminal tryExtractAddAll(TerminalBlock tb, PsiMethodCallExpression call) {
            if (tb.getCountExpression() != null || !MethodCallUtils.isCallToStaticMethod(call, "java.util.Collections", "addAll", 2)) {
                return null;
            }
            Object[] args = call.getArgumentList().getExpressions();
            if (args.length < 2) {
                return null;
            }
            PsiReferenceExpression collectionReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)args[0], PsiReferenceExpression.class);
            if (collectionReference == null || tb.dependsOn((PsiExpression)collectionReference)) {
                return null;
            }
            PsiLocalVariable target2 = (PsiLocalVariable)ObjectUtils.tryCast((Object)collectionReference.resolve(), PsiLocalVariable.class);
            if (target2 == null || ((StreamEx)StreamEx.of((Object[])args).skip(1L)).anyMatch(arg -> VariableAccessUtils.variableIsUsed((PsiVariable)target2, (PsiElement)arg))) {
                return null;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)target2, tb.getStreamSourceStatement());
            return new AddingAllTerminal(target2, tb.getVariable(), call, tb.getStreamSourceStatement(), status);
        }
    }

    static class AddingTerminal
    extends CollectTerminal {
        final PsiType myTargetType;
        final PsiExpression myInitializer;
        final PsiVariable myElement;
        final PsiMethodCallExpression myAddCall;

        AddingTerminal(@NotNull PsiLocalVariable target2, PsiVariable element, PsiMethodCallExpression addCall, PsiStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            if (target2 == null) {
                AddingTerminal.$$$reportNull$$$0(0);
            }
            super(target2, loop, CollectMigration.hasLambdaCompatibleEmptyInitializer(target2) ? status : ControlFlowUtils.InitializerUsageStatus.UNKNOWN);
            this.myTargetType = target2.getType();
            this.myInitializer = target2.getInitializer();
            this.myElement = element;
            this.myAddCall = addCall;
        }

        AddingTerminal(@NotNull PsiType targetType, PsiExpression initializer, PsiVariable element, PsiMethodCallExpression addCall) {
            if (targetType == null) {
                AddingTerminal.$$$reportNull$$$0(1);
            }
            super(null, null, ControlFlowUtils.InitializerUsageStatus.UNKNOWN);
            this.myTargetType = targetType;
            this.myInitializer = initializer;
            this.myElement = element;
            this.myAddCall = addCall;
        }

        PsiVariable getElementVariable() {
            return this.myElement;
        }

        PsiExpression getMapping() {
            return this.myAddCall.getArgumentList().getExpressions()[0];
        }

        @Override
        public String generateIntermediate() {
            PsiType addedType = CollectMigration.getAddedElementType(this.myAddCall);
            PsiExpression mapping = this.getMapping();
            if (addedType == null) {
                addedType = mapping.getType();
            }
            return StreamRefactoringUtil.generateMapOperation(this.myElement, addedType, (PsiElement)mapping);
        }

        public String generateCollector() {
            return CollectMigration.getCollectionCollector(this.myInitializer, this.myTargetType);
        }

        @Override
        public String generateTerminal() {
            return ".collect(" + this.generateCollector() + ")";
        }

        @Nullable
        static AddingTerminal tryExtract(TerminalBlock tb, PsiMethodCallExpression call) {
            if (!StreamApiMigrationInspection.isCallOf(call, "java.util.Collection", "add")) {
                return null;
            }
            PsiExpression qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
            if (qualifierExpression2 == null) {
                return null;
            }
            PsiExpression count = tb.getCountExpression();
            PsiLocalVariable variable = CollectMigration.extractQualifierVariable(tb, call);
            if (variable != null) {
                ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getStreamSourceStatement());
                AddingTerminal terminal = new AddingTerminal(variable, tb.getVariable(), call, tb.getStreamSourceStatement(), status);
                if (count == null) {
                    return terminal;
                }
                if (!(count instanceof PsiMethodCallExpression)) {
                    return null;
                }
                PsiMethodCallExpression sizeCall = (PsiMethodCallExpression)count;
                PsiExpression sizeQualifier = sizeCall.getMethodExpression().getQualifierExpression();
                if (StreamApiMigrationInspection.isCallOf(sizeCall, "java.util.Collection", "size") && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(sizeQualifier, qualifierExpression2) && InheritanceUtil.isInheritor((PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType()), (String)"java.util.List")) {
                    return terminal;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/streamMigration/CollectMigration$AddingTerminal";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class CollectTerminal {
        private final PsiLocalVariable myTargetVariable;
        private final ControlFlowUtils.InitializerUsageStatus myStatus;
        private final PsiStatement myLoop;

        protected CollectTerminal(PsiLocalVariable variable, PsiStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            this.myTargetVariable = variable;
            this.myLoop = loop;
            this.myStatus = status;
        }

        @Nullable
        PsiElement getElementToReplace() {
            return null;
        }

        String getMethodName() {
            return "collect";
        }

        @Nullable
        PsiLocalVariable getTargetVariable() {
            return this.myTargetVariable;
        }

        abstract String generateIntermediate();

        StreamEx<? extends PsiExpression> targetReferences() {
            List usedElements = this.usedElements().toList();
            return (StreamEx)StreamEx.of((Collection)ReferencesSearch.search((PsiElement)this.myTargetVariable).findAll()).select(PsiReferenceExpression.class).filter(ref -> usedElements.stream().noneMatch(allowedUsage -> PsiTreeUtil.isAncestor((PsiElement)allowedUsage, (PsiElement)ref, (boolean)false)));
        }

        boolean isTargetReference(PsiExpression expression2) {
            return ExpressionUtils.isReferenceTo(expression2, (PsiVariable)this.getTargetVariable());
        }

        String getIntermediateStepsFromCollection() {
            PsiLocalVariable variable = this.getTargetVariable();
            if (variable == null) {
                return null;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)initializer.getType());
            if (aClass == null) {
                return null;
            }
            return INTERMEDIATE_STEPS.get(aClass.getQualifiedName());
        }

        abstract String generateTerminal();

        StreamEx<PsiElement> usedElements() {
            return StreamEx.ofNullable((Object)this.myLoop);
        }

        StreamEx<String> fusedElements() {
            return StreamEx.empty();
        }

        public ControlFlowUtils.InitializerUsageStatus getStatus() {
            return this.myStatus;
        }

        void cleanUp() {
        }

        boolean isTrivial() {
            return this.generateIntermediate().isEmpty();
        }
    }
}

