/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class FindFirstMigration
extends BaseStreamApiMigration {
    FindFirstMigration(boolean shouldWarn) {
        super(shouldWarn, "findFirst()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        if (project2 == null) {
            FindFirstMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            FindFirstMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            FindFirstMigration.$$$reportNull$$$0(2);
        }
        PsiStatement statement2 = tb.getSingleStatement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiStatement loopStatement = tb.getStreamSourceStatement();
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression value2 = returnStatement.getReturnValue();
            if (value2 == null) {
                return null;
            }
            PsiReturnStatement nextReturnStatement = ControlFlowUtils.getNextReturnStatement(loopStatement);
            if (nextReturnStatement == null) {
                return null;
            }
            PsiExpression orElseExpression = nextReturnStatement.getReturnValue();
            if (!ExpressionUtils.isSimpleExpression(orElseExpression)) {
                return null;
            }
            String stream = FindFirstMigration.generateOptionalUnwrap(tb, value2, orElseExpression, PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement));
            FindFirstMigration.restoreComments(loopStatement, body2);
            boolean sibling = nextReturnStatement.getParent() == loopStatement.getParent();
            PsiElement replacement = loopStatement.replace((PsiElement)elementFactory.createStatementFromText("return " + stream + ";", (PsiElement)loopStatement));
            if (sibling || !ControlFlowUtils.isReachable((PsiStatement)nextReturnStatement)) {
                nextReturnStatement.delete();
            }
            return replacement;
        }
        PsiStatement[] statements = tb.getStatements();
        if (statements.length != 2) {
            return null;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
        if (assignment == null) {
            if (!(statements[0] instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
            FindFirstMigration.restoreComments(loopStatement, body2);
            return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(tb.generate() + ".findFirst().ifPresent(" + LambdaUtil.createLambda((PsiVariable)tb.getVariable(), (PsiExpression)expression2) + ");", (PsiElement)loopStatement));
        }
        PsiReferenceExpression lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (lValue == null) {
            return null;
        }
        PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lValue.resolve(), PsiVariable.class);
        if (var == null) {
            return null;
        }
        PsiExpression value3 = assignment.getRExpression();
        if (value3 == null) {
            return null;
        }
        FindFirstMigration.restoreComments(loopStatement, body2);
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(var, loopStatement);
        PsiExpression initializer = var.getInitializer();
        PsiReferenceExpression falseExpression = lValue;
        if (status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN && (status != ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE || ExpressionUtils.isSimpleExpression(initializer))) {
            falseExpression = initializer;
        } else {
            PsiElement maybeAssignment = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)loopStatement);
            PsiExpression prevRValue = ExpressionUtils.getAssignmentTo(maybeAssignment, var);
            if (prevRValue != null) {
                maybeAssignment.delete();
                falseExpression = prevRValue;
            }
        }
        String replacementText = FindFirstMigration.generateOptionalUnwrap(tb, value3, (PsiExpression)falseExpression, var.getType());
        return FindFirstMigration.replaceInitializer(loopStatement, var, initializer, replacementText, status);
    }

    private static String generateOptionalUnwrap(TerminalBlock tb, PsiExpression trueExpression, PsiExpression falseExpression, PsiType targetType) {
        String qualifier = tb.generate() + ".findFirst()";
        return OptionalUtil.generateOptionalUnwrap(qualifier, tb.getVariable(), trueExpression, falseExpression, targetType, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/FindFirstMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

