/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ForEachMigration
extends BaseStreamApiMigration {
    private static final Logger LOG = Logger.getInstance(ForEachMigration.class);

    protected ForEachMigration(boolean shouldWarn, String forEachMethodName) {
        super(shouldWarn, forEachMethodName);
    }

    @Nullable
    static PsiExpression tryExtractMapExpression(TerminalBlock tb) {
        PsiMethodCallExpression call = tb.getSingleMethodCall();
        if (call == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        if (ExpressionUtils.isReferenceTo(arg, tb.getVariable())) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (tb.dependsOn(qualifier) || VariableAccessUtils.variableIsUsed(tb.getVariable(), (PsiElement)qualifier) || StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(arg, qualifier) || !LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)qualifier)) {
            return null;
        }
        return arg;
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiTypeElement typeElement;
        if (project2 == null) {
            ForEachMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            ForEachMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            ForEachMigration.$$$reportNull$$$0(2);
        }
        PsiStatement loopStatement = tb.getStreamSourceStatement();
        ForEachMigration.restoreComments(loopStatement, body2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiExpression mapExpression = ForEachMigration.tryExtractMapExpression(tb);
        if (mapExpression != null) {
            PsiMethodCallExpression call = tb.getSingleMethodCall();
            LOG.assertTrue(call != null);
            PsiType addedType = CollectMigration.getAddedElementType(call);
            if (addedType == null) {
                addedType = call.getType();
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, addedType, false);
            if (suggestedNameInfo.names.length == 0) {
                suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, "item", null, null, false);
            }
            String varName = codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)call, (boolean)false).names[0];
            String streamText = tb.add(new StreamApiMigrationInspection.MapOp(mapExpression, tb.getVariable(), addedType)).generate();
            String forEachBody = varName + "->" + call.getMethodExpression().getText() + "(" + varName + ")";
            String callText = streamText + "." + this.getReplacement() + "(" + forEachBody + ");";
            return loopStatement.replace((PsiElement)factory.createStatementFromText(callText, (PsiElement)loopStatement));
        }
        tb.replaceContinueWithReturn(factory);
        String stream = tb.generate(true) + "." + this.getReplacement() + "(";
        PsiElement block = tb.convertToElement(factory);
        String functionalExpressionText = tb.getVariable().getName() + " -> " + ForEachMigration.wrapInBlock(block);
        PsiExpressionStatement callStatement = (PsiExpressionStatement)factory.createStatementFromText(stream + functionalExpressionText + ");", (PsiElement)loopStatement);
        callStatement = (PsiExpressionStatement)loopStatement.replace((PsiElement)callStatement);
        PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
        LOG.assertTrue(argumentList != null, (Object)callStatement.getText());
        PsiExpression[] expressions2 = argumentList.getExpressions();
        LOG.assertTrue(expressions2.length == 1);
        if (expressions2[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions2[0]).getFunctionalInterfaceType() == null && (typeElement = tb.getVariable().getTypeElement()) != null) {
            String typedVariable = typeElement.getText() + " " + tb.getVariable().getName();
            callStatement = (PsiExpressionStatement)callStatement.replace((PsiElement)factory.createStatementFromText(stream + "(" + typedVariable + ") -> " + ForEachMigration.wrapInBlock(block) + ");", (PsiElement)callStatement));
        }
        return callStatement;
    }

    @Contract(value="null -> !null")
    private static String wrapInBlock(PsiElement block) {
        if (block instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)block).getExpression().getText();
        }
        if (block instanceof PsiCodeBlock) {
            return block.getText();
        }
        return "{" + block.getText() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/ForEachMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

