/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.Equality;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolPresentation
implements InspectionToolPresentation {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolPresentation.class);
    @NotNull
    private final InspectionToolWrapper myToolWrapper;
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    protected InspectionNode myToolNode;
    private final Object myLock;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements;
    protected final Map<String, Set<RefEntity>> myContents;
    private final Set<RefModule> myModulesProblems;
    private DescriptorComposer myComposer;
    private volatile boolean isDisposed;

    public DefaultInspectionToolPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myProblemElements = DefaultInspectionToolPresentation.createBidiMap();
        this.mySuppressedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myResolvedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myExcludedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myContents = Collections.synchronizedMap(new HashMap(1));
        this.myModulesProblems = Collections.synchronizedSet(ContainerUtil.newIdentityTroveSet());
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    @Override
    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity;
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(2);
        }
        if ((entity = this.myProblemElements.removeValue(descriptor2)) != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor2) {
        return this.myResolvedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        Collection<RefEntity> collection = this.myResolvedElements.keys();
        if (collection == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(4);
        }
        this.mySuppressedElements.put(this.myProblemElements.removeValue(descriptor2), (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed;
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(5);
        }
        if ((removed = this.myProblemElements.remove(entity)) != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public boolean isSuppressed(RefEntity element) {
        return this.mySuppressedElements.containsKey(element);
    }

    @Override
    public boolean isSuppressed(CommonProblemDescriptor descriptor2) {
        return this.mySuppressedElements.containsValue(descriptor2);
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element) {
        PsiFile psiElement;
        if (element == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(6);
        }
        if ((psiElement = ((RefElement)element.getRefManager().getRefinedElement((RefEntity)element)).getPointer().getContainingFile()) != null) {
            GlobalInspectionContextImpl context = this.getContext();
            String shortName = this.getSeverityDelegateName();
            Tools tools = context.getTools().get(shortName);
            if (tools != null) {
                for (ScopeToolState state : tools.getTools()) {
                    InspectionToolWrapper toolWrapper = state.getTool();
                    if (toolWrapper != this.getToolWrapper()) continue;
                    return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                }
            }
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
            HighlightDisplayLevel level = profile2.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
            return level.getSeverity();
        }
        return null;
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(7);
        }
        return this.myExcludedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(8);
        }
        return Comparing.equal((Object[])this.myExcludedElements.get(entity), (Object[])this.myProblemElements.get(entity));
    }

    @Override
    public void amnesty(@NotNull RefEntity element) {
        if (element == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(9);
        }
        this.myExcludedElements.remove(element);
    }

    @Override
    public void exclude(@NotNull RefEntity element) {
        if (element == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(10);
        }
        this.myExcludedElements.put(element, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(11);
        }
        this.myExcludedElements.removeValue(descriptor2);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(12);
        }
        RefEntity entity = (RefEntity)ObjectUtils.notNull((Object)this.myProblemElements.getKeyFor(descriptor2), () -> {
            if (descriptor2 == null) {
                DefaultInspectionToolPresentation.$$$reportNull$$$0(53);
            }
            return this.myResolvedElements.getKeyFor(descriptor2);
        });
        this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    protected static String getTextAttributeKey(@NotNull Project project2, @NotNull HighlightSeverity severity, @NotNull ProblemHighlightType highlightType) {
        if (project2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(13);
        }
        if (severity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(14);
        }
        if (highlightType == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(15);
        }
        if (highlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL && severity == HighlightSeverity.ERROR) {
            return HighlightInfoType.WRONG_REF.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName();
        }
        SeverityRegistrar registrar = ProjectInspectionProfileManager.getInstance(project2).getSeverityRegistrar();
        return registrar.getHighlightInfoTypeBySeverity(severity).getAttributesKey().getExternalName();
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(16);
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.getContext().getRefManager();
        if (refManager == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(17);
        }
        return refManager;
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(18);
        }
        return globalInspectionContextImpl;
    }

    @Override
    public void exportResults(final @NotNull Element parentNode, final @NotNull Predicate<RefEntity> excludedEntities, final @NotNull Predicate<CommonProblemDescriptor> excludedDescriptors) {
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(19);
        }
        if (excludedEntities == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(20);
        }
        if (excludedDescriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(21);
        }
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (elem == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolPresentation.this.exportResults(parentNode, elem, (Predicate<CommonProblemDescriptor>)excludedDescriptors);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$1", "visitElement"));
            }
        });
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        if (descriptions == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(22);
        }
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (descriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(23);
        }
        if (refElement == null) {
            return;
        }
        if (descriptors.length == 0) {
            return;
        }
        if (filterSuppressed) {
            if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper)) {
                this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
            } else {
                this.writeOutput(descriptors, refElement);
            }
        } else {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
        }
        GlobalInspectionContextImpl context = this.getContext();
        if (context.isViewClosed() || !(refElement instanceof RefElement)) {
            return;
        }
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper && !ApplicationManager.getApplication().isUnitTestMode()) {
            context.initializeViewIfNeed().doWhenDone(() -> {
                if (descriptors == null) {
                    DefaultInspectionToolPresentation.$$$reportNull$$$0(52);
                }
                context.getView().addProblemDescriptors(this.myToolWrapper, refElement, descriptors);
            });
        }
    }

    public static CommonProblemDescriptor[] mergeDescriptors(CommonProblemDescriptor[] problems1, CommonProblemDescriptor[] problems2) {
        if (problems1 == null) {
            return problems2;
        }
        if (problems2 == null) {
            return problems1;
        }
        CommonProblemDescriptor[] out = new CommonProblemDescriptor[problems1.length + problems2.length];
        int o = problems1.length;
        Equality equality = (o1, o2) -> {
            if (o1 instanceof ProblemDescriptor) {
                ProblemDescriptorBase p1 = (ProblemDescriptorBase)o1;
                ProblemDescriptorBase p2 = (ProblemDescriptorBase)o2;
                if (!Comparing.equal((String)p1.getDescriptionTemplate(), (String)p2.getDescriptionTemplate())) {
                    return false;
                }
                if (!Comparing.equal((Object)p1.getTextRange(), (Object)p2.getTextRange())) {
                    return false;
                }
                if (!Comparing.equal((Object)p1.getHighlightType(), (Object)p2.getHighlightType())) {
                    return false;
                }
                if (!Comparing.equal((Object)p1.getProblemGroup(), (Object)p2.getProblemGroup())) {
                    return false;
                }
                if (!Comparing.equal((Object)p1.getLineNumber(), (Object)p2.getLineNumber())) {
                    return false;
                }
                if (!Comparing.equal((Object)p1.getStartElement(), (Object)p2.getStartElement())) {
                    return false;
                }
                if (!Comparing.equal((Object)p1.getEndElement(), (Object)p2.getEndElement())) {
                    return false;
                }
            } else if (!o1.toString().equals(o2.toString())) {
                return false;
            }
            return true;
        };
        for (CommonProblemDescriptor descriptor2 : problems2) {
            if (ArrayUtil.indexOf((Object[])problems1, (Object)descriptor2, (Equality)equality) != -1) continue;
            out[o++] = descriptor2;
        }
        System.arraycopy(problems1, 0, out, 0, problems1.length);
        return Arrays.copyOfRange(out, 0, o);
    }

    @Override
    public InspectionNode getToolNode() {
        return this.myToolNode;
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeOutput(@NotNull CommonProblemDescriptor[] descriptions, @NotNull RefEntity refElement) {
        if (descriptions == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(24);
        }
        if (refElement == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(25);
        }
        Element parentNode = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
        this.exportResults(descriptions, refElement, parentNode, d -> false);
        List list2 = parentNode.getChildren();
        String ext = ".xml";
        String fileName = this.myContext.getOutputPath() + File.separator + this.myToolWrapper.getShortName() + ".xml";
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.getContext().getProject());
        try (PrintWriter printWriter = null;){
            FileUtil.createDirectory((File)new File(this.myContext.getOutputPath()));
            File file2 = new File(fileName);
            StringWriter writer = new StringWriter();
            if (!file2.exists()) {
                writer.append("<").append(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0])).append(" is_local_tool=\"").append(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper)).append("\">\n");
            }
            for (Element element : list2) {
                pathMacroManager.collapsePaths(element);
                JDOMUtil.writeElement((Element)element, (Writer)writer, (String)"\n");
            }
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), CharsetToolkit.UTF8_CHARSET)));
            printWriter.append("\n");
            printWriter.append(writer.toString());
        }
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        Collection<CommonProblemDescriptor> collection = this.myProblemElements.getValues();
        if (collection == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(26);
        }
        return collection;
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(27);
        }
        this.myProblemElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        this.isDisposed = true;
    }

    @Nullable
    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] problems;
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(28);
        }
        if ((problems = this.getProblemElements().getOrDefault(refEntity, null)) == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        DescriptorComposer descriptorComposer = this.myComposer;
        if (descriptorComposer == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(29);
        }
        return descriptorComposer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportResults(@NotNull Element parentNode, @NotNull RefEntity refEntity, @NotNull Predicate<CommonProblemDescriptor> isDescriptorExcluded) {
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(30);
        }
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(31);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(32);
        }
        Object object = this.myLock;
        synchronized (object) {
            CommonProblemDescriptor[] descriptions;
            if (this.getProblemElements().containsKey(refEntity) && (descriptions = this.getDescriptions(refEntity)) != null) {
                this.exportResults(descriptions, refEntity, parentNode, isDescriptorExcluded);
            }
        }
    }

    private void exportResults(@NotNull CommonProblemDescriptor[] descriptors, @NotNull RefEntity refEntity, @NotNull Element parentNode, @NotNull Predicate<CommonProblemDescriptor> isDescriptorExcluded) {
        if (descriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(33);
        }
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(34);
        }
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(35);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(36);
        }
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            if (isDescriptorExcluded.test(descriptor2)) continue;
            String template = descriptor2.getDescriptionTemplate();
            int line = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getLineNumber() : -1;
            PsiElement psiElement = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? ProblemDescriptorUtil.extractHighlightedText(descriptor2, psiElement) : "")), (String)" #loc ", (String)" ");
            Element element = refEntity.getRefManager().export(refEntity, parentNode, line);
            if (element == null) {
                return;
            }
            Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            problemClassElement.addContent(this.myToolWrapper.getDisplayName());
            HighlightSeverity severity = InspectionToolPresentation.getSeverity(refEntity, psiElement, this);
            if (severity != null) {
                ProblemHighlightType problemHighlightType = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getHighlightType() : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String attributeKey = DefaultInspectionToolPresentation.getTextAttributeKey(this.getRefManager().getProject(), severity, problemHighlightType);
                problemClassElement.setAttribute("severity", severity.myName);
                problemClassElement.setAttribute("attribute_key", attributeKey);
            }
            element.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor2.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element("hints");
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element("hint");
                        hintElement.setAttribute("value", hint);
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                }
            }
            try {
                Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
                descriptionElement.addContent(problemText);
                element.addContent(descriptionElement);
            }
            catch (IllegalDataException e) {
                System.out.println("Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName());
            }
        }
    }

    @Override
    public synchronized boolean hasReportedProblems() {
        return !this.myContents.isEmpty() || !this.myModulesProblems.isEmpty();
    }

    @Override
    public synchronized void updateContent() {
        this.myContents.clear();
        this.myModulesProblems.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Collection<RefEntity> elements = this.getProblemElements().keys();
        for (RefEntity element : elements) {
            if (this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS && (this.isProblemResolved(element) || this.isSuppressed(element) || this.isExcluded(element))) continue;
            if (element instanceof RefModule) {
                this.myModulesProblems.add((RefModule)element);
                continue;
            }
            String groupName = element instanceof RefElement ? element.getRefManager().getGroupName((RefElement)element) : element.getQualifiedName();
            this.registerContentEntry(element, groupName);
        }
    }

    protected void registerContentEntry(RefEntity element, String packageName) {
        Set content = this.myContents.computeIfAbsent(packageName, k -> new com.intellij.util.containers.HashSet());
        content.add(element);
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        Map<String, Set<RefEntity>> map = this.myContents;
        if (map == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(37);
        }
        return map;
    }

    @Override
    @NotNull
    public Set<RefModule> getModuleProblems() {
        Set<RefModule> set2 = this.myModulesProblems;
        if (set2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(38);
        }
        return set2;
    }

    @Override
    @NotNull
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements, InspectionTree tree) {
        if (refElements == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(39);
        }
        QuickFixAction[] quickFixActionArray = this.extractActiveFixes(refElements, this.getProblemElements()::get, tree != null ? tree.getSelectedDescriptors() : null);
        if (quickFixActionArray == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(40);
        }
        return quickFixActionArray;
    }

    @Override
    @NotNull
    public QuickFixAction[] extractActiveFixes(@NotNull RefEntity[] refElements, @NotNull Function<RefEntity, CommonProblemDescriptor[]> descriptorMap, @Nullable CommonProblemDescriptor[] allowedDescriptors) {
        if (refElements == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(41);
        }
        if (descriptorMap == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(42);
        }
        HashSet allowedDescriptorSet = allowedDescriptors == null ? null : ContainerUtil.newHashSet((Object[])allowedDescriptors);
        HashMap<String, LocalQuickFixWrapper> result2 = null;
        for (RefEntity refElement : refElements) {
            CommonProblemDescriptor[] descriptors = descriptorMap.apply(refElement);
            if (descriptors == null) continue;
            for (CommonProblemDescriptor d : descriptors) {
                QuickFix[] fixes;
                if (allowedDescriptorSet != null && !allowedDescriptorSet.contains(d) || (fixes = d.getFixes()) == null || fixes.length == 0) continue;
                if (result2 == null) {
                    result2 = new HashMap<String, LocalQuickFixWrapper>();
                    for (QuickFix fix : fixes) {
                        if (fix == null) continue;
                        result2.put(fix.getFamilyName(), new LocalQuickFixWrapper(fix, this.myToolWrapper));
                    }
                    continue;
                }
                for (String familyName : new ArrayList(result2.keySet())) {
                    boolean isFound = false;
                    for (QuickFix fix : fixes) {
                        if (fix == null || !familyName.equals(fix.getFamilyName())) continue;
                        isFound = true;
                        LocalQuickFixWrapper quickFixAction = (LocalQuickFixWrapper)((Object)result2.get(fix.getFamilyName()));
                        LOG.assertTrue(DefaultInspectionToolPresentation.getFixClass(fix).equals(DefaultInspectionToolPresentation.getFixClass(quickFixAction.getFix())), (Object)("QuickFix-es with the same family name (" + fix.getFamilyName() + ") should be the same class instances. Please assign reported exception for the inspection \"" + this.myToolWrapper.getTool().getClass() + "\" (\"" + this.myToolWrapper.getShortName() + "\") developer"));
                        try {
                            quickFixAction.setText(StringUtil.escapeMnemonics((String)fix.getFamilyName()));
                        }
                        catch (AbstractMethodError e) {
                            quickFixAction.setText("Name is not available");
                        }
                        break;
                    }
                    if (isFound) continue;
                    result2.remove(familyName);
                    if (!result2.isEmpty()) continue;
                    if (QuickFixAction.EMPTY == null) {
                        DefaultInspectionToolPresentation.$$$reportNull$$$0(43);
                    }
                    return QuickFixAction.EMPTY;
                }
            }
        }
        QuickFixAction[] quickFixActionArray = result2 == null || result2.isEmpty() ? QuickFixAction.EMPTY : result2.values().toArray(new QuickFixAction[result2.size()]);
        if (quickFixActionArray == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(44);
        }
        return quickFixActionArray;
    }

    private static Class getFixClass(QuickFix fix) {
        return fix instanceof ActionClassHolder ? ((ActionClassHolder)fix).getActionClass() : fix.getClass();
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(45);
        }
        return this.myProblemElements.getKeyFor(descriptor2);
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> synchronizedBidiMultiMap = this.myProblemElements;
        if (synchronizedBidiMultiMap == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(46);
        }
        return synchronizedBidiMultiMap;
    }

    @Override
    public void createToolNode(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        if (globalInspectionContext == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(47);
        }
        if (node == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(48);
        }
        if (provider == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(49);
        }
        if (parentNode == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(50);
        }
        this.myToolNode = node;
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(final @NotNull CommonProblemDescriptor problemDescriptor, String hint) {
        InspectionProfileEntry tool;
        if (problemDescriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(51);
        }
        if (!((tool = this.getToolWrapper().getTool()) instanceof GlobalInspectionTool)) {
            return null;
        }
        final QuickFix fix = ((GlobalInspectionTool)tool).getQuickFix(hint);
        if (fix == null) {
            return null;
        }
        if (problemDescriptor instanceof ProblemDescriptor) {
            ProblemDescriptorImpl descriptor2 = new ProblemDescriptorImpl(((ProblemDescriptor)problemDescriptor).getStartElement(), ((ProblemDescriptor)problemDescriptor).getEndElement(), problemDescriptor.getDescriptionTemplate(), new LocalQuickFix[]{(LocalQuickFix)fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false);
            return QuickFixWrapper.wrap(descriptor2, 0);
        }
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = fix.getName();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = fix.getFamilyName();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                fix.applyFix(project2, problemDescriptor);
            }

            public boolean startInWriteAction() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            public CommonProblemDescriptor[] merge(CommonProblemDescriptor[] values1, CommonProblemDescriptor[] values2) {
                return DefaultInspectionToolPresentation.mergeDescriptors(values1, values2);
            }

            @Override
            public ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                return CommonProblemDescriptor[]::new;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 45: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 19: 
            case 30: 
            case 35: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedEntities";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptors";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 23: 
            case 33: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 27: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isDescriptorExcluded";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorMap";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElements";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposer";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProblems";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "extractActiveFixes";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveProblem";
                break;
            }
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suppressProblem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributeKey";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addProblemElement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeOutput";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "extractActiveFixes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createToolNode";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findQuickFixes";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProblemElement$1";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$exclude$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

