/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionResultsViewUtil {
    static void releaseEditor(@Nullable Editor editor) {
        if (editor != null && !editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
    }

    @Nullable
    static Navigatable getNavigatableForInvalidNode(ProblemDescriptionNode node) {
        PsiFile containingFile;
        RefEntity element;
        for (element = node.getElement(); element != null && !element.isValid(); element = element.getOwner()) {
        }
        if (!(element instanceof RefElement)) {
            return null;
        }
        PsiElement containingElement = ((RefElement)element).getElement();
        if (!(containingElement instanceof NavigatablePsiElement) || !containingElement.isValid()) {
            return null;
        }
        int lineNumber = node.getLineNumber();
        if (lineNumber != -1 && (containingFile = containingElement.getContainingFile()) != null) {
            VirtualFile file2 = containingFile.getVirtualFile();
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null && document.getLineCount() > lineNumber) {
                return new OpenFileDescriptor(containingElement.getProject(), file2, lineNumber, 0);
            }
        }
        return (Navigatable)containingElement;
    }

    @NotNull
    static JLabel getNothingToShowTextLabel() {
        JLabel jLabel = InspectionResultsViewUtil.createLabelForText(InspectionViewNavigationPanel.getTitleText(false));
        if (jLabel == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(0);
        }
        return jLabel;
    }

    @NotNull
    static JComponent getInvalidEntityLabel(@NotNull RefEntity entity) {
        if (entity == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(1);
        }
        String name2 = entity.getName();
        JLabel jLabel = InspectionResultsViewUtil.createLabelForText("'" + name2 + "' is no longer valid.");
        if (jLabel == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(2);
        }
        return jLabel;
    }

    public static JComponent getPreviewIsNotAvailable(@NotNull RefEntity entity) {
        if (entity == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(3);
        }
        String name2 = entity.getQualifiedName();
        return InspectionResultsViewUtil.createLabelForText("Preview is not available for '" + name2 + "'.");
    }

    @NotNull
    static JComponent getApplyingFixLabel(@NotNull InspectionToolWrapper wrapper) {
        if (wrapper == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(4);
        }
        JLabel jLabel = InspectionResultsViewUtil.createLabelForText("Applying quick fix for '" + wrapper.getDisplayName() + "'...");
        if (jLabel == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(5);
        }
        return jLabel;
    }

    @NotNull
    static JLabel createLabelForText(String text2) {
        JBLabel multipleSelectionLabel = new JBLabel(text2);
        multipleSelectionLabel.setVerticalAlignment(1);
        multipleSelectionLabel.setBorder((Border)JBUI.Borders.empty((int)16, (int)12, (int)0, (int)0));
        JBLabel jBLabel = multipleSelectionLabel;
        if (jBLabel == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(6);
        }
        return jBLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionResultsViewUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNothingToShowTextLabel";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsViewUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidEntityLabel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyingFixLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelForText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidEntityLabel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewIsNotAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApplyingFixLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

