/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeState;
import com.intellij.codeInspection.ui.InspectionTreeUpdater;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    @NotNull
    private InspectionTreeState myState;
    private boolean myQueueUpdate;

    public InspectionTree(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionResultsView view) {
        if (context == null) {
            InspectionTree.$$$reportNull$$$0(0);
        }
        if (view == null) {
            InspectionTree.$$$reportNull$$$0(1);
        }
        this.myState = new InspectionTreeState();
        Project project2 = context.getProject();
        this.setModel(new DefaultTreeModel(new InspectionRootNode(project2, new InspectionTreeUpdater(view))));
        this.myContext = context;
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)this));
        this.addTreeWillExpandListener(new ExpandListener());
        this.myState.getExpandedUserObjects().add(project2);
        TreeUtil.installActions((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<TreePath, String>)((Convertor)o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString())));
        this.addTreeSelectionListener(e -> {
            TreePath newSelection = e.getNewLeadSelectionPath();
            if (newSelection != null && !this.isUnderQueueUpdate()) {
                this.myState.setSelectionPath(newSelection);
            }
        });
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    public boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    public void removeAllNodes() {
        this.getRoot().removeAllChildren();
        ApplicationManager.getApplication().invokeLater(() -> this.nodeStructureChanged(this.getRoot()));
    }

    public InspectionTreeNode getRoot() {
        return (InspectionTreeNode)this.getModel().getRoot();
    }

    @Nullable
    public String[] getSelectedGroupPath() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        TreePath commonPath = TreeUtil.findCommonPath((TreePath[])paths);
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return ((InspectionGroupNode)n).getGroupPath();
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper(boolean allowDummy) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        InspectionToolWrapper toolWrapper = null;
        block0: for (TreePath path : paths) {
            Object[] nodes = path.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node = nodes[j];
                if (node instanceof InspectionGroupNode) {
                    return null;
                }
                if (!(node instanceof InspectionNode)) continue;
                InspectionToolWrapper wrapper = ((InspectionNode)node).getToolWrapper();
                if (!allowDummy && this.getContext().getPresentation(wrapper).isDummy()) continue;
                if (toolWrapper == null) {
                    toolWrapper = wrapper;
                    continue block0;
                }
                if (toolWrapper == wrapper) continue block0;
                return null;
            }
        }
        return toolWrapper;
    }

    @Nullable
    public RefEntity getCommonSelectedElement() {
        Object node = this.getCommonSelectedNode();
        return node instanceof RefElementNode ? ((RefElementNode)node).getElement() : null;
    }

    @Nullable
    private Object getCommonSelectedNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        Object[][] resolvedPaths = new Object[paths.length][];
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            resolvedPaths[i] = path.getPath();
        }
        Object currentCommonNode = null;
        for (int i = 0; i < resolvedPaths[0].length; ++i) {
            Object currentNode = resolvedPaths[0][i];
            for (int j = 1; j < resolvedPaths.length; ++j) {
                Object o = resolvedPaths[j][i];
                if (o.equals(currentNode)) continue;
                return currentCommonNode;
            }
            currentCommonNode = currentNode;
        }
        return currentCommonNode;
    }

    @NotNull
    public RefEntity[] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    InspectionTree.$$$reportNull$$$0(2);
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet<RefEntity> result2 = new LinkedHashSet<RefEntity>();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node, result2);
            }
            RefEntity[] refEntityArray = (RefEntity[])ArrayUtil.reverseArray((Object[])result2.toArray(new RefEntity[result2.size()]));
            if (refEntityArray == null) {
                InspectionTree.$$$reportNull$$$0(3);
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            InspectionTree.$$$reportNull$$$0(4);
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    private static void addElementsInNode(InspectionTreeNode node, Set<RefEntity> out) {
        RefEntity element;
        if (!node.isValid()) {
            return;
        }
        if (node instanceof RefElementNode) {
            element = ((RefElementNode)node).getElement();
            out.add(element);
        }
        if (node instanceof ProblemDescriptionNode) {
            element = ((ProblemDescriptionNode)node).getElement();
            out.add(element);
        }
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children2.nextElement();
            InspectionTree.addElementsInNode(child, out);
        }
    }

    @NotNull
    public CommonProblemDescriptor[] getAllValidSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.getSelectedDescriptors(false, null, true, false);
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(5);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public CommonProblemDescriptor[] getSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.getSelectedDescriptors(false, null, false, false);
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(6);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public CommonProblemDescriptor[] getSelectedDescriptors(boolean sortedByPosition, @Nullable Set<VirtualFile> readOnlyFilesSink, boolean allowResolved, boolean allowSuppressed) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (CommonProblemDescriptor.EMPTY_ARRAY == null) {
                InspectionTree.$$$reportNull$$$0(7);
            }
            return CommonProblemDescriptor.EMPTY_ARRAY;
        }
        TreePath[] selectionPaths = TreeUtil.selectMaximals((TreePath[])paths);
        ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
        MultiMap parentToChildNode = new MultiMap();
        SmartList nonDescriptorNodes = new SmartList();
        for (TreePath path : selectionPaths) {
            int length;
            Object[] pathAsArray = path.getPath();
            Object node = pathAsArray[(length = pathAsArray.length) - 1];
            if (node instanceof ProblemDescriptionNode) {
                if (!this.isNodeValidAndIncluded((ProblemDescriptionNode)node, allowResolved, allowSuppressed)) continue;
                if (length >= 2) {
                    parentToChildNode.putValue(pathAsArray[length - 2], (Object)((ProblemDescriptionNode)node));
                    continue;
                }
                parentToChildNode.putValue(node, (Object)((ProblemDescriptionNode)node));
                continue;
            }
            nonDescriptorNodes.add((InspectionTreeNode)node);
        }
        for (InspectionTreeNode node : nonDescriptorNodes) {
            this.processChildDescriptorsDeep(node, descriptors, sortedByPosition, allowResolved, allowSuppressed, readOnlyFilesSink);
        }
        for (Map.Entry entry : parentToChildNode.entrySet()) {
            Collection siblings = (Collection)entry.getValue();
            if (siblings.size() == 1) {
                ProblemDescriptionNode descriptorNode = (ProblemDescriptionNode)ContainerUtil.getFirstItem((Collection)siblings);
                LOG.assertTrue(descriptorNode != null);
                CommonProblemDescriptor descriptor2 = descriptorNode.getDescriptor();
                if (descriptor2 == null) continue;
                descriptors.add(descriptor2);
                if (readOnlyFilesSink == null) continue;
                InspectionTree.collectReadOnlyFiles(descriptor2, readOnlyFilesSink);
                continue;
            }
            ArrayList<CommonProblemDescriptor> currentDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (ProblemDescriptionNode sibling : siblings) {
                CommonProblemDescriptor descriptor3 = sibling.getDescriptor();
                if (descriptor3 == null) continue;
                if (readOnlyFilesSink != null) {
                    InspectionTree.collectReadOnlyFiles(descriptor3, readOnlyFilesSink);
                }
                currentDescriptors.add(descriptor3);
            }
            if (sortedByPosition) {
                Collections.sort(currentDescriptors, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.addAll(currentDescriptors);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(8);
        }
        return commonProblemDescriptorArray;
    }

    public boolean areDescriptorNodesSelected() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            if (path.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    public int getSelectedProblemCount(boolean allowSuppressed) {
        int count = 0;
        for (TreePath path : TreeUtil.selectMaximals((TreePath[])this.getSelectionPaths())) {
            count += ((InspectionTreeNode)path.getLastPathComponent()).getProblemCount(allowSuppressed);
        }
        return count;
    }

    private void processChildDescriptorsDeep(InspectionTreeNode node, List<CommonProblemDescriptor> descriptors, boolean sortedByPosition, boolean allowResolved, boolean allowSuppressed, @Nullable Set<VirtualFile> readOnlyFilesSink) {
        ArrayList<CommonProblemDescriptor> descriptorChildren = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            if (child instanceof ProblemDescriptionNode) {
                if (!this.isNodeValidAndIncluded((ProblemDescriptionNode)child, allowResolved, allowSuppressed)) continue;
                if (sortedByPosition) {
                    if (descriptorChildren == null) {
                        descriptorChildren = new ArrayList<CommonProblemDescriptor>();
                    }
                    descriptorChildren.add(((ProblemDescriptionNode)child).getDescriptor());
                    continue;
                }
                descriptors.add(((ProblemDescriptionNode)child).getDescriptor());
                continue;
            }
            this.processChildDescriptorsDeep((InspectionTreeNode)child, descriptors, sortedByPosition, allowResolved, allowSuppressed, readOnlyFilesSink);
        }
        if (descriptorChildren != null) {
            if (descriptorChildren.size() > 1) {
                Collections.sort(descriptorChildren, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            if (readOnlyFilesSink != null) {
                InspectionTree.collectReadOnlyFiles((Collection<CommonProblemDescriptor>)descriptorChildren, readOnlyFilesSink);
            }
            descriptors.addAll((Collection<CommonProblemDescriptor>)descriptorChildren);
        }
    }

    private boolean isNodeValidAndIncluded(ProblemDescriptionNode node, boolean allowResolved, boolean allowSuppressed) {
        return node.isValid() && (allowResolved || !node.isExcluded() && (!node.isAlreadySuppressedFromView() || allowSuppressed && !node.getAvailableSuppressActions().isEmpty()) && !node.isQuickFixAppliedFromView());
    }

    private void nodeStructureChanged(InspectionTreeNode node) {
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
    }

    public void queueUpdate() {
        ((InspectionRootNode)this.getRoot()).getUpdater().update(true);
    }

    public void restoreExpansionAndSelection(boolean treeNodesMightChange) {
        this.myState.restoreExpansionAndSelection(this, treeNodesMightChange);
    }

    public void setState(@NotNull InspectionTreeState state) {
        if (state == null) {
            InspectionTree.$$$reportNull$$$0(9);
        }
        this.myState = state;
    }

    public InspectionTreeState getTreeState() {
        return this.myState;
    }

    public void setTreeState(@NotNull InspectionTreeState treeState) {
        if (treeState == null) {
            InspectionTree.$$$reportNull$$$0(10);
        }
        this.myState = treeState;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            InspectionTree.$$$reportNull$$$0(11);
        }
        return globalInspectionContextImpl;
    }

    private static void collectReadOnlyFiles(@NotNull Collection<CommonProblemDescriptor> descriptors, @NotNull Set<VirtualFile> readOnlySink) {
        if (descriptors == null) {
            InspectionTree.$$$reportNull$$$0(12);
        }
        if (readOnlySink == null) {
            InspectionTree.$$$reportNull$$$0(13);
        }
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            InspectionTree.collectReadOnlyFiles(descriptor2, readOnlySink);
        }
    }

    private static void collectReadOnlyFiles(@NotNull CommonProblemDescriptor descriptor2, @NotNull Set<VirtualFile> readOnlySink) {
        PsiElement psiElement;
        if (descriptor2 == null) {
            InspectionTree.$$$reportNull$$$0(14);
        }
        if (readOnlySink == null) {
            InspectionTree.$$$reportNull$$$0(15);
        }
        if (descriptor2 instanceof ProblemDescriptor && (psiElement = ((ProblemDescriptor)descriptor2).getPsiElement()) != null && !psiElement.isWritable()) {
            readOnlySink.add(psiElement.getContainingFile().getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readOnlySink";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidSelectedDescriptors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTreeState";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectReadOnlyFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExpandListener
    implements TreeWillExpandListener {
        private ExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myState.getExpandedUserObjects().add(node.getUserObject());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myState.getExpandedUserObjects().remove(node.getUserObject());
        }
    }
}

