/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertLineSeparatorsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeStyle.AbstractConvertLineSeparatorsAction");
    @NotNull
    private final String mySeparator;

    protected AbstractConvertLineSeparatorsAction(@Nullable String text2, @NotNull LineSeparator separator) {
        if (separator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(0);
        }
        this(separator + " - " + text2, separator.getSeparatorString());
    }

    protected AbstractConvertLineSeparatorsAction(@Nullable String text2, @NotNull String separator) {
        if (separator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(1);
        }
        super(text2);
        this.mySeparator = separator;
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null) {
            VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            Presentation presentation = e.getPresentation();
            if (virtualFiles != null) {
                if (virtualFiles.length == 1) {
                    presentation.setEnabled(!this.mySeparator.equals(LoadTextUtil.detectLineSeparator(virtualFiles[0], false)));
                } else {
                    presentation.setEnabled(true);
                }
            } else {
                presentation.setEnabled(false);
            }
        }
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles == null) {
            return;
        }
        final VirtualFile projectVirtualDirectory = ProjectKt.getStateStore(project2).getDirectoryStoreFile();
        final FileTypeRegistry fileTypeManager = FileTypeRegistry.getInstance();
        for (VirtualFile file2 : virtualFiles) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (AbstractConvertLineSeparatorsAction.shouldProcess(file2, project2)) {
                        AbstractConvertLineSeparatorsAction.changeLineSeparators(project2, file2, AbstractConvertLineSeparatorsAction.this.mySeparator);
                    }
                    VirtualFileVisitor.Result result2 = file2.isDirectory() && (file2.equals(projectVirtualDirectory) || fileTypeManager.isFileIgnored(file2)) ? SKIP_CHILDREN : CONTINUE;
                    if (result2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    public static boolean shouldProcess(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(3);
        }
        if (file2.isDirectory() || !file2.isWritable() || FileTypeRegistry.getInstance().isFileIgnored(file2) || file2.getFileType().isBinary() || file2.equals(project2.getProjectFile()) || file2.equals(project2.getWorkspaceFile())) {
            return false;
        }
        Module module2 = FileIndexFacade.getInstance((Project)project2).getModuleForFile(file2);
        return module2 == null || !ModuleUtilCore.isModuleFile((Module)module2, (VirtualFile)file2);
    }

    public static void changeLineSeparators(final @NotNull Project project2, final @NotNull VirtualFile virtualFile, final @NotNull String newSeparator) {
        String currentSeparator;
        FileDocumentManager fileDocumentManager;
        Document document;
        if (project2 == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(5);
        }
        if (newSeparator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(6);
        }
        if ((document = (fileDocumentManager = FileDocumentManager.getInstance()).getCachedDocument(virtualFile)) != null) {
            fileDocumentManager.saveDocument(document);
        }
        String commandText = StringUtil.isEmpty((String)(currentSeparator = LoadTextUtil.detectLineSeparator(virtualFile, false))) ? "Changed line separators to " + LineSeparator.fromString((String)newSeparator) : String.format("Changed line separators from %s to %s", LineSeparator.fromString((String)currentSeparator), LineSeparator.fromString((String)newSeparator));
        new WriteCommandAction(project2, commandText, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    LoadTextUtil.changeLineSeparators(project2, virtualFile, newSeparator, (Object)this);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$2", "run"));
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changeLineSeparators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

