/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.ChainOpAndOccurrences;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.SearchInitializer;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.LightRef;

public class ChainSearcher {
    @NotNull
    public static List<OperationChain> search(int pathMaximalLength, ChainSearchTarget searchTarget, int maxResultSize, ChainCompletionContext context, CompilerReferenceServiceEx compilerReferenceServiceEx) {
        SearchInitializer initializer = ChainSearcher.createInitializer(searchTarget, compilerReferenceServiceEx, context);
        List<OperationChain> list2 = ChainSearcher.search(compilerReferenceServiceEx, initializer, pathMaximalLength, maxResultSize, context);
        if (list2 == null) {
            ChainSearcher.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    private static SearchInitializer createInitializer(ChainSearchTarget target2, CompilerReferenceServiceEx referenceServiceEx, ChainCompletionContext context) {
        ChainOpAndOccurrences<TypeCast> typeCast;
        TreeSet<ChainOpAndOccurrences<? extends RefChainOperation>> operations = new TreeSet<ChainOpAndOccurrences<? extends RefChainOperation>>();
        for (byte kind2 : target2.getArrayKind()) {
            SortedSet<ChainOpAndOccurrences<MethodCall>> methods = referenceServiceEx.findMethodReferenceOccurrences(target2.getClassQName(), kind2, context);
            operations.addAll(methods);
        }
        if (operations.isEmpty() && (typeCast = referenceServiceEx.getMostUsedTypeCast(target2.getClassQName())) != null) {
            operations.add(typeCast);
        }
        SearchInitializer searchInitializer = new SearchInitializer(operations, context);
        if (searchInitializer == null) {
            ChainSearcher.$$$reportNull$$$0(1);
        }
        return searchInitializer;
    }

    @NotNull
    private static List<OperationChain> search(CompilerReferenceServiceEx referenceServiceEx, SearchInitializer initializer, int chainMaxLength, int maxResultSize, ChainCompletionContext context) {
        LinkedList<OperationChain> q = initializer.getChainQueue();
        ArrayList<OperationChain> result2 = new ArrayList<OperationChain>();
        while (!q.isEmpty()) {
            OperationChain continuation;
            LightRef.LightClassHierarchyElementDef def;
            ChainOpAndOccurrences candidate;
            ProgressManager.checkCanceled();
            OperationChain currentChain = q.poll();
            RefChainOperation head = currentChain.getHead();
            if (ChainSearcher.addChainIfTerminal(currentChain, result2, chainMaxLength, context)) continue;
            boolean updated = false;
            SortedSet<ChainOpAndOccurrences<MethodCall>> candidates = referenceServiceEx.findMethodReferenceOccurrences(head.getQualifierRawName(), (byte)0, context);
            LightRef ref = head.getLightRef();
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext() && (candidate = (ChainOpAndOccurrences)iterator.next()).getOccurrenceCount() * 10 >= currentChain.getChainWeight()) {
                boolean stopChain;
                OperationChain continuation2;
                MethodCall sign = (MethodCall)candidate.getOperation();
                if (!sign.isStatic() && sign.getQualifierRawName().equals(context.getTarget().getClassQName()) || ref instanceof LightRef.JavaLightMethodRef && !referenceServiceEx.mayHappen((LightRef)((MethodCall)candidate.getOperation()).getLightRef(), ref, 5) || (continuation2 = currentChain.continuationWithMethod((MethodCall)candidate.getOperation(), candidate.getOccurrenceCount(), context)) == null) continue;
                boolean bl = stopChain = ((MethodCall)candidate.getOperation()).isStatic() || context.hasQualifier(context.resolvePsiClass(((MethodCall)candidate.getOperation()).getQualifierDef()));
                if (stopChain) {
                    ChainSearcher.addChainIfNotPresent(continuation2, result2);
                } else {
                    q.addFirst(continuation2);
                }
                updated = true;
            }
            if (ref instanceof LightRef.JavaLightMethodRef && (def = referenceServiceEx.mayCallOfTypeCast((LightRef.JavaLightMethodRef)ref, 5)) != null && (continuation = currentChain.continuationWithCast(new TypeCast(def, head.getQualifierDef(), referenceServiceEx), context)) != null) {
                q.addFirst(continuation);
                updated = true;
            }
            if (!updated) {
                ChainSearcher.addChainIfQualifierCanBeOccurredInContext(currentChain, result2, context, referenceServiceEx);
            }
            if (result2.size() <= maxResultSize) continue;
            ArrayList<OperationChain> arrayList = result2;
            if (arrayList == null) {
                ChainSearcher.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        ArrayList<OperationChain> arrayList = result2;
        if (arrayList == null) {
            ChainSearcher.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void addChainIfQualifierCanBeOccurredInContext(OperationChain currentChain, List<OperationChain> result2, ChainCompletionContext context, CompilerReferenceServiceEx referenceServiceEx) {
        RefChainOperation signature = currentChain.getHead();
        if (currentChain.hasCast()) {
            return;
        }
        if (!context.getTarget().getClassQName().equals(signature.getQualifierRawName())) {
            Set<LightRef> references = context.getContextClassReferences();
            boolean isRelevantQualifier = false;
            for (LightRef ref : references) {
                if (!referenceServiceEx.mayHappen((LightRef)signature.getQualifierDef(), ref, 1)) continue;
                isRelevantQualifier = true;
                break;
            }
            if (references.isEmpty() || isRelevantQualifier) {
                ChainSearcher.addChainIfNotPresent(currentChain, result2);
            }
        }
    }

    private static boolean addChainIfTerminal(OperationChain currentChain, List<OperationChain> result2, int pathMaximalLength, ChainCompletionContext context) {
        MethodCall signature = currentChain.getHeadMethodCall();
        if (signature == null) {
            return false;
        }
        RefChainOperation head = currentChain.getHead();
        if (signature.isStatic() || context.hasQualifier(context.resolvePsiClass(head.getQualifierDef())) || currentChain.length() >= pathMaximalLength) {
            ChainSearcher.addChainIfNotPresent(currentChain, result2);
            return true;
        }
        return false;
    }

    private static void addChainIfNotPresent(OperationChain newChain, List<OperationChain> result2) {
        if (result2.isEmpty()) {
            result2.add(newChain);
            return;
        }
        boolean doAdd = true;
        IntStack indicesToRemove = new IntStack();
        block4: for (int i = 0; i < result2.size(); ++i) {
            OperationChain chain = result2.get(i);
            OperationChain.CompareResult r = OperationChain.compare(chain, newChain);
            switch (r) {
                case LEFT_CONTAINS_RIGHT: {
                    indicesToRemove.push(i);
                    continue block4;
                }
                case RIGHT_CONTAINS_LEFT: 
                case EQUAL: {
                    doAdd = false;
                    continue block4;
                }
            }
        }
        while (!indicesToRemove.empty()) {
            result2.remove(indicesToRemove.pop());
        }
        if (doAdd) {
            result2.add(newChain);
        }
    }

    private static <T> SortedSet<T> unionSortedSet(SortedSet<T> s1, SortedSet<T> s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        TreeSet<T> result2 = new TreeSet<T>();
        result2.addAll(s1);
        result2.addAll(s2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/compiler/chainsSearch/ChainSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

