/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.compiler.chainsSearch.ChainOperation;
import com.intellij.compiler.chainsSearch.ChainRelevance;
import com.intellij.compiler.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.completion.lookup.ChainCompletionNewVariableLookupElement;
import com.intellij.compiler.chainsSearch.completion.lookup.JavaRelevantChainLookupElement;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MethodChainLookupRangingHelper {
    @NotNull
    public static LookupElement toLookupElement(OperationChain chain, ChainCompletionContext context) {
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        Object chainLookupElement = null;
        for (ChainOperation op : chain.getPath()) {
            if (op instanceof ChainOperation.MethodCall) {
                PsiMethod method = (PsiMethod)ObjectUtils.notNull((Object)MethodChainsSearchUtil.getMethodWithMinNotPrimitiveParameters(((ChainOperation.MethodCall)op).getCandidates(), context.getTarget().getTargetClass()));
                Couple<Integer> info = MethodChainLookupRangingHelper.calculateParameterInfo(method, context);
                unreachableParametersCount += ((Integer)info.getFirst()).intValue();
                matchedParametersInContext += ((Integer)info.getSecond()).intValue();
                if (chainLookupElement == null) {
                    LookupElement qualifierLookupElement = method.hasModifierProperty("static") ? null : MethodChainLookupRangingHelper.createQualifierLookupElement(chain.getQualifierClass(), context);
                    LookupElement headLookupElement = MethodChainLookupRangingHelper.createMethodLookupElement(method);
                    chainLookupElement = qualifierLookupElement == null ? headLookupElement : new JavaChainLookupElement(qualifierLookupElement, headLookupElement);
                    continue;
                }
                chainLookupElement = new JavaChainLookupElement((LookupElement)chainLookupElement, (LookupElement)new JavaMethodCallElement(method));
                continue;
            }
            if (chainLookupElement == null) {
                chainLookupElement = MethodChainLookupRangingHelper.createQualifierLookupElement(chain.getQualifierClass(), context);
            }
            PsiClass castClass = ((ChainOperation.TypeCast)op).getCastClass();
            PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)castClass.getProject()).createType(castClass);
            chainLookupElement = CastingLookupElementDecorator.createCastingElement(chainLookupElement, (PsiType)type2);
        }
        if (context.getTarget().isIteratorAccess()) {
            chainLookupElement = MethodChainLookupRangingHelper.decorateWithIteratorAccess(chain.getFirst()[0], chainLookupElement);
        }
        JavaRelevantChainLookupElement javaRelevantChainLookupElement = new JavaRelevantChainLookupElement((LookupElement)ObjectUtils.notNull(chainLookupElement), new ChainRelevance(chain.length(), unreachableParametersCount, matchedParametersInContext));
        if (javaRelevantChainLookupElement == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(0);
        }
        return javaRelevantChainLookupElement;
    }

    @NotNull
    private static LookupElementDecorator<LookupElement> decorateWithIteratorAccess(final PsiMethod method, LookupElement chainLookupElement) {
        LookupElementDecorator<LookupElement> lookupElementDecorator = new LookupElementDecorator<LookupElement>(chainLookupElement){

            public void handleInsert(InsertionContext context) {
                super.handleInsert(context);
                Document document = context.getDocument();
                int tail = context.getTailOffset();
                PsiType tailReturnType = method.getReturnType();
                if (tailReturnType instanceof PsiArrayType) {
                    document.insertString(tail, (CharSequence)"[0]");
                    context.getEditor().getCaretModel().moveToOffset(tail + 1);
                } else {
                    PsiClass returnClass = (PsiClass)ObjectUtils.notNull((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)tailReturnType));
                    PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.List")) {
                        document.insertString(tail, (CharSequence)".get(0)");
                        context.getEditor().getCaretModel().moveToOffset(tail + 5);
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Collection")) {
                        document.insertString(tail, (CharSequence)".iterator().next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Iterator")) {
                        document.insertString(tail, (CharSequence)".next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.stream.Stream")) {
                        document.insertString(tail, (CharSequence)".findFirst().get()");
                    }
                }
            }
        };
        if (lookupElementDecorator == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(1);
        }
        return lookupElementDecorator;
    }

    @NotNull
    private static LookupElement createQualifierLookupElement(@NotNull PsiClass qualifierClass, @NotNull ChainCompletionContext context) {
        PsiNamedElement element;
        if (qualifierClass == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(3);
        }
        if ((element = (PsiNamedElement)context.getQualifiers(qualifierClass).findFirst().orElse(null)) == null) {
            ChainCompletionNewVariableLookupElement chainCompletionNewVariableLookupElement = new ChainCompletionNewVariableLookupElement(qualifierClass, context);
            if (chainCompletionNewVariableLookupElement == null) {
                MethodChainLookupRangingHelper.$$$reportNull$$$0(4);
            }
            return chainCompletionNewVariableLookupElement;
        }
        if (element instanceof PsiVariable) {
            VariableLookupItem variableLookupItem = new VariableLookupItem((PsiVariable)element);
            if (variableLookupItem == null) {
                MethodChainLookupRangingHelper.$$$reportNull$$$0(5);
            }
            return variableLookupItem;
        }
        if (element instanceof PsiMethod) {
            LookupElement lookupElement = MethodChainLookupRangingHelper.createMethodLookupElement((PsiMethod)element);
            if (lookupElement == null) {
                MethodChainLookupRangingHelper.$$$reportNull$$$0(6);
            }
            return lookupElement;
        }
        throw new AssertionError((Object)("unexpected element: " + element));
    }

    @NotNull
    private static Couple<Integer> calculateParameterInfo(@NotNull PsiMethod method, @NotNull ChainCompletionContext context) {
        if (method == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(8);
        }
        NullableNotNullManager nullableNotNullManager = NullableNotNullManager.getInstance((Project)method.getProject());
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            PsiType type2 = parameter2.getType();
            if (ChainCompletionContext.isWidelyUsed(type2)) continue;
            Collection contextVariables = context.getQualifiers(type2).collect(Collectors.toList());
            PsiElement contextVariable = (PsiElement)ContainerUtil.getFirstItem((Collection)contextVariables, null);
            if (contextVariable != null) {
                ++matchedParametersInContext;
                continue;
            }
            if (nullableNotNullManager.isNullable((PsiModifierListOwner)parameter2, true)) continue;
            ++unreachableParametersCount;
        }
        Couple couple = Couple.of((Object)unreachableParametersCount, (Object)matchedParametersInContext);
        if (couple == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @NotNull
    private static LookupElement createMethodLookupElement(@NotNull PsiMethod method) {
        TypedLookupItem result2;
        if (method == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(10);
        }
        if (method.isConstructor()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            result2 = new ExpressionLookupItem(elementFactory.createExpressionFromText("new " + method.getContainingClass().getQualifiedName() + "()", null));
        } else {
            result2 = method.hasModifierProperty("static") ? new JavaMethodCallElement(method, false, true) : new JavaMethodCallElement(method);
        }
        JavaMethodCallElement javaMethodCallElement = result2;
        if (javaMethodCallElement == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(11);
        }
        return javaMethodCallElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "decorateWithIteratorAccess";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifierLookupElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateParameterInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQualifierLookupElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateParameterInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMethodLookupElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

