/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;

public class FileProcessingCompilerAdapterTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.FileProcessingCompilerAdapterTask");
    private final FileProcessingCompiler myCompiler;

    public FileProcessingCompilerAdapterTask(FileProcessingCompiler compiler) {
        this.myCompiler = compiler;
    }

    public FileProcessingCompiler getCompiler() {
        return this.myCompiler;
    }

    public boolean execute(CompileContext context) {
        Project project2 = context.getProject();
        try {
            FileProcessingCompiler.ProcessingItem[] items = this.myCompiler.getProcessingItems(context);
            if (items.length == 0) {
                return true;
            }
            ArrayList toProcess = new ArrayList();
            Ref ex = new Ref(null);
            FileProcessingCompilerStateCache cache = this.getCache(context);
            boolean isMake = context.isMake();
            DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
                try {
                    for (FileProcessingCompiler.ProcessingItem item : items) {
                        VirtualFile file2 = item.getFile();
                        String url = file2.getUrl();
                        if (isMake && cache.getTimestamp(url) == file2.getTimeStamp()) {
                            ValidityState state = cache.getExtState(url);
                            ValidityState itemState = item.getValidityState();
                            if (state != null ? state.equalsTo(itemState) : itemState == null) continue;
                        }
                        toProcess.add(item);
                    }
                }
                catch (IOException e) {
                    ex.set((Object)e);
                }
            });
            IOException exception = (IOException)ex.get();
            if (exception != null) {
                throw exception;
            }
            if (toProcess.isEmpty()) {
                return true;
            }
            FileProcessingCompiler.ProcessingItem[] array = toProcess.toArray(new FileProcessingCompiler.ProcessingItem[toProcess.size()]);
            FileProcessingCompiler.ProcessingItem[] processed2 = this.myCompiler.process(context, array);
            if (processed2.length == 0) {
                return true;
            }
            CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), () -> {
                ArrayList vFiles = new ArrayList(processed2.length);
                ArrayList toUpdate = new ArrayList(processed2.length);
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (FileProcessingCompiler.ProcessingItem item : processed2) {
                        vFiles.add(item.getFile());
                        toUpdate.add(Pair.create((Object)item, (Object)item.getValidityState()));
                    }
                });
                LocalFileSystem.getInstance().refreshFiles(vFiles);
                for (Pair pair2 : toUpdate) {
                    cache.update(((FileProcessingCompiler.ProcessingItem)pair2.getFirst()).getFile(), (ValidityState)pair2.getSecond());
                }
            });
        }
        catch (Throwable e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
            LOG.info(e);
        }
        return true;
    }

    private FileProcessingCompilerStateCache getCache(CompileContext context) throws IOException {
        CompilerCacheManager cacheManager = CompilerCacheManager.getInstance(context.getProject());
        try {
            return cacheManager.getFileProcessingCompilerCache(this.myCompiler);
        }
        catch (IOException e) {
            cacheManager.clearCaches(context);
            return cacheManager.getFileProcessingCompilerCache(this.myCompiler);
        }
    }
}

