/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitException;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.generic.GenericCompilerCache;
import com.intellij.compiler.impl.generic.GenericCompilerPersistentData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.generic.BuildTarget;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.compiler.generic.GenericCompilerCacheState;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.GenericCompilerProcessingItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CommonProcessors;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericCompilerRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.GenericCompilerRunner");
    private static final Logger FULL_LOG = Logger.getInstance((String)"#com.intellij.full-generic-compiler-log");
    private CompileContext myContext;
    private final boolean myForceCompile;
    private final boolean myOnlyCheckStatus;
    private final GenericCompiler<?, ?, ?>[] myCompilers;
    private final Project myProject;

    public GenericCompilerRunner(CompileContext context, boolean forceCompile, boolean onlyCheckStatus, GenericCompiler[] compilers) {
        this.myContext = context;
        this.myForceCompile = forceCompile;
        this.myOnlyCheckStatus = onlyCheckStatus;
        this.myCompilers = compilers;
        this.myProject = this.myContext.getProject();
    }

    public boolean invokeCompilers(GenericCompiler.CompileOrderPlace place) throws ExitException {
        boolean didSomething = false;
        try {
            for (GenericCompiler<?, ?, ?> compiler : this.myCompilers) {
                if (!compiler.getOrderPlace().equals((Object)place)) continue;
                didSomething |= this.invokeCompiler(compiler);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.myContext.requestRebuildNextTime(e.getMessage());
            throw new ExitException(ExitStatus.ERRORS);
        }
        catch (ExitException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            this.myContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{e.getMessage()}), null, -1, -1);
        }
        return didSomething;
    }

    private <Key, SourceState, OutputState> boolean invokeCompiler(GenericCompiler<Key, SourceState, OutputState> compiler) throws IOException, ExitException {
        return this.invokeCompiler(compiler, compiler.createInstance(this.myContext));
    }

    private <T extends BuildTarget, Item extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> boolean invokeCompiler(GenericCompiler<Key, SourceState, OutputState> compiler, final GenericCompilerInstance<T, Item, Key, SourceState, OutputState> instance2) throws IOException, ExitException {
        GenericCompilerCache cache = CompilerCacheManager.getInstance(this.myProject).getGenericCompilerCache(compiler);
        GenericCompilerPersistentData data = new GenericCompilerPersistentData(GenericCompilerRunner.getGenericCompilerCacheDir(this.myProject, compiler), compiler.getVersion());
        if (data.isVersionChanged()) {
            LOG.info("Clearing cache for " + compiler.getDescription());
            cache.wipe();
            data.save();
        }
        final HashSet<String> targetsToRemove = new HashSet<String>(data.getAllTargets());
        new ReadAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (BuildTarget target2 : instance2.getAllTargets()) {
                    targetsToRemove.remove(target2.getId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/impl/GenericCompilerRunner$1", "run"));
            }
        }.execute();
        if (!this.myOnlyCheckStatus) {
            for (String target2 : targetsToRemove) {
                int id = data.removeId(target2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing obsolete target '" + target2 + "' (id=" + id + ")");
                }
                ArrayList keys = new ArrayList();
                CompilerUtil.runInContext(this.myContext, "Processing obsolete targets...", () -> {
                    cache.processSources(id, new CommonProcessors.CollectProcessor((Collection)keys));
                    ArrayList obsoleteSources = new ArrayList();
                    for (Object key2 : keys) {
                        GenericCompilerCache.PersistentStateData state = cache.getState(id, key2);
                        obsoleteSources.add(new GenericCompilerCacheState(key2, state.mySourceState, state.myOutputState));
                    }
                    instance2.processObsoleteTarget(target2, obsoleteSources);
                });
                this.checkForErrorsOrCanceled();
                for (Object key2 : keys) {
                    cache.remove(id, key2);
                }
            }
        }
        List selectedTargets = (List)new ReadAction<List<T>>(){

            protected void run(@NotNull Result<List<T>> result2) {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                result2.setResult(instance2.getSelectedTargets());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/impl/GenericCompilerRunner$2", "run"));
            }
        }.execute().getResultObject();
        boolean didSomething = false;
        for (BuildTarget target3 : selectedTargets) {
            int id = data.getId(target3.getId());
            didSomething |= this.processTarget(target3, id, compiler, instance2, cache);
        }
        data.save();
        return didSomething;
    }

    private void checkForErrorsOrCanceled() throws ExitException {
        if (this.myContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
            throw new ExitException(ExitStatus.ERRORS);
        }
        if (this.myContext.getProgressIndicator().isCanceled()) {
            throw new ExitException(ExitStatus.CANCELLED);
        }
    }

    public static File getGenericCompilerCacheDir(Project project2, GenericCompiler<?, ?, ?> compiler) {
        return new File(CompilerPaths.getCacheStoreDirectory((Project)project2), compiler.getId());
    }

    private <T extends BuildTarget, Item extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> boolean processTarget(T target2, final int targetId, GenericCompiler<Key, SourceState, OutputState> compiler, GenericCompilerInstance<T, Item, Key, SourceState, OutputState> instance2, final GenericCompilerCache<Key, SourceState, OutputState> cache) throws IOException, ExitException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing target '" + target2 + "' (id=" + targetId + ") by " + compiler);
        }
        List items = instance2.getItems(target2);
        this.checkForErrorsOrCanceled();
        ArrayList toProcess = new ArrayList();
        THashSet keySet = new THashSet(new SourceItemHashingStrategy<Key>(compiler));
        Ref exception = Ref.create(null);
        final HashMap sourceStates = new HashMap();
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            try {
                for (CompileItem item : items) {
                    Object outputState;
                    Object key2 = item.getKey();
                    keySet.add(key2);
                    if (item.isExcluded()) continue;
                    GenericCompilerCache.PersistentStateData data = cache.getState(targetId, key2);
                    Object sourceState = data != null ? (Object)data.mySourceState : null;
                    Object OutputState = outputState = data != null ? (Object)data.myOutputState : null;
                    if (!this.myForceCompile && sourceState != null && item.isSourceUpToDate(sourceState) && outputState != null && item.isOutputUpToDate(outputState)) continue;
                    sourceStates.put(item, item.computeSourceState());
                    toProcess.add(new GenericCompilerProcessingItem<CompileItem, Object, Object>(item, sourceState, outputState));
                }
            }
            catch (IOException e) {
                exception.set((Object)e);
            }
        });
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
        ArrayList toRemove2 = new ArrayList();
        cache.processSources(targetId, key2 -> {
            if (!keySet.contains(key2)) {
                toRemove2.add(key2);
            }
            return true;
        });
        if (LOG.isDebugEnabled()) {
            int i;
            LOG.debug(toProcess.size() + " items will be processed, " + toRemove2.size() + " items will be removed");
            for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(toProcess.size()); ++i) {
                LOG.debug("to process:" + ((CompileItem)((GenericCompilerProcessingItem)toProcess.get(i)).getItem()).getKey());
            }
            for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(toRemove2.size()); ++i) {
                LOG.debug("to delete:" + toRemove2.get(i));
            }
        }
        if (toProcess.isEmpty() && toRemove2.isEmpty()) {
            return false;
        }
        if (this.myOnlyCheckStatus) {
            throw new ExitException(ExitStatus.CANCELLED);
        }
        ArrayList obsoleteItems = new ArrayList();
        for (Object key3 : toRemove2) {
            GenericCompilerCache.PersistentStateData<SourceState, OutputState> data = cache.getState(targetId, key3);
            obsoleteItems.add(new GenericCompilerCacheState(key3, data.mySourceState, data.myOutputState));
        }
        final ArrayList processedItems = new ArrayList();
        final ArrayList filesToRefresh = new ArrayList();
        final ArrayList dirsToRefresh = new ArrayList();
        instance2.processItems(target2, toProcess, obsoleteItems, new GenericCompilerInstance.OutputConsumer<Item>(){

            @Override
            public void addFileToRefresh(@NotNull File file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                filesToRefresh.add(file2);
            }

            @Override
            public void addDirectoryToRefresh(@NotNull File dir) {
                if (dir == null) {
                    3.$$$reportNull$$$0(1);
                }
                dirsToRefresh.add(dir);
            }

            @Override
            public void addProcessedItem(@NotNull Item sourceItem) {
                if (sourceItem == null) {
                    3.$$$reportNull$$$0(2);
                }
                processedItems.add(sourceItem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dir";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceItem";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/impl/GenericCompilerRunner$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFileToRefresh";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDirectoryToRefresh";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addProcessedItem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.checkForErrorsOrCanceled();
        CompilerUtil.runInContext(this.myContext, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), () -> {
            RunResult runResult;
            Throwable throwable;
            for (Object key2 : toRemove2) {
                cache.remove(targetId, key2);
            }
            CompilerUtil.refreshIOFiles(filesToRefresh);
            CompilerUtil.refreshIODirectories(dirsToRefresh);
            if (LOG.isDebugEnabled()) {
                int i;
                LOG.debug("refreshed " + filesToRefresh.size() + " files and " + dirsToRefresh.size() + " dirs");
                for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(filesToRefresh.size()); ++i) {
                    LOG.debug("file: " + filesToRefresh.get(i));
                }
                for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(dirsToRefresh.size()); ++i) {
                    LOG.debug("dir: " + dirsToRefresh.get(i));
                }
            }
            if ((throwable = (runResult = new ReadAction(){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    for (CompileItem item : processedItems) {
                        Object sourceState = sourceStates.get(item);
                        if (sourceState == null) {
                            sourceState = item.computeSourceState();
                        }
                        cache.putState(targetId, item.getKey(), sourceState, item.computeOutputState());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/impl/GenericCompilerRunner$4", "run"));
                }
            }.executeSilently()).getThrowable()) instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable != null) {
                throw new RuntimeException(throwable);
            }
        });
        return true;
    }

    private static int getItemsCountToShowInLog(int size) {
        if (size > 100 && !FULL_LOG.isDebugEnabled()) {
            return 100;
        }
        return size;
    }

    private class SourceItemHashingStrategy<S>
    implements TObjectHashingStrategy<S> {
        private KeyDescriptor<S> myKeyDescriptor;

        public SourceItemHashingStrategy(GenericCompiler<S, ?, ?> compiler) {
            this.myKeyDescriptor = compiler.getItemKeyDescriptor();
        }

        public int computeHashCode(S object) {
            return this.myKeyDescriptor.getHashCode(object);
        }

        public boolean equals(S o1, S o2) {
            return this.myKeyDescriptor.isEqual(o1, o2);
        }
    }
}

