/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesContainer {
    private final Project myProject;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);

    public MessagesContainer(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Collection<CompilerMessage> getMessages(@NotNull CompilerMessageCategory category) {
        Collection<CompilerMessage> collection;
        if (category == null) {
            MessagesContainer.$$$reportNull$$$0(0);
        }
        if ((collection = this.myMessages.get(category)) == null) {
            List<CompilerMessage> list2 = Collections.emptyList();
            if (list2 == null) {
                MessagesContainer.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Collection<CompilerMessage> collection2 = Collections.unmodifiableCollection(collection);
        if (collection2 == null) {
            MessagesContainer.$$$reportNull$$$0(2);
        }
        return collection2;
    }

    @Nullable
    public CompilerMessage addMessage(CompilerMessageCategory category, String message2, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message2, MessagesContainer.findFileByUrl(url), lineNum, columnNum, navigatable);
        if (this.addMessage(msg)) {
            return msg;
        }
        return null;
    }

    public boolean addMessage(CompilerMessage msg) {
        Collection messages = this.myMessages.computeIfAbsent(msg.getCategory(), k -> new LinkedHashSet());
        return messages.add(msg);
    }

    @Nullable
    private static VirtualFile findFileByUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file2 == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        return file2;
    }

    public int getMessageCount(@Nullable CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        return this.myMessages.values().stream().filter(Objects::nonNull).mapToInt(Collection::size).sum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/MessagesContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/MessagesContainer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

