/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public class ProcessorProfilePanel
extends JPanel {
    private final Project myProject;
    private JRadioButton myRbClasspath;
    private JRadioButton myRbProcessorsPath;
    private TextFieldWithBrowseButton myProcessorPathField;
    private JTextField myGeneratedProductionDirField;
    private JTextField myGeneratedTestsDirField;
    private JRadioButton myRbRelativeToOutputRoot;
    private JRadioButton myRbRelativeToContentRoot;
    private ProcessorTableModel myProcessorsModel;
    private JCheckBox myCbEnableProcessing;
    private JBTable myProcessorTable;
    private JBTable myOptionsTable;
    private JPanel myProcessorPanel;
    private JPanel myOptionsPanel;
    private OptionsTableModel myOptionsModel;
    private JLabel myStoreGenSourcesLabel;
    private JLabel myProductionLabel;
    private JLabel myTestLabel;
    private JPanel myProcessorTablePanel;
    private JPanel myOptionsTablePanel;

    public ProcessorProfilePanel(Project project2) {
        super(new GridBagLayout());
        this.myProject = project2;
        this.myCbEnableProcessing = new JCheckBox("Enable annotation processing");
        this.myRbClasspath = new JRadioButton("Obtain processors from project classpath");
        this.myRbProcessorsPath = new JRadioButton("Processor path:");
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbClasspath);
        group.add(this.myRbProcessorsPath);
        this.myRbRelativeToContentRoot = new JRadioButton("Module content root");
        this.myRbRelativeToOutputRoot = new JRadioButton("Module output directory");
        group = new ButtonGroup();
        group.add(this.myRbRelativeToContentRoot);
        group.add(this.myRbRelativeToOutputRoot);
        this.myProcessorPathField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Component)ProcessorProfilePanel.this.myProcessorPathField, (Project)ProcessorProfilePanel.this.myProject, null);
                if (files.length > 0) {
                    StringBuilder builder = new StringBuilder();
                    for (VirtualFile file2 : files) {
                        if (builder.length() > 0) {
                            builder.append(File.pathSeparator);
                        }
                        builder.append(FileUtil.toSystemDependentName((String)file2.getPath()));
                    }
                    ProcessorProfilePanel.this.myProcessorPathField.setText(builder.toString());
                }
            }
        });
        this.myProcessorTablePanel = new JPanel(new BorderLayout());
        this.myProcessorsModel = new ProcessorTableModel();
        this.myProcessorTablePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Annotation Processors", (boolean)false));
        this.myProcessorTable = new JBTable((TableModel)this.myProcessorsModel);
        this.myProcessorTable.getEmptyText().setText("Compiler will run all automatically discovered processors");
        this.myProcessorPanel = ProcessorProfilePanel.createTablePanel(this.myProcessorTable);
        this.myProcessorTablePanel.add((Component)this.myProcessorPanel, "Center");
        this.myOptionsTablePanel = new JPanel(new BorderLayout());
        this.myOptionsModel = new OptionsTableModel();
        this.myOptionsTablePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Annotation Processor options", (boolean)false));
        this.myOptionsTable = new JBTable((TableModel)this.myOptionsModel);
        this.myOptionsTable.getEmptyText().setText("No processor-specific options configured");
        this.myOptionsPanel = ProcessorProfilePanel.createTablePanel(this.myOptionsTable);
        this.myOptionsTablePanel.add((Component)this.myOptionsPanel, "Center");
        this.myGeneratedProductionDirField = new JTextField();
        this.myGeneratedTestsDirField = new JTextField();
        this.add((Component)this.myCbEnableProcessing, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.add((Component)this.myRbClasspath, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.add((Component)this.myRbProcessorsPath, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)5), 0, 0));
        this.add((Component)this.myProcessorPathField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.myStoreGenSourcesLabel = new JLabel("Store generated sources relative to: ");
        this.add((Component)this.myStoreGenSourcesLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myRbRelativeToOutputRoot, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myRbRelativeToContentRoot, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.myProductionLabel = new JLabel("Production sources directory:");
        this.add((Component)this.myProductionLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myGeneratedProductionDirField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.myTestLabel = new JLabel("Test sources directory:");
        this.add((Component)this.myTestLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myGeneratedTestsDirField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myProcessorTablePanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.add((Component)this.myOptionsTablePanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.myRbClasspath.addItemListener(e -> this.updateEnabledState());
        this.myProcessorTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateEnabledState();
            }
        });
        this.myCbEnableProcessing.addItemListener(e -> this.updateEnabledState());
        this.updateEnabledState();
    }

    public void setProfile(ProcessorConfigProfile config) {
        this.myCbEnableProcessing.setSelected(config.isEnabled());
        (config.isObtainProcessorsFromClasspath() ? this.myRbClasspath : this.myRbProcessorsPath).setSelected(true);
        this.myProcessorPathField.setText(FileUtil.toSystemDependentName((String)config.getProcessorPath()));
        String productionDirName = config.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedProductionDirField.setText(productionDirName != null ? productionDirName.trim() : "");
        String testsDirName = config.getGeneratedSourcesDirectoryName(true);
        this.myGeneratedTestsDirField.setText(testsDirName != null ? testsDirName.trim() : "");
        if (config.isOutputRelativeToContentRoot()) {
            this.myRbRelativeToContentRoot.setSelected(true);
        } else {
            this.myRbRelativeToOutputRoot.setSelected(true);
        }
        this.myProcessorsModel.setProcessors(config.getProcessors());
        this.myOptionsModel.setOptions(config.getProcessorOptions());
        this.updateEnabledState();
    }

    public void saveTo(ProcessorConfigProfile profile2) {
        profile2.setEnabled(this.myCbEnableProcessing.isSelected());
        profile2.setObtainProcessorsFromClasspath(this.myRbClasspath.isSelected());
        profile2.setProcessorPath(this.myProcessorPathField.getText().trim());
        String productionDir = this.myGeneratedProductionDirField.getText().trim();
        profile2.setGeneratedSourcesDirectoryName(StringUtil.isEmpty((String)productionDir) ? null : productionDir, false);
        String testsDir = this.myGeneratedTestsDirField.getText().trim();
        profile2.setGeneratedSourcesDirectoryName(StringUtil.isEmpty((String)testsDir) ? null : testsDir, true);
        profile2.setOutputRelativeToContentRoot(this.myRbRelativeToContentRoot.isSelected());
        profile2.clearProcessors();
        for (String string : this.myProcessorsModel.getProcessors()) {
            profile2.addProcessor(string);
        }
        profile2.clearProcessorOptions();
        for (Map.Entry entry : this.myOptionsModel.getOptions().entrySet()) {
            profile2.setOption((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static JPanel createTablePanel(final JBTable table) {
        return ToolbarDecorator.createDecorator((JTable)table).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                TableModel model = table.getModel();
                ((EditableModel)model).addRow();
                TableUtil.editCellAt((JTable)table, (int)(model.getRowCount() - 1), (int)0);
            }
        }).createPanel();
    }

    private void updateEnabledState() {
        boolean enabled = this.myCbEnableProcessing.isSelected();
        boolean useProcessorpath = !this.myRbClasspath.isSelected();
        this.myRbClasspath.setEnabled(enabled);
        this.myRbProcessorsPath.setEnabled(enabled);
        this.myProcessorPathField.setEnabled(enabled && useProcessorpath);
        ProcessorProfilePanel.updateTable(this.myProcessorPanel, this.myProcessorTable, enabled);
        ProcessorProfilePanel.updateTable(this.myOptionsPanel, this.myOptionsTable, enabled);
        this.myGeneratedProductionDirField.setEnabled(enabled);
        this.myGeneratedTestsDirField.setEnabled(enabled);
        this.myRbRelativeToOutputRoot.setEnabled(enabled);
        this.myRbRelativeToContentRoot.setEnabled(enabled);
        this.myStoreGenSourcesLabel.setEnabled(enabled);
        this.myProductionLabel.setEnabled(enabled);
        this.myTestLabel.setEnabled(enabled);
        this.myProcessorTablePanel.setEnabled(enabled);
        this.myOptionsTablePanel.setEnabled(enabled);
    }

    private static void updateTable(JPanel tablePanel, JBTable table, boolean enabled) {
        AnActionButton removeButton;
        AnActionButton addButton = ToolbarDecorator.findAddButton((JComponent)tablePanel);
        if (addButton != null) {
            addButton.setEnabled(enabled);
        }
        if ((removeButton = ToolbarDecorator.findRemoveButton((JComponent)tablePanel)) != null) {
            removeButton.setEnabled(enabled && table.getSelectedRow() >= 0);
        }
        table.setEnabled(enabled);
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            header.repaint();
        }
    }

    private static class ProcessorTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<String> myRows = new ArrayList<String>();

        private ProcessorTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Processor FQ Name";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.myRows.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myRows.get(rowIndex);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null) {
                switch (columnIndex) {
                    case 0: {
                        this.myRows.set(rowIndex, (String)aValue);
                    }
                }
            }
        }

        public void removeRow(int idx) {
            this.myRows.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void addRow() {
            this.myRows.add("");
            int index = this.myRows.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public void setProcessors(Collection<String> processors) {
            this.clear();
            if (!processors.isEmpty()) {
                for (String processor2 : processors) {
                    this.myRows.add(processor2);
                }
                Collections.sort(this.myRows, (o1, o2) -> o1.compareToIgnoreCase((String)o2));
                this.fireTableRowsInserted(0, processors.size() - 1);
            }
        }

        public void clear() {
            int count = this.myRows.size();
            if (count > 0) {
                this.myRows.clear();
                this.fireTableRowsDeleted(0, count - 1);
            }
        }

        public Collection<String> getProcessors() {
            HashSet<String> set2 = new HashSet<String>();
            for (String row : this.myRows) {
                if (row == null) continue;
                set2.add(row.trim());
            }
            set2.remove("");
            return set2;
        }
    }

    private static class OptionsTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<KeyValuePair> myRows = new ArrayList<KeyValuePair>();

        private OptionsTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Option Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.myRows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myRows.get((int)rowIndex).key;
                }
                case 1: {
                    return this.myRows.get((int)rowIndex).value;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null) {
                switch (columnIndex) {
                    case 0: {
                        this.myRows.get((int)rowIndex).key = (String)aValue;
                        break;
                    }
                    case 1: {
                        this.myRows.get((int)rowIndex).value = (String)aValue;
                    }
                }
            }
        }

        public void removeRow(int idx) {
            this.myRows.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void addRow() {
            this.myRows.add(new KeyValuePair());
            int index = this.myRows.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public void setOptions(Map<String, String> options) {
            this.clear();
            if (!options.isEmpty()) {
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    this.myRows.add(new KeyValuePair(entry.getKey(), entry.getValue()));
                }
                Collections.sort(this.myRows, (o1, o2) -> o1.key.compareToIgnoreCase(o2.key));
                this.fireTableRowsInserted(0, options.size() - 1);
            }
        }

        public void clear() {
            int count = this.myRows.size();
            if (count > 0) {
                this.myRows.clear();
                this.fireTableRowsDeleted(0, count - 1);
            }
        }

        public Map<String, String> getOptions() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (KeyValuePair pair2 : this.myRows) {
                map.put(pair2.key.trim(), pair2.value.trim());
            }
            map.remove("");
            return map;
        }

        private static final class KeyValuePair {
            String key;
            String value;

            KeyValuePair() {
                this("", "");
            }

            KeyValuePair(String key2, String value2) {
                this.key = key2;
                this.value = value2;
            }
        }
    }
}

