/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u0002\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0001H\u0000\u00a8\u0006\f"}, d2={"save", "Lorg/jdom/Element;", "states", "Lcom/intellij/configurationStore/StateMap;", "rootElementName", "", "newLiveStates", "", "getChangedComponentNames", "", "newStates", "normalizeRootName", "configuration-store-impl"})
public final class XmlElementStorageKt {
    private static final Element save(StateMap states, String rootElementName, Map<String, ? extends Element> newLiveStates) {
        if (states.isEmpty()) {
            return null;
        }
        Element rootElement = rootElementName == null ? null : new Element(rootElementName);
        String[] stringArray = states.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element;
            String componentName = stringArray[i];
            try {
                if (states.getElement(componentName, newLiveStates) == null) {
                    continue;
                }
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error("Cannot save \"" + componentName + "\" data", (Throwable)e);
                continue;
            }
            List elementAttributes = element.getAttributes();
            if (elementAttributes.isEmpty()) {
                element.setAttribute("name", componentName);
            } else {
                Attribute nameAttribute = element.getAttribute("name");
                if (nameAttribute == null) {
                    nameAttribute = new Attribute("name", componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue(componentName);
                    if (Intrinsics.areEqual((Object)((Attribute)elementAttributes.get(0)), (Object)nameAttribute) ^ true) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            if (rootElement == null) {
                return element;
            }
            rootElement.addContent(element);
        }
        return JdomKt.isEmpty((Element)rootElement) ? null : rootElement;
    }

    static /* bridge */ /* synthetic */ Element save$default(StateMap stateMap, String string, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        return XmlElementStorageKt.save(stateMap, string, map);
    }

    @NotNull
    public static final Element normalizeRootName(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.getParent() != null) {
            ComponentStoreImplKt.getLOG().warn("State element must not have parent " + JDOMUtil.writeElement((Element)$receiver));
            $receiver.detach();
        }
        $receiver.setName("component");
        return $receiver;
    }

    private static final Set<String> getChangedComponentNames(@NotNull StateMap $receiver, StateMap newStates) {
        Set bothStates = ArraysKt.toMutableSet((Object[])$receiver.keys());
        CollectionsKt.retainAll((Collection)bothStates, (Object[])newStates.keys());
        SmartHashSet diffs = new SmartHashSet();
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])newStates.keys());
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])$receiver.keys());
        diffs.removeAll((Collection)bothStates);
        for (String componentName : bothStates) {
            $receiver.compare(componentName, newStates, (Set)diffs);
        }
        return (Set)diffs;
    }

    @Nullable
    public static final /* synthetic */ Element access$save(@NotNull StateMap states, @Nullable String rootElementName, @Nullable Map newLiveStates) {
        return XmlElementStorageKt.save(states, rootElementName, newLiveStates);
    }

    @NotNull
    public static final /* synthetic */ Set access$getChangedComponentNames(@NotNull StateMap $receiver, @NotNull StateMap newStates) {
        return XmlElementStorageKt.getChangedComponentNames($receiver, newStates);
    }
}

