/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KdbxGroupKt;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxSerializer;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.Salsa20Encryption;
import com.intellij.util.JdomKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u00150\u0015J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015R\u0014\u0010\u0005\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R&\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "", "rootElement", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "dbMeta", "getDbMeta$credential_store", "()Lorg/jdom/Element;", "<set-?>", "", "isDirty", "()Z", "setDirty$credential_store", "(Z)V", "rootGroup", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "getRootGroup", "()Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "createEntry", "Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "title", "", "getDescription", "kotlin.jvm.PlatformType", "save", "", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "outputStream", "Ljava/io/OutputStream;", "setDescription", "description", "credential-store"})
public final class KeePassDatabase {
    private volatile boolean isDirty;
    @NotNull
    private final KdbxGroup rootGroup;
    private final Element rootElement;

    @NotNull
    public final Element getDbMeta$credential_store() {
        Element element = this.rootElement.getChild("Meta");
        if (element == null) {
            throw (Throwable)new IllegalStateException("no meta");
        }
        return element;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty$credential_store(boolean bl) {
        this.isDirty = bl;
    }

    @NotNull
    public final KdbxGroup getRootGroup() {
        return this.rootGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull KeePassCredentials credentials, @NotNull OutputStream outputStream) {
        Closeable closeable;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Element element = this.rootElement.clone();
        JdomKt.getOrCreate((Element)element, (String)"Root").addContent(this.rootGroup.toXml());
        KdbxHeader kdbxHeader = new KdbxHeader();
        Closeable closeable2 = KdbxSerializer.INSTANCE.createEncryptedOutputStream(credentials, kdbxHeader, outputStream);
        boolean bl = false;
        try {
            OutputStream it = (OutputStream)closeable2;
            JdomKt.getOrCreate((Element)element, (String)"HeaderHash").setText(Base64.getEncoder().encodeToString(kdbxHeader.getHeaderHash()));
            Element element2 = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            KdbxKt.save(element2, it, new Salsa20Encryption(kdbxHeader.getProtectedStreamKey()));
            Unit unit = Unit.INSTANCE;
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
        this.isDirty = false;
    }

    @NotNull
    public final KdbxEntry createEntry(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Element element = new Element("Entry");
        KeePassDatabaseKt.ensureElements(element, KeePassDatabaseKt.access$getMandatoryEntryElements$p());
        KdbxEntry result2 = new KdbxEntry(element, this, null);
        result2.setTitle(title);
        return result2;
    }

    public final String getDescription() {
        return this.getDbMeta$credential_store().getChildText("DatabaseDescription");
    }

    public final void setDescription(@NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        JdomKt.getOrCreate((Element)this.getDbMeta$credential_store(), (String)"DatabaseDescription").setText(description);
        JdomKt.getOrCreate((Element)this.getDbMeta$credential_store(), (String)"DatabaseDescriptionChanged").setText(KeePassDatabaseKt.formattedNow());
        this.isDirty = true;
    }

    public KeePassDatabase(@NotNull Element rootElement) {
        Element groupElement;
        Element rootElement2;
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        this.rootElement = rootElement;
        Element element = rootElement2 = JdomKt.get((Element)this.rootElement, (String)"Root");
        Object object = groupElement = element != null ? JdomKt.get((Element)element, (String)"Group") : null;
        if (groupElement == null) {
            this.rootGroup = KdbxGroupKt.createGroup(this, null);
            this.rootGroup.setName("Root");
        } else {
            Element element2 = rootElement2;
            if (element2 == null) {
                Intrinsics.throwNpe();
            }
            element2.removeChild("Group");
            this.rootGroup = new KdbxGroup(groupElement, this, null);
        }
    }

    public /* synthetic */ KeePassDatabase(Element element, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            element = KdbxKt.createEmptyDatabase();
        }
        this(element);
    }

    public KeePassDatabase() {
        this(null, 1, null);
    }
}

