/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToObjectAction
extends DebuggerAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.JumpToObjectAction");

    public void actionPerformed(AnActionEvent e) {
        DebuggerTreeNodeImpl selectedNode = JumpToObjectAction.getSelectedNode(e.getDataContext());
        if (selectedNode == null) {
            return;
        }
        NodeDescriptorImpl descriptor2 = selectedNode.getDescriptor();
        if (!(descriptor2 instanceof ValueDescriptor)) {
            return;
        }
        DebuggerContextImpl debuggerContext = JumpToObjectAction.getDebuggerContext(e.getDataContext());
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        debugProcess.getManagerThread().schedule(new NavigateCommand(debuggerContext, (ValueDescriptor)((Object)descriptor2), debugProcess, e));
    }

    public void update(AnActionEvent e) {
        if (!JumpToObjectAction.isFirstStart(e)) {
            return;
        }
        DebuggerContextImpl debuggerContext = JumpToObjectAction.getDebuggerContext(e.getDataContext());
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        DebuggerTreeNodeImpl selectedNode = JumpToObjectAction.getSelectedNode(e.getDataContext());
        if (selectedNode == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        NodeDescriptorImpl descriptor2 = selectedNode.getDescriptor();
        if (descriptor2 instanceof ValueDescriptor) {
            debugProcess.getManagerThread().schedule(new EnableCommand(debuggerContext, (ValueDescriptor)((Object)descriptor2), debugProcess, e));
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    private static SourcePosition calcPosition(ValueDescriptor descriptor2, DebugProcessImpl debugProcess) throws ClassNotLoadedException {
        Type type2 = descriptor2.getType();
        if (type2 == null) {
            return null;
        }
        try {
            if (type2 instanceof ArrayType) {
                type2 = ((ArrayType)type2).componentType();
            }
            if (type2 instanceof ClassType) {
                Location location;
                ClassType clsType = (ClassType)type2;
                Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(clsType, debugProcess.getVirtualMachineProxy());
                Location location2 = location = lambdaMethod != null ? (Location)ContainerUtil.getFirstItem(DebuggerUtilsEx.allLineLocations(lambdaMethod)) : null;
                if (location == null) {
                    location = (Location)ContainerUtil.getFirstItem(clsType.allLineLocations());
                }
                if (location != null) {
                    SourcePosition position = debugProcess.getPositionManager().getSourcePosition(location);
                    return (SourcePosition)ReadAction.compute(() -> {
                        SourcePosition classPosition;
                        PsiClass classAt;
                        if (clsType.name().indexOf(36) < 0 && (classAt = JVMNameUtil.getClassAt(position)) != null && (classPosition = SourcePosition.createFromElement((PsiElement)classAt)) != null) {
                            return classPosition;
                        }
                        return position;
                    });
                }
            }
        }
        catch (AbsentInformationException | ClassNotPreparedException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public static abstract class SourcePositionCommand
    extends SuspendContextCommandImpl {
        protected final DebuggerContextImpl myDebuggerContext;
        protected final ValueDescriptor myDescriptor;
        protected final DebugProcessImpl myDebugProcess;
        protected final AnActionEvent myActionEvent;

        public SourcePositionCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor2, DebugProcessImpl debugProcess, AnActionEvent actionEvent) {
            super(debuggerContext.getSuspendContext());
            this.myDebuggerContext = debuggerContext;
            this.myDescriptor = descriptor2;
            this.myDebugProcess = debugProcess;
            this.myActionEvent = actionEvent;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
            block3: {
                if (suspendContext == null) {
                    SourcePositionCommand.$$$reportNull$$$0(0);
                }
                try {
                    this.doAction(JumpToObjectAction.calcPosition(this.myDescriptor, this.myDebugProcess));
                }
                catch (ClassNotLoadedException ex) {
                    String className = ex.className();
                    if (this.loadClass(className) == null) break block3;
                    this.myDebugProcess.getManagerThread().schedule(this.createRetryCommand());
                }
            }
        }

        protected abstract SourcePositionCommand createRetryCommand();

        protected abstract void doAction(@Nullable SourcePosition var1);

        private ReferenceType loadClass(String className) {
            EvaluationContextImpl eContext = this.myDebuggerContext.createEvaluationContext();
            try {
                return this.myDebugProcess.loadClass(eContext, className, eContext.getClassLoader());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JumpToObjectAction$SourcePositionCommand", "contextAction"));
        }
    }

    private static class EnableCommand
    extends SourcePositionCommand {
        public EnableCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor2, DebugProcessImpl debugProcess, AnActionEvent e) {
            super(debuggerContext, descriptor2, debugProcess, e);
        }

        @Override
        protected EnableCommand createRetryCommand() {
            return new EnableCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            DebuggerAction.enableAction(this.myActionEvent, sourcePosition != null);
        }
    }

    public static class NavigateCommand
    extends SourcePositionCommand {
        public NavigateCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor2, DebugProcessImpl debugProcess, AnActionEvent e) {
            super(debuggerContext, descriptor2, debugProcess, e);
        }

        @Override
        protected NavigateCommand createRetryCommand() {
            return new NavigateCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            if (sourcePosition != null) {
                sourcePosition.navigate(true);
            }
        }
    }
}

