/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.apiAdapters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ConnectionServiceWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.apiAdapters.ConnectionService");
    private static Class myDelegateClass;
    private final Object myConnection;

    public ConnectionServiceWrapper(Object connection) {
        this.myConnection = connection;
    }

    public void close() throws IOException {
        try {
            Method method = myDelegateClass.getMethod("close", ArrayUtil.EMPTY_CLASS_ARRAY);
            method.invoke(this.myConnection, ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            LOG.error((Throwable)e);
        }
    }

    public VirtualMachine createVirtualMachine() throws IOException {
        try {
            VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
            Method method = virtualMachineManager.getClass().getMethod("createVirtualMachine", myDelegateClass);
            return (VirtualMachine)method.invoke((Object)virtualMachineManager, this.myConnection);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof VMDisconnectedException) {
                return null;
            }
            LOG.error((Throwable)e);
        }
        return null;
    }

    static {
        try {
            myDelegateClass = SystemInfo.JAVA_VERSION.startsWith("1.4") ? Class.forName("com.sun.tools.jdi.ConnectionService") : Class.forName("com.sun.jdi.connect.spi.Connection");
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
    }
}

