/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEvaluator
extends XDebuggerEvaluator {
    private final DebugProcessImpl myDebugProcess;
    private final JavaStackFrame myStackFrame;

    public JavaDebuggerEvaluator(DebugProcessImpl debugProcess, JavaStackFrame stackFrame) {
        this.myDebugProcess = debugProcess;
        this.myStackFrame = stackFrame;
    }

    public void evaluate(@NotNull String expression2, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression2 == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(1);
        }
        this.evaluate(XExpressionImpl.fromText(expression2), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression2, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression2 == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(3);
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myStackFrame.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DebuggerUIUtil.isObsolete(callback)) {
                    return;
                }
                JavaDebugProcess process2 = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                if (process2 == null) {
                    callback.errorOccurred("No debug process");
                    return;
                }
                TextWithImports text2 = TextWithImportsImpl.fromXExpression(expression2);
                NodeManagerImpl nodeManager = process2.getNodeManager();
                WatchItemDescriptor descriptor2 = nodeManager.getWatchItemDescriptor(null, text2, null);
                EvaluationContextImpl evalContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext(this.getDebuggerContext()).createEvaluationContext();
                if (evalContext == null) {
                    callback.errorOccurred("Context is not available");
                    return;
                }
                descriptor2.setContext(evalContext);
                EvaluateException exception = descriptor2.getEvaluateException();
                if (exception != null && descriptor2.getValue() == null) {
                    callback.errorOccurred(exception.getMessage());
                    return;
                }
                callback.evaluated((XValue)JavaValue.create(null, descriptor2, evalContext, nodeManager, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebuggerEvaluator$1", "threadAction"));
            }
        });
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(Project project2, Document document, int offset, boolean sideEffectsAllowed) {
        Ref currentRange = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            try {
                PsiElement elementAtCursor = DebuggerUtilsEx.findElementAt(PsiDocumentManager.getInstance((Project)project2).getPsiFile(document), offset);
                if (elementAtCursor == null || !elementAtCursor.isValid()) {
                    return;
                }
                Pair<PsiElement, TextRange> pair2 = JavaDebuggerEvaluator.findExpression(elementAtCursor, sideEffectsAllowed);
                if (pair2 != null) {
                    currentRange.set(pair2.getSecond());
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        });
        return (TextRange)currentRange.get();
    }

    @Nullable
    private static Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        EditorTextProvider textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(element.getLanguage());
        if (textProvider != null) {
            return textProvider.findExpression(element, allowMethodCalls);
        }
        return null;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text2, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (text2 == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(4);
        }
        if (psiFile != null) {
            PsiElement[] range = CodeInsightUtil.findStatementsInRange(psiFile, startOffset, endOffset);
            return range.length > 1 ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
        }
        return super.getEvaluationMode(text2, startOffset, endOffset, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEvaluationMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

