/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;

class JavaFramesListRenderer {
    private final EditorColorsScheme myColorScheme = EditorColorsManager.getInstance().getGlobalScheme();

    public void customizePresentation(StackFrameDescriptorImpl descriptor2, @NotNull ColoredTextContainer component, StackFrameDescriptorImpl selectedDescriptor) {
        if (component == null) {
            JavaFramesListRenderer.$$$reportNull$$$0(0);
        }
        component.setIcon(descriptor2.getIcon());
        boolean shouldHighlightAsRecursive = JavaFramesListRenderer.isOccurrenceOfSelectedFrame(selectedDescriptor, descriptor2);
        ValueMarkup markup = descriptor2.getValueMarkup();
        if (markup != null) {
            component.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        boolean needSeparator = false;
        String label = descriptor2.getLabel();
        int openingBrace = label.indexOf("{");
        int closingBrace = openingBrace < 0 ? -1 : label.indexOf("}");
        SimpleTextAttributes attributes = JavaFramesListRenderer.getAttributes(descriptor2);
        if (openingBrace < 0 || closingBrace < 0) {
            component.append(label, attributes);
        } else {
            component.append(label.substring(0, openingBrace - 1), attributes);
            component.append(" (" + label.substring(openingBrace + 1, closingBrace) + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            component.append(label.substring(closingBrace + 1, label.length()), attributes);
            if (shouldHighlightAsRecursive && descriptor2.isRecursiveCall()) {
                component.append(" [" + descriptor2.getOccurrenceIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    }

    private static boolean isOccurrenceOfSelectedFrame(StackFrameDescriptorImpl selectedDescriptor, StackFrameDescriptorImpl descriptor2) {
        Method selectedMethod;
        Method currentMethod = descriptor2.getMethod();
        return currentMethod != null && selectedDescriptor != null && (selectedMethod = selectedDescriptor.getMethod()) != null && Comparing.equal((Object)selectedMethod, (Object)currentMethod);
    }

    private static SimpleTextAttributes getAttributes(StackFrameDescriptorImpl descriptor2) {
        if (descriptor2.isSynthetic() || descriptor2.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaFramesListRenderer", "customizePresentation"));
    }
}

