/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FrameExtraVariablesProvider;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaFramesListRenderer;
import com.intellij.debugger.engine.JavaStaticGroup;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStackFrame
extends XStackFrame
implements JVMStackFrameInfoProvider {
    private static final Logger LOG = Logger.getInstance(JavaStackFrame.class);
    public static final DummyMessageValueNode LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE = new DummyMessageValueNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final XSourcePosition myXSourcePosition;
    private final NodeManagerImpl myNodeManager;
    @NotNull
    private final StackFrameDescriptorImpl myDescriptor;
    private static final JavaFramesListRenderer FRAME_RENDERER = new JavaFramesListRenderer();
    private JavaDebuggerEvaluator myEvaluator;
    private final String myEqualityObject;
    private CapturePoint myInsertCapturePoint;
    private static final Pair<Set<String>, Set<TextWithImports>> EMPTY_USED_VARS = Pair.create(Collections.emptySet(), Collections.emptySet());

    public JavaStackFrame(@NotNull StackFrameDescriptorImpl descriptor2, boolean update2) {
        if (descriptor2 == null) {
            JavaStackFrame.$$$reportNull$$$0(0);
        }
        this.myEvaluator = null;
        this.myDescriptor = descriptor2;
        if (update2) {
            this.myDescriptor.setContext(null);
            this.myDescriptor.updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
        }
        this.myEqualityObject = update2 ? NodeManagerImpl.getContextKeyForFrame(this.myDescriptor.getFrameProxy()) : null;
        this.myDebugProcess = (DebugProcessImpl)descriptor2.getDebugProcess();
        this.myNodeManager = this.myDebugProcess.getXdebugProcess().getNodeManager();
        this.myXSourcePosition = DebuggerUtilsEx.toXSourcePosition(this.myDescriptor.getSourcePosition());
    }

    @NotNull
    public StackFrameDescriptorImpl getDescriptor() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.myDescriptor;
        if (stackFrameDescriptorImpl == null) {
            JavaStackFrame.$$$reportNull$$$0(1);
        }
        return stackFrameDescriptorImpl;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.myEvaluator == null) {
            this.myEvaluator = new JavaDebuggerEvaluator(this.myDebugProcess, this);
        }
        return this.myEvaluator;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XStackFrame frame;
        XDebugSession xSession;
        if (component == null) {
            JavaStackFrame.$$$reportNull$$$0(2);
        }
        StackFrameDescriptorImpl selectedDescriptor = null;
        DebuggerSession session2 = this.myDebugProcess.getSession();
        if (session2 != null && (xSession = session2.getXDebugSession()) != null && (frame = xSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
            selectedDescriptor = ((JavaStackFrame)frame).getDescriptor();
        }
        FRAME_RENDERER.customizePresentation(this.myDescriptor, component, selectedDescriptor);
        if (this.myInsertCapturePoint != null) {
            component.setIcon(XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
        }
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaStackFrame.$$$reportNull$$$0(3);
        }
        if (node.isObsolete()) {
            return;
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myDescriptor.getFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.isObsolete()) {
                    return;
                }
                if (JavaStackFrame.this.myInsertCapturePoint != null) {
                    node.setMessage("Async stacktrace from " + ((JavaStackFrame)JavaStackFrame.this).myInsertCapturePoint.myClassName + "." + ((JavaStackFrame)JavaStackFrame.this).myInsertCapturePoint.myMethodName + " could be available here, enable in", XDebuggerUIConstants.INFORMATION_MESSAGE_ICON, SimpleTextAttributes.REGULAR_ATTRIBUTES, StackFrameItem.CAPTURE_SETTINGS_OPENER);
                }
                XValueChildrenList children2 = new XValueChildrenList();
                JavaStackFrame.this.buildVariablesThreadAction(JavaStackFrame.this.getFrameDebuggerContext(this.getDebuggerContext()), children2, node);
                node.addChildren(children2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaStackFrame$1", "threadAction"));
            }
        });
    }

    DebuggerContextImpl getFrameDebuggerContext(@Nullable DebuggerContextImpl context) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (context == null) {
            context = this.myDebugProcess.getDebuggerContext();
        }
        if (context.getFrameProxy() != this.getStackFrameProxy()) {
            SuspendContextImpl threadSuspendContext = SuspendManagerUtil.findContextByThread(this.myDebugProcess.getSuspendManager(), this.getStackFrameProxy().threadProxy());
            context = DebuggerContextImpl.createDebuggerContext(this.myDebugProcess.mySession, threadSuspendContext, this.getStackFrameProxy().threadProxy(), this.getStackFrameProxy());
            context.setPositionCache(this.myDescriptor.getSourcePosition());
            context.initCaches();
        }
        return context;
    }

    private void buildVariablesThreadAction(DebuggerContextImpl debuggerContext, XValueChildrenList children2, XCompositeNode node) {
        try {
            StaticDescriptorImpl staticDecriptor;
            EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
            if (evaluationContext == null) {
                return;
            }
            if (!debuggerContext.isEvaluationPossible()) {
                node.setErrorMessage(MessageDescriptor.EVALUATION_NOT_POSSIBLE.getLabel());
            }
            Location location = this.myDescriptor.getLocation();
            ObjectReference thisObjectReference = this.myDescriptor.getThisObject();
            if (thisObjectReference != null) {
                ValueDescriptorImpl thisDescriptor = this.myNodeManager.getThisDescriptor(null, thisObjectReference);
                children2.add((XNamedValue)JavaValue.create(thisDescriptor, evaluationContext, this.myNodeManager));
            } else if (location != null && (staticDecriptor = this.myNodeManager.getStaticDescriptor(this.myDescriptor, location.declaringType())).isExpandable()) {
                children2.addTopGroup((XValueGroup)new JavaStaticGroup(staticDecriptor, evaluationContext, this.myNodeManager));
            }
            DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            Pair<Method, Value> methodValuePair = debugProcess.getLastExecutedMethod();
            if (methodValuePair != null && this.myDescriptor.getUiIndex() == 0) {
                ValueDescriptorImpl returnValueDescriptor = this.myNodeManager.getMethodReturnValueDescriptor(this.myDescriptor, (Method)methodValuePair.getFirst(), (Value)methodValuePair.getSecond());
                children2.add((XNamedValue)JavaValue.create(returnValueDescriptor, evaluationContext, this.myNodeManager));
            }
            HashSet<ObjectReference> exceptions = new HashSet<ObjectReference>();
            for (Pair<Breakpoint, Event> pair2 : DebuggerUtilsEx.getEventDescriptors(debuggerContext.getSuspendContext())) {
                ObjectReference exception;
                Event debugEvent = (Event)pair2.getSecond();
                if (!(debugEvent instanceof ExceptionEvent) || (exception = ((ExceptionEvent)debugEvent).exception()) == null) continue;
                exceptions.add(exception);
            }
            exceptions.forEach(e -> children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getThrownExceptionObjectDescriptor(this.myDescriptor, (ObjectReference)e), evaluationContext, this.myNodeManager)));
            try {
                this.buildVariables(debuggerContext, evaluationContext, debugProcess, children2, thisObjectReference, location);
            }
            catch (EvaluateException e2) {
                node.setErrorMessage(e2.getMessage());
            }
        }
        catch (InvalidStackFrameException e3) {
            LOG.info((Throwable)e3);
        }
        catch (InternalException e4) {
            if (e4.errorCode() == 35) {
                node.setErrorMessage(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e4.getMessage()}));
            }
            throw e4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildVariables(DebuggerContextImpl debuggerContext, EvaluationContextImpl evaluationContext, @NotNull DebugProcessImpl debugProcess, XValueChildrenList children2, ObjectReference thisObjectReference, Location location) throws EvaluateException {
        block17: {
            ReferenceType thisRefType;
            if (debugProcess == null) {
                JavaStackFrame.$$$reportNull$$$0(4);
            }
            HashSet<String> visibleLocals = new HashSet<String>();
            if (NodeRendererSettings.getInstance().getClassRenderer().SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && thisObjectReference != null && debugProcess.getVirtualMachineProxy().canGetSyntheticAttribute() && (thisRefType = thisObjectReference.referenceType()) instanceof ClassType && location != null && thisRefType.equals(location.declaringType()) && thisRefType.name().contains("$")) {
                for (Field field : thisRefType.fields()) {
                    if (!DebuggerUtils.isSynthetic((TypeComponent)field) || !StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) continue;
                    FieldDescriptorImpl fieldDescriptorImpl = this.myNodeManager.getFieldDescriptor(this.myDescriptor, thisObjectReference, field);
                    children2.add((XNamedValue)JavaValue.create(fieldDescriptorImpl, evaluationContext, this.myNodeManager));
                    visibleLocals.add(fieldDescriptorImpl.calcValueName());
                }
            }
            boolean myAutoWatchMode = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
            if (evaluationContext == null) {
                return;
            }
            try {
                if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions() && !myAutoWatchMode) {
                    this.superBuildVariables(evaluationContext, children2);
                } else {
                    void var11_17;
                    SourcePosition sourcePosition = debuggerContext.getSourcePosition();
                    Map visibleVariables = ContainerUtil.map2Map(this.getVisibleVariables(), var -> Pair.create((Object)var.name(), (Object)var));
                    Pair<Set<String>, Set<TextWithImports>> pair2 = EMPTY_USED_VARS;
                    if (sourcePosition != null) {
                        Pair pair3 = (Pair)ReadAction.compute(() -> JavaStackFrame.findReferencedVars(ContainerUtil.union(visibleVariables.keySet(), (Set)visibleLocals), sourcePosition));
                    }
                    if (myAutoWatchMode) {
                        for (String var2 : (Set)var11_17.first) {
                            LocalVariableProxyImpl local = (LocalVariableProxyImpl)visibleVariables.get(var2);
                            if (local == null) continue;
                            children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getLocalVariableDescriptor(null, local), evaluationContext, this.myNodeManager));
                        }
                    } else {
                        this.superBuildVariables(evaluationContext, children2);
                    }
                    EvaluationContextImpl evalContextCopy = evaluationContext.withAutoLoadClasses(false);
                    if (sourcePosition != null) {
                        Set<TextWithImports> extraVars = JavaStackFrame.computeExtraVars((Pair<Set<String>, Set<TextWithImports>>)var11_17, sourcePosition, evaluationContext);
                        this.addToChildrenFrom(extraVars, children2, evaluationContext);
                    }
                    this.addToChildrenFrom((Set)var11_17.second, children2, evalContextCopy);
                }
            }
            catch (EvaluateException e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    children2.add((XNamedValue)LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                    try {
                        for (Map.Entry entry : LocalVariablesUtil.fetchValues(this.getStackFrameProxy(), debugProcess, true).entrySet()) {
                            children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getArgumentValueDescriptor(null, (DecompiledLocalVariable)entry.getKey(), (Value)entry.getValue()), evaluationContext, this.myNodeManager));
                        }
                    }
                    catch (Exception ex) {
                        LOG.info((Throwable)ex);
                        break block17;
                    }
                }
                throw e;
            }
        }
    }

    private static Set<TextWithImports> computeExtraVars(Pair<Set<String>, Set<TextWithImports>> usedVars, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evalContext) {
        if (sourcePosition == null) {
            JavaStackFrame.$$$reportNull$$$0(5);
        }
        if (evalContext == null) {
            JavaStackFrame.$$$reportNull$$$0(6);
        }
        HashSet<String> alreadyCollected = new HashSet<String>((Collection)usedVars.first);
        ((Set)usedVars.second).stream().map(TextWithImports::getText).forEach(alreadyCollected::add);
        HashSet<TextWithImports> extra = new HashSet<TextWithImports>();
        for (FrameExtraVariablesProvider provider : (FrameExtraVariablesProvider[])FrameExtraVariablesProvider.EP_NAME.getExtensions()) {
            if (!provider.isAvailable(sourcePosition, evalContext)) continue;
            extra.addAll(provider.collectVariables(sourcePosition, evalContext, alreadyCollected));
        }
        return extra;
    }

    private void addToChildrenFrom(Set<TextWithImports> expressions2, XValueChildrenList children2, EvaluationContextImpl evaluationContext) {
        for (TextWithImports text2 : expressions2) {
            WatchItemDescriptor descriptor2 = this.myNodeManager.getWatchItemDescriptor(null, text2, null);
            children2.add((XNamedValue)JavaValue.create(descriptor2, evaluationContext, this.myNodeManager));
        }
    }

    public static XNamedValue createMessageNode(String text2, Icon icon) {
        return new DummyMessageValueNode(text2, icon);
    }

    protected void superBuildVariables(EvaluationContextImpl evaluationContext, XValueChildrenList children2) throws EvaluateException {
        for (LocalVariableProxyImpl local : this.getVisibleVariables()) {
            children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getLocalVariableDescriptor(null, local), evaluationContext, this.myNodeManager));
        }
    }

    @NotNull
    public StackFrameProxyImpl getStackFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.myDescriptor.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            JavaStackFrame.$$$reportNull$$$0(7);
        }
        return stackFrameProxyImpl;
    }

    @Nullable
    public Object getEqualityObject() {
        return this.myEqualityObject;
    }

    public String toString() {
        if (this.myXSourcePosition != null) {
            return "JavaFrame " + this.myXSourcePosition.getFile().getName() + ":" + this.myXSourcePosition.getLine();
        }
        return "JavaFrame position unknown";
    }

    protected List<LocalVariableProxyImpl> getVisibleVariables() throws EvaluateException {
        return this.getStackFrameProxy().visibleVariables();
    }

    private static boolean shouldSkipLine(PsiFile file2, Document doc, int line) {
        int start = doc.getLineStartOffset(line);
        int end = doc.getLineEndOffset(line);
        int _start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)start, (String)" \n\t");
        if (_start >= end) {
            return true;
        }
        TextRange alreadyChecked = null;
        for (PsiElement elem = file2.findElementAt(_start); !(elem == null || elem.getTextOffset() > end || alreadyChecked != null && alreadyChecked.contains(elem.getTextRange())); elem = elem.getNextSibling()) {
            PsiElement _elem = elem;
            while (_elem.getTextOffset() >= _start) {
                alreadyChecked = _elem.getTextRange();
                if (_elem instanceof PsiDeclarationStatement) {
                    PsiElement[] declared;
                    for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)_elem).getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiVariable)) continue;
                        return false;
                    }
                }
                if (_elem instanceof PsiJavaCodeReferenceElement) {
                    try {
                        PsiElement resolved = ((PsiJavaCodeReferenceElement)_elem).resolve();
                        if (resolved instanceof PsiVariable) {
                            return false;
                        }
                    }
                    catch (IndexNotReadyException e) {
                        return false;
                    }
                }
                _elem = _elem.getParent();
            }
        }
        return true;
    }

    private static Pair<Set<String>, Set<TextWithImports>> findReferencedVars(Set<String> visibleVars, @NotNull SourcePosition position) {
        int offset;
        PsiElement element;
        int endLine;
        Document doc;
        int line;
        if (position == null) {
            JavaStackFrame.$$$reportNull$$$0(8);
        }
        if ((line = position.getLine()) < 0) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        PsiFile positionFile = position.getFile();
        if (!positionFile.isValid() || !positionFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Pair.create(visibleVars, Collections.emptySet());
        }
        VirtualFile vFile = positionFile.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        TextRange limit = JavaStackFrame.calculateLimitRange(positionFile, doc, line);
        int startLine = Math.max(limit.getStartOffset(), line - 1);
        for (startLine = Math.min(startLine, limit.getEndOffset()); startLine > limit.getStartOffset() && JavaStackFrame.shouldSkipLine(positionFile, doc, startLine); --startLine) {
        }
        int startOffset = doc.getLineStartOffset(startLine);
        for (endLine = Math.min(line + 2, limit.getEndOffset()); endLine < limit.getEndOffset() && JavaStackFrame.shouldSkipLine(positionFile, doc, endLine); ++endLine) {
        }
        int endOffset = doc.getLineEndOffset(endLine);
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (!lineRange.isEmpty() && (element = positionFile.findElementAt(offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \t"))) != null) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class});
            if (method != null) {
                element = method;
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class});
                if (field != null) {
                    element = field;
                } else {
                    PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiClassInitializer.class});
                    if (initializer != null) {
                        element = initializer;
                    }
                }
            }
            if (element instanceof PsiCompiledElement) {
                return Pair.create(visibleVars, Collections.emptySet());
            }
            VariablesCollector collector = new VariablesCollector(visibleVars, JavaStackFrame.adjustRange(element, lineRange));
            element.accept((PsiElementVisitor)collector);
            return Pair.create(collector.getVars(), collector.getExpressions());
        }
        return Pair.create(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange calculateLimitRange(PsiFile file2, Document doc, int line) {
        PsiMethod method;
        int offset = doc.getLineStartOffset(line);
        if (offset > 0 && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiMethod.class, (boolean)false)) != null) {
            TextRange elemRange = method.getTextRange();
            return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
        }
        return new TextRange(0, doc.getLineCount() - 1);
    }

    private static TextRange adjustRange(PsiElement element, final TextRange originalRange) {
        final Ref rangeRef = new Ref((Object)originalRange);
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(PsiExpressionStatement statement2) {
                TextRange stRange = statement2.getTextRange();
                if (originalRange.intersects(stRange)) {
                    TextRange currentRange = (TextRange)rangeRef.get();
                    int start = Math.min(currentRange.getStartOffset(), stRange.getStartOffset());
                    int end = Math.max(currentRange.getEndOffset(), stRange.getEndOffset());
                    rangeRef.set((Object)new TextRange(start, end));
                }
            }
        });
        return (TextRange)rangeRef.get();
    }

    public void setInsertCapturePoint(CapturePoint insertCapturePoint) {
        this.myInsertCapturePoint = insertCapturePoint;
    }

    @Override
    public boolean isSynthetic() {
        return this.myDescriptor.isSynthetic();
    }

    @Override
    public boolean isInLibraryContent() {
        return this.myDescriptor.isInLibraryContent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaStackFrame frame = (JavaStackFrame)o;
        return this.myDescriptor.getFrameProxy().equals(frame.myDescriptor.getFrameProxy());
    }

    public int hashCode() {
        return this.myDescriptor.getFrameProxy().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaStackFrame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFrameProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeExtraVars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedVars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> myVisibleLocals;
        private final TextRange myLineRange;
        private final Set<TextWithImports> myExpressions = new HashSet<TextWithImports>();
        private final Set<String> myVars = new HashSet<String>();
        private final boolean myCollectExpressions = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();

        public VariablesCollector(Set<String> visibleLocals, TextRange lineRange) {
            this.myVisibleLocals = visibleLocals;
            this.myLineRange = lineRange;
        }

        public Set<String> getVars() {
            return this.myVars;
        }

        public Set<TextWithImports> getExpressions() {
            return this.myExpressions;
        }

        public void visitElement(PsiElement element) {
            if (this.myLineRange.intersects(element.getTextRange())) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiMethod psiMethod;
            if (this.myCollectExpressions && (psiMethod = expression2.resolveMethod()) != null && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression2, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression2));
            }
            super.visitMethodCallExpression(expression2);
        }

        public void visitReferenceExpression(PsiReferenceExpression reference) {
            PsiElement psiElement;
            if (this.myLineRange.intersects(reference.getTextRange()) && (psiElement = reference.resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)psiElement;
                if (var instanceof PsiField) {
                    if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)reference, this.myVisibleLocals)) {
                        boolean isConstant;
                        PsiModifierList modifierList = var.getModifierList();
                        boolean bl = isConstant = var instanceof PsiEnumConstant || modifierList != null && modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final");
                        if (!isConstant) {
                            this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                        }
                    }
                } else if (this.myVisibleLocals.contains(var.getName())) {
                    this.myVars.add(var.getName());
                } else if (!Comparing.equal((Object)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class), (Object)PsiTreeUtil.getParentOfType((PsiElement)var, PsiClass.class))) {
                    this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                }
            }
            super.visitReferenceExpression(reference);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression2, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression2));
            }
            super.visitArrayAccessExpression(expression2);
        }

        public void visitParameter(PsiParameter parameter2) {
            this.processVariable((PsiVariable)parameter2);
            super.visitParameter(parameter2);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            this.processVariable((PsiVariable)variable);
            super.visitLocalVariable(variable);
        }

        private void processVariable(PsiVariable variable) {
            if (this.myLineRange.intersects(variable.getTextRange()) && this.myVisibleLocals.contains(variable.getName())) {
                this.myVars.add(variable.getName());
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }

    static class DummyMessageValueNode
    extends XNamedValue {
        private final String myMessage;
        private final Icon myIcon;

        public DummyMessageValueNode(String message2, Icon icon) {
            super("");
            this.myMessage = message2;
            this.myIcon = icon;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                DummyMessageValueNode.$$$reportNull$$$0(0);
            }
            if (place == null) {
                DummyMessageValueNode.$$$reportNull$$$0(1);
            }
            node.setPresentation(this.myIcon, new XValuePresentation(){

                @NotNull
                public String getSeparator() {
                    if ("" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "";
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    renderer.renderValue(myMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "renderer";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSeparator";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "renderValue";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, false);
        }

        public String toString() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode";
            objectArray[2] = "computePresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

