/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public abstract class JavaValueModifier
extends XValueModifier {
    private final JavaValue myJavaValue;

    public JavaValueModifier(JavaValue javaValue) {
        this.myJavaValue = javaValue;
    }

    public void calculateInitialValueEditorText(final XValueModifier.XInitialValueCallback callback) {
        final Value value2 = this.myJavaValue.getDescriptor().getValue();
        if (value2 instanceof PrimitiveValue) {
            String valueString = this.myJavaValue.getValueString();
            int pos = valueString.lastIndexOf(40);
            if (pos > 1) {
                valueString = valueString.substring(0, pos).trim();
            }
            callback.setValue(valueString);
        } else if (value2 instanceof StringReference) {
            final EvaluationContextImpl evaluationContext = this.myJavaValue.getEvaluationContext();
            evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(evaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    callback.setValue(StringUtil.wrapWithDoubleQuote((String)DebuggerUtils.translateStringValue((String)DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)value2))));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$1", "contextAction"));
                }
            });
        } else {
            callback.setValue(null);
        }
    }

    protected static void update(DebuggerContextImpl context) {
        DebuggerInvocationUtil.swingInvokeLater(context.getProject(), () -> {
            DebuggerSession session2 = context.getDebuggerSession();
            if (session2 != null) {
                session2.refresh(false);
            }
        });
    }

    protected abstract void setValueImpl(@NotNull String var1, @NotNull XValueModifier.XModificationCallback var2);

    public void setValue(@NotNull String expression2, @NotNull XValueModifier.XModificationCallback callback) {
        ValueDescriptorImpl descriptor2;
        if (expression2 == null) {
            JavaValueModifier.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaValueModifier.$$$reportNull$$$0(1);
        }
        if (!(descriptor2 = this.myJavaValue.getDescriptor()).canSetValue()) {
            return;
        }
        if (this.myJavaValue.getEvaluationContext().getSuspendContext().isResumed()) {
            callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            return;
        }
        this.setValueImpl(expression2, callback);
    }

    protected static Value preprocessValue(EvaluationContextImpl context, Value value2, Type varType) throws EvaluateException {
        String v;
        if (value2 != null && "java.lang.String".equals(varType.name()) && !(value2 instanceof StringReference) && (v = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)value2)) != null) {
            value2 = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf(v);
        }
        if (value2 instanceof DoubleValue) {
            double dValue = ((DoubleValue)value2).doubleValue();
            if (varType instanceof FloatType && (double)1.4E-45f <= dValue && dValue <= 3.4028234663852886E38) {
                value2 = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf((float)dValue);
            }
        }
        if (value2 != null) {
            if (varType instanceof PrimitiveType) {
                if (!(value2 instanceof PrimitiveValue)) {
                    value2 = (Value)new UnBoxingEvaluator(new IdentityEvaluator(value2)).evaluate(context);
                }
            } else if (varType instanceof ReferenceType && value2 instanceof PrimitiveValue) {
                value2 = (Value)new BoxingEvaluator(new IdentityEvaluator(value2)).evaluate(context);
            }
        }
        return value2;
    }

    private static void setValue(String expressionToShow, ExpressionEvaluator evaluator, EvaluationContextImpl evaluationContext, SetValueRunnable setValueRunnable) throws EvaluateException {
        try {
            Value value2 = evaluator.evaluate((EvaluationContext)evaluationContext);
            setValueRunnable.setValue(evaluationContext, value2);
        }
        catch (IllegalArgumentException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)ex.getMessage());
        }
        catch (InvalidTypeException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.type.mismatch", (Object[])new Object[0]));
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (ClassNotLoadedException ex) {
            if (!evaluationContext.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)ex);
            }
            try {
                ReferenceType refType = setValueRunnable.loadClass(evaluationContext, ex.className());
                if (refType != null) {
                    JavaValueModifier.setValue(expressionToShow, evaluator, evaluationContext, setValueRunnable);
                }
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
        }
    }

    protected void set(final @NotNull String expression2, final XValueModifier.XModificationCallback callback, DebuggerContextImpl debuggerContext, final SetValueRunnable setValueRunnable) {
        if (expression2 == null) {
            JavaValueModifier.$$$reportNull$$$0(2);
        }
        final ProgressWindow progressWindow = new ProgressWindow(true, debuggerContext.getProject());
        final EvaluationContextImpl evaluationContext = this.myJavaValue.getEvaluationContext();
        DebuggerContextCommandImpl askSetAction = new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    final Project project2 = evaluationContext.getProject();
                    final SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
                    final PsiElement context = ContextUtil.getContextElement((StackFrameContext)evaluationContext, position);
                    ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project2, new EvaluatingComputable<ExpressionEvaluator>(){

                        @Override
                        public ExpressionEvaluator compute() throws EvaluateException {
                            return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression2), context, position, project2);
                        }
                    });
                    JavaValueModifier.setValue(expression2, evaluator, evaluationContext, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException {
                            if (!progressWindow.isCanceled()) {
                                setValueRunnable.setValue(evaluationContext, newValue);
                            }
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, EvaluateException, IncompatibleThreadStateException, InvalidTypeException {
                            return setValueRunnable.loadClass(evaluationContext, className);
                        }
                    });
                    callback.valueModified();
                }
                catch (EvaluateException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$2", "threadAction"));
            }
        };
        progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        evaluationContext.getDebugProcess().getManagerThread().startProgress((DebuggerCommandImpl)askSetAction, progressWindow);
    }

    private static String getDisplayableString(PrimitiveValue value2, boolean showAsHex) {
        if (value2 instanceof CharValue) {
            long longValue = value2.longValue();
            return showAsHex ? "0x" + Long.toHexString(longValue).toUpperCase() : Long.toString(longValue);
        }
        if (value2 instanceof ByteValue) {
            byte val = value2.byteValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 2) {
                strValue = strValue.substring(strValue.length() - 2);
            }
            return showAsHex ? "0x" + strValue : value2.toString();
        }
        if (value2 instanceof ShortValue) {
            short val = value2.shortValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 4) {
                strValue = strValue.substring(strValue.length() - 4);
            }
            return showAsHex ? "0x" + strValue : value2.toString();
        }
        if (value2 instanceof IntegerValue) {
            int val = value2.intValue();
            return showAsHex ? "0x" + Integer.toHexString(val).toUpperCase() : value2.toString();
        }
        if (value2 instanceof LongValue) {
            long val = value2.longValue();
            return showAsHex ? "0x" + Long.toHexString(val).toUpperCase() + "L" : value2.toString() + "L";
        }
        return DebuggerUtils.translateStringValue((String)value2.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaValueModifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static interface SetValueRunnable {
        public void setValue(EvaluationContextImpl var1, Value var2) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException;

        public ReferenceType loadClass(EvaluationContextImpl var1, String var2) throws EvaluateException, InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;
    }
}

