/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuspendContextImpl
extends XSuspendContext
implements SuspendContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendContextImpl");
    private final DebugProcessImpl myDebugProcess;
    private final int mySuspendPolicy;
    private ThreadReferenceProxyImpl myThread;
    boolean myIsVotedForResume;
    protected int myVotesToVote;
    protected Set<ThreadReferenceProxyImpl> myResumedThreads;
    private final EventSet myEventSet;
    private volatile boolean myIsResumed;
    private final ConcurrentLinkedQueue<SuspendContextCommandImpl> myPostponedCommands;
    public volatile boolean myInProgress;
    private final HashSet<ObjectReference> myKeptReferences;
    private EvaluationContextImpl myEvaluationContext;
    private JavaExecutionStack myActiveExecutionStack;
    private static final Comparator<JavaExecutionStack> THREADS_COMPARATOR = (th1, th2) -> {
        int res = Comparing.compare((boolean)th2.getThreadProxy().isSuspended(), (boolean)th1.getThreadProxy().isSuspended());
        if (res == 0) {
            return th1.getDisplayName().compareToIgnoreCase(th2.getDisplayName());
        }
        return res;
    };

    SuspendContextImpl(@NotNull DebugProcessImpl debugProcess, int suspendPolicy, int eventVotes, EventSet set2) {
        if (debugProcess == null) {
            SuspendContextImpl.$$$reportNull$$$0(0);
        }
        this.myIsVotedForResume = true;
        this.myPostponedCommands = new ConcurrentLinkedQueue();
        this.myKeptReferences = new HashSet();
        this.myEvaluationContext = null;
        this.myDebugProcess = debugProcess;
        this.mySuspendPolicy = suspendPolicy;
        this.myVotesToVote = eventVotes;
        this.myEventSet = set2;
    }

    public void setThread(ThreadReference thread) {
        this.assertNotResumed();
        ThreadReferenceProxyImpl threadProxy = this.myDebugProcess.getVirtualMachineProxy().getThreadReferenceProxy(thread);
        LOG.assertTrue(this.myThread == null || this.myThread == threadProxy);
        this.myThread = threadProxy;
    }

    protected abstract void resumeImpl();

    protected void resume() {
        this.assertNotResumed();
        if (this.isEvaluating()) {
            LOG.error("Resuming context while evaluating", new String[]{ThreadDumper.dumpThreadsToString()});
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                this.myKeptReferences.forEach(DebuggerUtilsEx::enableCollection);
                this.myKeptReferences.clear();
            }
            SuspendContextCommandImpl cmd = this.pollPostponedCommand();
            while (cmd != null) {
                cmd.notifyCancelled();
                cmd = this.pollPostponedCommand();
            }
            this.resumeImpl();
        }
        finally {
            this.myIsResumed = true;
        }
    }

    private void assertNotResumed() {
        if (this.myIsResumed && this.myDebugProcess.isAttached()) {
            LOG.error("Cannot access SuspendContext. SuspendContext is resumed.");
        }
    }

    @Nullable
    public EventSet getEventSet() {
        return this.myEventSet;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.myDebugProcess;
        if (debugProcessImpl == null) {
            SuspendContextImpl.$$$reportNull$$$0(1);
        }
        return debugProcessImpl;
    }

    public StackFrameProxyImpl getFrameProxy() {
        this.assertNotResumed();
        try {
            return this.myThread != null && this.myThread.frameCount() > 0 ? this.myThread.frame(0) : null;
        }
        catch (EvaluateException ignored) {
            return null;
        }
    }

    @Nullable
    public ThreadReferenceProxyImpl getThread() {
        return this.myThread;
    }

    public int getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    public void doNotResumeHack() {
        this.assertNotResumed();
        this.myVotesToVote = 1000000000;
    }

    public boolean isExplicitlyResumed(@Nullable ThreadReferenceProxyImpl thread) {
        return this.myResumedThreads != null && this.myResumedThreads.contains(thread);
    }

    public boolean suspends(ThreadReferenceProxyImpl thread) {
        this.assertNotResumed();
        if (this.isEvaluating()) {
            return false;
        }
        switch (this.getSuspendPolicy()) {
            case 2: {
                return !this.isExplicitlyResumed(thread);
            }
            case 1: {
                return thread == this.getThread();
            }
        }
        return false;
    }

    public boolean isEvaluating() {
        this.assertNotResumed();
        return this.myEvaluationContext != null;
    }

    public EvaluationContextImpl getEvaluationContext() {
        return this.myEvaluationContext;
    }

    public boolean isResumed() {
        return this.myIsResumed;
    }

    public void setIsEvaluating(EvaluationContextImpl evaluationContext) {
        this.assertNotResumed();
        this.myEvaluationContext = evaluationContext;
    }

    public String toString() {
        if (this.myEventSet != null) {
            return this.myEventSet.toString();
        }
        return this.myThread != null ? this.myThread.toString() : DebuggerBundle.message((String)"string.null.context", (Object[])new Object[0]);
    }

    public void keep(ObjectReference reference) {
        boolean added;
        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (added = this.myKeptReferences.add((Object)reference))) {
            DebuggerUtilsEx.disableCollection(reference);
        }
    }

    public final void postponeCommand(SuspendContextCommandImpl command) {
        if (!this.isResumed()) {
            command.hold();
            this.myPostponedCommands.add(command);
        } else {
            command.notifyCancelled();
        }
    }

    public final SuspendContextCommandImpl pollPostponedCommand() {
        return this.myPostponedCommands.poll();
    }

    @Nullable
    public JavaExecutionStack getActiveExecutionStack() {
        return this.myActiveExecutionStack;
    }

    public void initExecutionStacks(ThreadReferenceProxyImpl activeThread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myThread == null) {
            this.myThread = activeThread;
        }
        if (activeThread != null) {
            this.myActiveExecutionStack = new JavaExecutionStack(activeThread, this.myDebugProcess, this.myThread == activeThread);
            this.myActiveExecutionStack.initTopFrame();
        }
    }

    public void computeExecutionStacks(final XSuspendContext.XExecutionStackContainer container) {
        this.myDebugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(this){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<JavaExecutionStack> res = new ArrayList<JavaExecutionStack>();
                Collection<ThreadReferenceProxyImpl> threads = SuspendContextImpl.this.getDebugProcess().getVirtualMachineProxy().allThreads();
                JavaExecutionStack currentStack = null;
                for (ThreadReferenceProxyImpl thread : threads) {
                    boolean current = thread == SuspendContextImpl.this.myThread;
                    JavaExecutionStack stack = new JavaExecutionStack(thread, SuspendContextImpl.this.myDebugProcess, current);
                    if (!current) {
                        res.add(stack);
                        continue;
                    }
                    currentStack = stack;
                }
                res.sort(THREADS_COMPARATOR);
                if (currentStack != null) {
                    res.add(0, currentStack);
                }
                container.addExecutionStack(res, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/SuspendContextImpl$1", "contextAction"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendContextImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendContextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

