/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SmartHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspendManagerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManagerUtil");

    public static boolean isEvaluating(SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        for (SuspendContextImpl suspendContext : suspendManager.getEventContexts()) {
            if (!suspendContext.isEvaluating() || !thread.equals(suspendContext.getThread())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static SuspendContextImpl findContextByThread(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(0);
        }
        for (SuspendContextImpl context : suspendManager.getEventContexts()) {
            if (context.getThread() != thread && context.getSuspendPolicy() != 2 || context.isExplicitlyResumed(thread)) continue;
            return context;
        }
        return null;
    }

    public static void assertSuspendContext(SuspendContextImpl context) {
        if (LOG.isDebugEnabled()) {
            LOG.assertTrue(context.myInProgress, (Object)"You can invoke methods only inside commands invoked for SuspendContext");
        }
    }

    @NotNull
    public static Set<SuspendContextImpl> getSuspendingContexts(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(1);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set set2 = (Set)suspendManager.getEventContexts().stream().filter(suspendContext -> suspendContext.suspends(thread)).collect(Collectors.toCollection(SmartHashSet::new));
        if (set2 == null) {
            SuspendManagerUtil.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @Nullable
    public static SuspendContextImpl getSuspendingContext(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(3);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return suspendManager.getEventContexts().stream().filter(suspendContext -> suspendContext.suspends(thread)).findFirst().orElse(null);
    }

    public static void restoreAfterResume(SuspendContextImpl context, Object resumeData) {
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ResumeData data = (ResumeData)resumeData;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (data.myIsFrozen && !suspendManager.isFrozen(thread)) {
            suspendManager.freezeThread(thread);
        }
        LOG.debug("RestoreAfterResume SuspendContextImpl...");
        LOG.assertTrue(context.myResumedThreads == null);
        if (data.myResumedThreads != null) {
            data.myResumedThreads.forEach(ThreadReferenceProxyImpl::resume);
            context.myResumedThreads = data.myResumedThreads;
        }
    }

    public static Object prepareForResume(SuspendContextImpl context) {
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl thread = context.getThread();
        ResumeData resumeData = new ResumeData(suspendManager.isFrozen(thread), context.myResumedThreads);
        if (resumeData.myIsFrozen) {
            suspendManager.unfreezeThread(thread);
        }
        LOG.debug("Resuming SuspendContextImpl...");
        if (context.myResumedThreads != null) {
            context.myResumedThreads.forEach(ThreadReferenceProxyImpl::suspend);
            context.myResumedThreads = null;
        }
        return resumeData;
    }

    public static SuspendContextImpl getEvaluatingContext(SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        for (SuspendContextImpl suspendContext : suspendManager.getEventContexts()) {
            if (suspendContext.isResumed() || !suspendContext.isEvaluating() || suspendContext.getThread() != thread) continue;
            return suspendContext;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendingContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContextByThread";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContexts";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResumeData {
        final boolean myIsFrozen;
        final Set<ThreadReferenceProxyImpl> myResumedThreads;

        public ResumeData(boolean isFrozen, Set<ThreadReferenceProxyImpl> resumedThreads) {
            this.myIsFrozen = isFrozen;
            this.myResumedThreads = resumedThreads;
        }
    }
}

