/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.DebuggerComputableValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EvaluationContextImpl
implements EvaluationContext {
    private static final Logger LOG = Logger.getInstance(EvaluationContextImpl.class);
    private final DebuggerComputableValue myThisObject;
    private final SuspendContextImpl mySuspendContext;
    private final StackFrameProxyImpl myFrameProxy;
    private boolean myAutoLoadClasses;
    private ClassLoaderReference myClassLoader;

    private EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @NotNull DebuggerComputableValue thisObjectComputableValue) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(0);
        }
        if (thisObjectComputableValue == null) {
            EvaluationContextImpl.$$$reportNull$$$0(1);
        }
        this.myAutoLoadClasses = true;
        this.myThisObject = thisObjectComputableValue;
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @NotNull EvaluatingComputable<Value> thisObjectFactory) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(2);
        }
        if (thisObjectFactory == null) {
            EvaluationContextImpl.$$$reportNull$$$0(3);
        }
        this(suspendContext, frameProxy, new DebuggerComputableValue(thisObjectFactory));
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @Nullable Value thisObject) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(4);
        }
        this(suspendContext, frameProxy, new DebuggerComputableValue(thisObject));
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(5);
        }
        this(suspendContext, frameProxy, () -> frameProxy != null ? frameProxy.thisObject() : null);
    }

    @Deprecated
    @Nullable
    public Value getThisObject() {
        try {
            return this.computeThisObject();
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    public Value computeThisObject() throws EvaluateException {
        return this.myThisObject.getValue();
    }

    @NotNull
    public SuspendContextImpl getSuspendContext() {
        SuspendContextImpl suspendContextImpl = this.mySuspendContext;
        if (suspendContextImpl == null) {
            EvaluationContextImpl.$$$reportNull$$$0(6);
        }
        return suspendContextImpl;
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrameProxy;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.getSuspendContext().getDebugProcess();
        if (debugProcessImpl == null) {
            EvaluationContextImpl.$$$reportNull$$$0(7);
        }
        return debugProcessImpl;
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.getDebugProcess().getManagerThread();
    }

    public Project getProject() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess.getProject();
    }

    public EvaluationContextImpl createEvaluationContext(Value value2) {
        EvaluationContextImpl copy = new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value2);
        copy.setAutoLoadClasses(this.myAutoLoadClasses);
        return copy;
    }

    @Nullable
    public ClassLoaderReference getClassLoader() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myClassLoader != null) {
            return this.myClassLoader;
        }
        return this.myFrameProxy != null ? this.myFrameProxy.getClassLoader() : null;
    }

    public void setClassLoader(ClassLoaderReference classLoader) {
        this.myClassLoader = classLoader;
    }

    public boolean isAutoLoadClasses() {
        return this.myAutoLoadClasses;
    }

    public void setAutoLoadClasses(boolean autoLoadClasses) {
        this.myAutoLoadClasses = autoLoadClasses;
    }

    public EvaluationContextImpl withAutoLoadClasses(boolean autoLoadClasses) {
        if (this.myAutoLoadClasses == autoLoadClasses) {
            return this;
        }
        EvaluationContextImpl copy = new EvaluationContextImpl(this.mySuspendContext, this.myFrameProxy, this.myThisObject);
        copy.setAutoLoadClasses(autoLoadClasses);
        return copy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObjectComputableValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObjectFactory";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/EvaluationContextImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/EvaluationContextImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

