/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnBoxingEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(UnBoxingEvaluator.class);
    private final Evaluator myOperand;
    private static final Map<String, Couple<String>> TYPES_TO_CONVERSION_METHOD_MAP = new HashMap();

    public static boolean isTypeUnboxable(String typeName) {
        return TYPES_TO_CONVERSION_METHOD_MAP.containsKey(typeName);
    }

    public UnBoxingEvaluator(@NotNull Evaluator operand2) {
        if (operand2 == null) {
            UnBoxingEvaluator.$$$reportNull$$$0(0);
        }
        this.myOperand = DisableGC.create(operand2);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return UnBoxingEvaluator.unbox(this.myOperand.evaluate(context), context);
    }

    public static Object unbox(@Nullable Object value2, EvaluationContextImpl context) throws EvaluateException {
        String valueTypeName;
        Couple<String> pair2;
        if (value2 == null) {
            throw new EvaluateException("java.lang.NullPointerException: cannot unbox null value");
        }
        if (value2 instanceof ObjectReference && (pair2 = TYPES_TO_CONVERSION_METHOD_MAP.get(valueTypeName = ((ObjectReference)value2).type().name())) != null) {
            return UnBoxingEvaluator.convertToPrimitive(context, (ObjectReference)value2, (String)pair2.getFirst(), (String)pair2.getSecond());
        }
        return value2;
    }

    private static Value convertToPrimitive(EvaluationContextImpl context, ObjectReference value2, String conversionMethodName, String conversionMethodSignature) throws EvaluateException {
        PrimitiveValue primitiveValue = UnBoxingEvaluator.getInnerPrimitiveValue(value2);
        if (primitiveValue != null) {
            return primitiveValue;
        }
        Method method = ((ClassType)value2.referenceType()).concreteMethodByName(conversionMethodName, conversionMethodSignature);
        if (method == null) {
            throw new EvaluateException("Cannot convert to primitive value of type " + value2.type() + ": Unable to find method " + conversionMethodName + conversionMethodSignature);
        }
        return context.getDebugProcess().invokeMethod((EvaluationContext)context, value2, method, Collections.emptyList());
    }

    @Nullable
    public static PrimitiveValue getInnerPrimitiveValue(@Nullable ObjectReference value2) {
        Value primitiveValue;
        ReferenceType type2;
        Field valueField;
        if (value2 != null && (valueField = (type2 = value2.referenceType()).fieldByName("value")) != null && (primitiveValue = value2.getValue(valueField)) instanceof PrimitiveValue) {
            LOG.assertTrue(type2.name().equals(PsiJavaParserFacadeImpl.getPrimitiveType(primitiveValue.type().name()).getBoxedTypeName()));
            return (PrimitiveValue)primitiveValue;
        }
        return null;
    }

    static {
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Boolean", (Couple<String>)Couple.of((Object)"booleanValue", (Object)"()Z"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Byte", (Couple<String>)Couple.of((Object)"byteValue", (Object)"()B"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Character", (Couple<String>)Couple.of((Object)"charValue", (Object)"()C"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Short", (Couple<String>)Couple.of((Object)"shortValue", (Object)"()S"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Integer", (Couple<String>)Couple.of((Object)"intValue", (Object)"()I"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Long", (Couple<String>)Couple.of((Object)"longValue", (Object)"()J"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Float", (Couple<String>)Couple.of((Object)"floatValue", (Object)"()F"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Double", (Couple<String>)Couple.of((Object)"doubleValue", (Object)"()D"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/debugger/engine/evaluation/expression/UnBoxingEvaluator", "<init>"));
    }
}

