/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DebuggerContextUtil {
    public static void setStackFrame(final DebuggerStateManager manager, final StackFrameProxyImpl stackFrame) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = manager.getContext();
        final DebuggerSession session2 = context.getDebuggerSession();
        if (session2 != null) {
            session2.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl threadSuspendContext = SuspendManagerUtil.findContextByThread(session2.getProcess().getSuspendManager(), stackFrame.threadProxy());
                    DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session2, threadSuspendContext, stackFrame.threadProxy(), stackFrame);
                    DebuggerInvocationUtil.swingInvokeLater(session2.getProject(), () -> {
                        manager.setState(newContext, session2.getState(), DebuggerSession.Event.REFRESH, null);
                        SourceCodeChecker.checkSource(newContext);
                    });
                }
            });
        } else {
            manager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.REFRESH, null);
        }
    }

    public static void setThread(DebuggerStateManager contextManager, ThreadDescriptorImpl item) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerSession session2 = contextManager.getContext().getDebuggerSession();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session2, item.getSuspendContext(), item.getThreadReference(), null);
        contextManager.setState(newContext, session2 != null ? session2.getState() : DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession session2, SuspendContextImpl suspendContext) {
        if (session2 == null) {
            DebuggerContextUtil.$$$reportNull$$$0(0);
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(session2, suspendContext, suspendContext != null ? suspendContext.getThread() : null, null);
        if (debuggerContextImpl == null) {
            DebuggerContextUtil.$$$reportNull$$$0(1);
        }
        return debuggerContextImpl;
    }

    public static SourcePosition findNearest(@NotNull DebuggerContextImpl context, @NotNull PsiElement psi, @NotNull PsiFile file2) {
        if (context == null) {
            DebuggerContextUtil.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            DebuggerContextUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            DebuggerContextUtil.$$$reportNull$$$0(4);
        }
        if (psi instanceof PsiCompiledElement) {
            return null;
        }
        DebuggerSession session2 = context.getDebuggerSession();
        if (session2 != null) {
            try {
                XDebugSession debugSession = session2.getXDebugSession();
                if (debugSession != null) {
                    XSourcePosition position = debugSession.getCurrentPosition();
                    Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)file2.getProject())).getSelectedTextEditor(true);
                    if (editor != null && position != null && position.getFile().equals(file2.getOriginalFile().getVirtualFile())) {
                        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)context), PsiMethod.class, (boolean)false);
                        Collection<TextRange> ranges = IdentifierHighlighterPass.getUsages(psi, (PsiElement)(method != null ? method : file2), false);
                        int breakPointLine = position.getLine();
                        int bestLine = -1;
                        int bestOffset = -1;
                        for (TextRange range : ranges) {
                            int line = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
                            if (line > bestLine && line < breakPointLine) {
                                bestLine = line;
                                bestOffset = range.getStartOffset();
                                continue;
                            }
                            if (line != breakPointLine) continue;
                            bestOffset = range.getStartOffset();
                            break;
                        }
                        if (bestOffset > -1) {
                            return SourcePosition.createFromOffset((PsiFile)file2, (int)bestOffset);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebuggerContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDebuggerContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNearest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

