/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StringReferenceProxy;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.TargetVM;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.VirtualMachineProxyImpl");
    private final DebugProcessImpl myDebugProcess;
    private final VirtualMachine myVirtualMachine;
    private int myTimeStamp;
    private int myPausePressedCount;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> myObjectReferenceProxies;
    private final Map<String, StringReference> myStringLiteralCache;
    @NotNull
    private final Map<ThreadReference, ThreadReferenceProxyImpl> myAllThreads;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> myThreadGroups;
    private boolean myAllThreadsDirty;
    private List<ReferenceType> myAllClasses;
    private MultiMap<String, ReferenceType> myAllClassesByName;
    private Map<ReferenceType, List<ReferenceType>> myNestedClassesCache;
    public final Throwable mySuspendLogger;
    private final boolean myVersionHigher_15;
    private final boolean myVersionHigher_14;
    private final Capability myWatchFielsModification;
    private final Capability myWatchFieldAccess;
    private final Capability myIsJ2ME;
    private final Capability myGetBytecodes;
    private final Capability myGetSyntheticAttribute;
    private final Capability myGetOwnedMonitorInfo;
    private final Capability myGetMonitorFrameInfo;
    private final Capability myGetCurrentContendedMonitor;
    private final Capability myGetMonitorInfo;
    private final Capability myUseInstanceFilters;
    private final Capability myRedefineClasses;
    private final Capability myAddMethod;
    private final Capability myUnrestrictedlyRedefineClasses;
    private final Capability myPopFrames;
    private final Capability myForceEarlyReturn;
    private final Capability myCanGetInstanceInfo;
    private final Capability myGetSourceDebugExtension;
    private final Capability myRequestVMDeathEvent;
    private final Capability myGetMethodReturnValues;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcess, @NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(0);
        }
        this.myTimeStamp = 0;
        this.myPausePressedCount = 0;
        this.myObjectReferenceProxies = new HashMap();
        this.myStringLiteralCache = new HashMap();
        this.myAllThreads = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
        this.myThreadGroups = new HashMap();
        this.myAllThreadsDirty = true;
        this.myNestedClassesCache = new HashMap();
        this.mySuspendLogger = new Throwable();
        this.myWatchFielsModification = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canWatchFieldModification();
            }
        };
        this.myWatchFieldAccess = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canWatchFieldAccess();
            }
        };
        this.myIsJ2ME = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.isJ2ME();
            }
        };
        this.myGetBytecodes = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetBytecodes();
            }
        };
        this.myGetSyntheticAttribute = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetSyntheticAttribute();
            }
        };
        this.myGetOwnedMonitorInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetOwnedMonitorInfo();
            }
        };
        this.myGetMonitorFrameInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetMonitorFrameInfo();
            }
        };
        this.myGetCurrentContendedMonitor = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetCurrentContendedMonitor();
            }
        };
        this.myGetMonitorInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetMonitorInfo();
            }
        };
        this.myUseInstanceFilters = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canUseInstanceFilters();
            }
        };
        this.myRedefineClasses = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canRedefineClasses();
            }
        };
        this.myAddMethod = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canAddMethod();
            }
        };
        this.myUnrestrictedlyRedefineClasses = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canUnrestrictedlyRedefineClasses();
            }
        };
        this.myPopFrames = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canPopFrames();
            }
        };
        this.myForceEarlyReturn = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canForceEarlyReturn();
            }
        };
        this.myCanGetInstanceInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                if (!VirtualMachineProxyImpl.this.myVersionHigher_15) {
                    return false;
                }
                try {
                    Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                    return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.myVirtualMachine, new Object[0]);
                }
                catch (NoSuchMethodException method) {
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error((Throwable)e);
                }
                return false;
            }
        };
        this.myGetSourceDebugExtension = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canGetSourceDebugExtension();
            }
        };
        this.myRequestVMDeathEvent = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canRequestVMDeathEvent();
            }
        };
        this.myGetMethodReturnValues = new Capability(){

            @Override
            protected boolean calcValue() {
                if (VirtualMachineProxyImpl.this.myVersionHigher_15) {
                    try {
                        Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                        Boolean rv = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.myVirtualMachine, new Object[0]);
                        return rv;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        this.myVirtualMachine = virtualMachine;
        this.myDebugProcess = debugProcess;
        this.myVersionHigher_15 = this.versionHigher("1.5");
        this.myVersionHigher_14 = this.myVersionHigher_15 || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        try {
            virtualMachine.allClasses();
        }
        catch (VMDisconnectedException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    @NotNull
    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = this.myVirtualMachine;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(1);
        }
        return virtualMachine;
    }

    public List<ReferenceType> classesByName(@NotNull String s) {
        String signature;
        if (s == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(2);
        }
        if ((signature = JNITypeParserReflect.typeNameToSignature(s)) != null) {
            List<ReferenceType> res;
            if (this.myAllClassesByName == null) {
                this.myAllClassesByName = new MultiMap();
                this.allClasses().forEach(t -> this.myAllClassesByName.putValue((Object)t.signature(), t));
            }
            if ((res = this.myAllClassesByName.get((Object)signature)).isEmpty() && !(res = this.myVirtualMachine.classesByName(s)).isEmpty()) {
                LOG.error("Debugger VM cache does not contain a loaded class " + s);
            }
            return res;
        }
        return this.myVirtualMachine.classesByName(s);
    }

    public List<ReferenceType> nestedTypes(ReferenceType refType) {
        List<Object> nestedTypes = this.myNestedClassesCache.get(refType);
        if (nestedTypes == null) {
            List<Object> list2 = Collections.emptyList();
            try {
                list2 = refType.nestedTypes();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            if (!list2.isEmpty()) {
                HashSet<ReferenceType> candidates = new HashSet<ReferenceType>();
                ClassLoaderReference outerLoader = refType.classLoader();
                for (ReferenceType referenceType : list2) {
                    try {
                        if (!(outerLoader == null ? referenceType.classLoader() == null : outerLoader.equals(referenceType.classLoader()))) continue;
                        candidates.add(referenceType);
                    }
                    catch (ObjectCollectedException objectCollectedException) {}
                }
                if (!candidates.isEmpty()) {
                    HashSet<ReferenceType> nested2 = new HashSet<ReferenceType>();
                    for (ReferenceType candidate : candidates) {
                        nested2.addAll(this.nestedTypes(candidate));
                    }
                    candidates.removeAll(nested2);
                }
                nestedTypes = candidates.isEmpty() ? Collections.emptyList() : new ArrayList(candidates);
            } else {
                nestedTypes = Collections.emptyList();
            }
            this.myNestedClassesCache.put(refType, nestedTypes);
        }
        return nestedTypes;
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> allClasses = this.myAllClasses;
        if (allClasses == null) {
            this.myAllClasses = allClasses = this.myVirtualMachine.allClasses();
        }
        return allClasses;
    }

    public String toString() {
        return this.myVirtualMachine.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.myVirtualMachine.redefineClasses(map);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myAllThreadsDirty) {
            this.myAllThreadsDirty = false;
            for (ThreadReference threadReference : this.myVirtualMachine.allThreads()) {
                this.getThreadReferenceProxy(threadReference);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.myAllThreads.values());
    }

    public void threadStarted(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.getThreadReferenceProxy(thread);
    }

    public void threadStopped(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myAllThreads.remove(thread);
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.myPausePressedCount;
        this.myVirtualMachine.suspend();
        this.clearCaches();
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myPausePressedCount > 0) {
            --this.myPausePressedCount;
        }
        this.clearCaches();
        LOG.debug("before resume VM");
        try {
            this.myVirtualMachine.resume();
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        LOG.debug("VM resumed");
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        List<ThreadGroupReference> list2 = this.getVirtualMachine().topLevelThreadGroups();
        ArrayList<ThreadGroupReferenceProxyImpl> result2 = new ArrayList<ThreadGroupReferenceProxyImpl>(list2.size());
        for (ThreadGroupReference threadGroup : list2) {
            result2.add(this.getThreadGroupReferenceProxy(threadGroup));
        }
        return result2;
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl proxy = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.myThreadGroups.put(threadGroupReference, proxy);
        }
    }

    public boolean isJ2ME() {
        return VirtualMachineProxyImpl.isJ2ME(this.getVirtualMachine());
    }

    private static boolean isJ2ME(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myThreadGroups.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.myVirtualMachine.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.myVirtualMachine.eventRequestManager();
    }

    @Deprecated
    public VoidValue mirrorOf() throws EvaluateException {
        return this.mirrorOfVoid();
    }

    public VoidValue mirrorOfVoid() {
        return this.myVirtualMachine.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public ByteValue mirrorOf(byte b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public CharValue mirrorOf(char c) {
        return this.myVirtualMachine.mirrorOf(c);
    }

    public ShortValue mirrorOf(short i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public IntegerValue mirrorOf(int i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public LongValue mirrorOf(long l) {
        return this.myVirtualMachine.mirrorOf(l);
    }

    public FloatValue mirrorOf(float v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public DoubleValue mirrorOf(double v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public StringReference mirrorOf(String s) {
        return this.myVirtualMachine.mirrorOf(s);
    }

    public StringReference mirrorOfStringLiteral(String s, ThrowableComputable<StringReference, EvaluateException> generator) throws EvaluateException {
        StringReference reference = this.myStringLiteralCache.get(s);
        if (reference != null && !reference.isCollected()) {
            return reference;
        }
        reference = (StringReference)generator.compute();
        this.myStringLiteralCache.put(s, reference);
        return reference;
    }

    public Process process() {
        return this.myVirtualMachine.process();
    }

    public void dispose() {
        try {
            this.myVirtualMachine.dispose();
        }
        catch (UnsupportedOperationException e) {
            LOG.info((Throwable)e);
        }
        finally {
            Thread controller;
            TargetVM target2 = (TargetVM)ReflectionUtil.getField(this.myVirtualMachine.getClass(), (Object)this.myVirtualMachine, TargetVM.class, (String)"target");
            if (target2 != null && (controller = (Thread)ReflectionUtil.getField(target2.getClass(), (Object)target2, Thread.class, (String)"eventController")) != null) {
                controller.stop();
            }
        }
    }

    public void exit(int i) {
        this.myVirtualMachine.exit(i);
    }

    public boolean canWatchFieldModification() {
        return this.myWatchFielsModification.isAvailable();
    }

    public boolean canWatchFieldAccess() {
        return this.myWatchFieldAccess.isAvailable();
    }

    public boolean canInvokeMethods() {
        return !this.myIsJ2ME.isAvailable();
    }

    public boolean canGetBytecodes() {
        return this.myGetBytecodes.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.myGetSyntheticAttribute.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.myGetOwnedMonitorInfo.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.myGetMonitorFrameInfo.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.myGetCurrentContendedMonitor.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.myGetMonitorInfo.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.myUseInstanceFilters.isAvailable();
    }

    public boolean canRedefineClasses() {
        return this.myRedefineClasses.isAvailable();
    }

    public boolean canAddMethod() {
        return this.myAddMethod.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.myUnrestrictedlyRedefineClasses.isAvailable();
    }

    public boolean canPopFrames() {
        return this.myPopFrames.isAvailable();
    }

    public boolean canForceEarlyReturn() {
        return this.myForceEarlyReturn.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.myCanGetInstanceInfo.isAvailable();
    }

    public final boolean versionHigher(String version) {
        return this.myVirtualMachine.version().compareTo(version) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.myGetSourceDebugExtension.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.myRequestVMDeathEvent.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.myGetMethodReturnValues.isAvailable();
    }

    public String getDefaultStratum() {
        return this.myVersionHigher_14 ? this.myVirtualMachine.getDefaultStratum() : null;
    }

    public String description() {
        return this.myVirtualMachine.description();
    }

    public String version() {
        return this.myVirtualMachine.version();
    }

    public String name() {
        return this.myVirtualMachine.name();
    }

    public void setDebugTraceMode(int i) {
        this.myVirtualMachine.setDebugTraceMode(i);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread == null) {
            return null;
        }
        return this.myAllThreads.computeIfAbsent(thread, t -> new ThreadReferenceProxyImpl(this, (ThreadReference)t));
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference group) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (group == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl proxy = this.myThreadGroups.get(group);
        if (proxy == null && !this.myIsJ2ME.isAvailable()) {
            proxy = new ThreadGroupReferenceProxyImpl(this, group);
            this.myThreadGroups.put(group, proxy);
        }
        return proxy;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                return this.getThreadReferenceProxy((ThreadReference)objectReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                return this.getThreadGroupReferenceProxy((ThreadGroupReference)objectReference);
            }
            ObjectReferenceProxyImpl proxy = this.myObjectReferenceProxies.get(objectReference);
            if (proxy == null) {
                proxy = objectReference instanceof StringReference ? new StringReferenceProxy(this, (StringReference)objectReference) : new ObjectReferenceProxyImpl(this, objectReference);
                this.myObjectReferenceProxies.put(objectReference, proxy);
            }
            return proxy;
        }
        return null;
    }

    public boolean equals(Object obj) {
        LOG.assertTrue(obj instanceof VirtualMachineProxyImpl);
        return this.myVirtualMachine.equals(((VirtualMachineProxyImpl)obj).getVirtualMachine());
    }

    public int hashCode() {
        return this.myVirtualMachine.hashCode();
    }

    public void clearCaches() {
        LOG.debug("VM cleared");
        this.myAllClasses = null;
        this.myAllClassesByName = null;
        if (!this.myNestedClassesCache.isEmpty()) {
            this.myNestedClassesCache = new HashMap(this.myNestedClassesCache.size());
        }
        ++this.myTimeStamp;
    }

    @Override
    public int getCurrentTime() {
        return this.myTimeStamp;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public static boolean isCollected(ObjectReference reference) {
        try {
            return !VirtualMachineProxyImpl.isJ2ME(reference.virtualMachine()) && reference.isCollected();
        }
        catch (UnsupportedOperationException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    public String getResumeStack() {
        return StringUtil.getThrowableText((Throwable)this.mySuspendLogger);
    }

    public boolean isPausePressed() {
        return this.myPausePressedCount > 0;
    }

    public boolean isSuspended() {
        return this.allThreads().stream().anyMatch(thread -> thread.getSuspendCount() != 0);
    }

    public void logThreads() {
        if (LOG.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl thread : this.allThreads()) {
                if (thread.isCollected()) continue;
                LOG.debug("suspends " + thread + " " + thread.getSuspendCount() + " " + thread.isSuspended());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class Capability {
        private ThreeState myValue = ThreeState.UNSURE;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.myValue == ThreeState.UNSURE) {
                try {
                    this.myValue = ThreeState.fromBoolean((boolean)this.calcValue());
                }
                catch (VMDisconnectedException e) {
                    LOG.info((Throwable)e);
                    this.myValue = ThreeState.NO;
                }
            }
            return this.myValue.toBoolean();
        }

        protected abstract boolean calcValue();
    }

    static final class JNITypeParserReflect {
        static final Method typeNameToSignatureMethod = ReflectionUtil.getDeclaredMethod(JNITypeParser.class, (String)"typeNameToSignature", (Class[])new Class[]{String.class});

        JNITypeParserReflect() {
        }

        @Nullable
        static String typeNameToSignature(@NotNull String name2) {
            if (name2 == null) {
                JNITypeParserReflect.$$$reportNull$$$0(0);
            }
            if (typeNameToSignatureMethod != null) {
                try {
                    return (String)typeNameToSignatureMethod.invoke(null, name2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            if (typeNameToSignatureMethod == null) {
                LOG.warn("Unable to find JNITypeParser.typeNameToSignature method");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/jdi/VirtualMachineProxyImpl$JNITypeParserReflect", "typeNameToSignature"));
        }
    }
}

