/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final ValuesList myValues;
    private final ConditionChecker myChecker;
    private final FilteringTaskCallback myCallback;
    private volatile boolean myIsCancelled;

    public FilteringTask(@NotNull String className, @NotNull DebugProcessImpl debugProcess, @NotNull XExpression expression2, @NotNull ValuesList values, @NotNull FilteringTaskCallback callback) {
        if (className == null) {
            FilteringTask.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            FilteringTask.$$$reportNull$$$0(1);
        }
        if (expression2 == null) {
            FilteringTask.$$$reportNull$$$0(2);
        }
        if (values == null) {
            FilteringTask.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            FilteringTask.$$$reportNull$$$0(4);
        }
        this.myIsCancelled = false;
        this.myChecker = StringUtil.isEmptyOrSpaces((String)expression2.getExpression()) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcess, expression2, className);
        this.myValues = values;
        this.myCallback = callback;
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    @Override
    public void run() {
        int proceedCount;
        this.myCallback.started(this.myValues.size());
        for (proceedCount = 0; proceedCount < this.myValues.size() && !this.myIsCancelled; ++proceedCount) {
            Value value2 = this.myValues.get(proceedCount);
            CheckingResult result2 = this.myChecker.check(value2);
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            switch (result2.getResult()) {
                case MATCH: {
                    action = this.myCallback.matched(value2);
                    break;
                }
                case NO_MATCH: {
                    action = this.myCallback.notMatched(value2);
                    break;
                }
                case ERROR: {
                    action = this.myCallback.error(value2, result2.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        FilteringResult reason = this.myIsCancelled ? FilteringResult.INTERRUPTED : (proceedCount == this.myValues.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.myCallback.completed(reason);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/memory/filtering/FilteringTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ValuesList {
        public int size();

        public Value get(int var1);
    }
}

