/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance(CaptureConfigurable.class);
    private JCheckBox myDebuggerAgent;
    private MyTableModel myTableModel;
    private JCheckBox myCaptureVariables;

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            CaptureConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.idesettings.debugger.capture" == null) {
            CaptureConfigurable.$$$reportNull$$$0(1);
        }
        return "reference.idesettings.debugger.capture";
    }

    @Nullable
    public JComponent createComponent() {
        this.myTableModel = new MyTableModel();
        final JBTable table = new JBTable((TableModel)this.myTableModel);
        table.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = table.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)table);
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CaptureConfigurable.this.myTableModel.addRow();
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)table);
            }
        });
        decorator.setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)table);
            }
        });
        decorator.setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)table);
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Duplicate", "Duplicate", PlatformIcons.COPY_ICON){

            public boolean isEnabled() {
                return table.getSelectedRowCount() == 1;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    try {
                        int idx = CaptureConfigurable.this.myTableModel.add(c.clone());
                        table.getSelectionModel().setSelectionInterval(idx, idx);
                    }
                    catch (CloneNotSupportedException ex) {
                        LOG.error((Throwable)ex);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$5", "actionPerformed"));
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Enable Selected", "Enable Selected", PlatformIcons.SELECT_ALL_ICON){

            public boolean isEnabled() {
                return table.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    c.myEnabled = true;
                });
                table.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$6", "actionPerformed"));
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Disable Selected", "Disable Selected", PlatformIcons.UNSELECT_ALL_ICON){

            public boolean isEnabled() {
                return table.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    c.myEnabled = false;
                });
                table.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$7", "actionPerformed"));
            }
        });
        new DumbAwareAction("Toggle"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(table.getSelectedRowCount() == 1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    c.myEnabled = !c.myEnabled;
                });
                table.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/settings/CaptureConfigurable$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)table);
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Import", "Import", AllIcons.Actions.Install){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, true, false, true, true){

                    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                        return super.isFileVisible(file2, showHiddenFiles) && (file2.isDirectory() || "xml".equals(file2.getExtension()) || file2.getFileType() == FileTypes.ARCHIVE);
                    }

                    public boolean isFileSelectable(VirtualFile file2) {
                        return file2.getFileType() == StdFileTypes.XML;
                    }
                };
                descriptor2.setDescription("Please select a file to import.");
                descriptor2.setTitle("Import Capture Points");
                Object[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)e.getProject(), null);
                if (ArrayUtil.isEmpty((Object[])files)) {
                    return;
                }
                table.getSelectionModel().clearSelection();
                for (Object file2 : files) {
                    try {
                        Document document = JDOMUtil.loadDocument((InputStream)file2.getInputStream());
                        List children2 = document.getRootElement().getChildren();
                        children2.forEach(element -> {
                            int idx = CaptureConfigurable.this.myTableModel.addIfNeeded((CapturePoint)XmlSerializer.deserialize((Element)element, CapturePoint.class));
                            table.getSelectionModel().addSelectionInterval(idx, idx);
                        });
                    }
                    catch (Exception ex) {
                        String msg = ex.getLocalizedMessage();
                        Messages.showErrorDialog((Project)e.getProject(), (String)(msg != null && msg.length() > 0 ? msg : ex.toString()), (String)"Export Failed");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$9", "actionPerformed"));
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Export", "Export", AllIcons.Actions.Export){

            public void actionPerformed(@NotNull AnActionEvent e) {
                VirtualFileWrapper wrapper;
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                if ((wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Export Selected Capture Points to File...", "", new String[]{"xml"}), e.getProject()).save(null, null)) == null) {
                    return;
                }
                Element rootElement = new Element("capture-points");
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    try {
                        CapturePoint clone = c.clone();
                        clone.myEnabled = false;
                        rootElement.addContent(XmlSerializer.serialize((Object)clone));
                    }
                    catch (CloneNotSupportedException ex) {
                        LOG.error((Throwable)ex);
                    }
                });
                try {
                    JDOMUtil.write((Parent)rootElement, (File)wrapper.getFile());
                }
                catch (Exception ex) {
                    String msg = ex.getLocalizedMessage();
                    Messages.showErrorDialog((Project)e.getProject(), (String)(msg != null && msg.length() > 0 ? msg : ex.toString()), (String)"Export Failed");
                }
            }

            public boolean isEnabled() {
                return table.getSelectedRowCount() > 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$10", "actionPerformed"));
            }
        });
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel();
        this.myDebuggerAgent = new JCheckBox(DebuggerBundle.message((String)"label.capture.configurable.debugger.agent", (Object[])new Object[0]));
        if (Registry.is((String)"debugger.capture.points.agent")) {
            panel2.addToTop((Component)this.myDebuggerAgent);
        }
        BorderLayoutPanel debuggerPanel = JBUI.Panels.simplePanel();
        if (Registry.is((String)"debugger.capture.points.agent")) {
            debuggerPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Breakpoints based", (boolean)false));
        }
        debuggerPanel.addToCenter((Component)decorator.createPanel());
        this.myCaptureVariables = new JCheckBox(DebuggerBundle.message((String)"label.capture.configurable.capture.variables", (Object[])new Object[0]));
        debuggerPanel.addToBottom((Component)this.myCaptureVariables);
        panel2.addToCenter((Component)debuggerPanel);
        return panel2;
    }

    private StreamEx<CapturePoint> selectedCapturePoints(JBTable table) {
        return IntStreamEx.of((int[])table.getSelectedRows()).map(arg_0 -> table.convertRowIndexToModel(arg_0)).mapToObj(this.myTableModel::get);
    }

    public boolean isModified() {
        return DebuggerSettings.getInstance().CAPTURE_VARIABLES != this.myCaptureVariables.isSelected() || DebuggerSettings.getInstance().INSTRUMENTING_AGENT != this.myDebuggerAgent.isSelected() || !DebuggerSettings.getInstance().getCapturePoints().equals(this.myTableModel.myCapturePoints);
    }

    public void apply() throws ConfigurationException {
        DebuggerSettings.getInstance().setCapturePoints(this.myTableModel.myCapturePoints);
        DebuggerSettings.getInstance().CAPTURE_VARIABLES = this.myCaptureVariables.isSelected();
        DebuggerSettings.getInstance().INSTRUMENTING_AGENT = this.myDebuggerAgent.isSelected();
    }

    public void reset() {
        this.myCaptureVariables.setSelected(DebuggerSettings.getInstance().CAPTURE_VARIABLES);
        this.myDebuggerAgent.setSelected(DebuggerSettings.getInstance().INSTRUMENTING_AGENT);
        this.myTableModel.myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();
        this.myTableModel.scanPoints();
        this.myTableModel.fireTableDataChanged();
    }

    @Nls
    public String getDisplayName() {
        return DebuggerBundle.message((String)"async.stacktraces.configurable.display.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/settings/CaptureConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        public static final int ENABLED_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int METHOD_COLUMN = 2;
        public static final int PARAM_COLUMN = 3;
        public static final int INSERT_CLASS_COLUMN = 4;
        public static final int INSERT_METHOD_COLUMN = 5;
        public static final int INSERT_KEY_EXPR = 6;
        static final String[] COLUMN_NAMES = new String[]{"", "Capture class name", "Capture method name", "Capture key expression", "Insert class name", "Insert method name", "Insert key expression"};
        List<CapturePoint> myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();

        private MyTableModel() {
            this.scanPoints();
        }

        private void scanPoints() {
            if (Registry.is((String)"debugger.capture.points.annotations")) {
                ArrayList<CapturePoint> capturePointsFromAnnotations = new ArrayList<CapturePoint>();
                MyTableModel.scanPointsInt(true, capturePointsFromAnnotations);
                MyTableModel.scanPointsInt(false, capturePointsFromAnnotations);
                capturePointsFromAnnotations.forEach(this::addIfNeeded);
            }
        }

        private static void scanPointsInt(boolean capture, List<CapturePoint> capturePointsFromAnnotations) {
            try {
                String annotationName = (capture ? Debugger.Capture.class : Debugger.Insert.class).getName().replace("$", ".");
                Project project2 = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
                GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project2);
                PsiClass annotationClass = JavaPsiFacade.getInstance((Project)project2).findClass(annotationName, allScope);
                if (annotationClass != null) {
                    AnnotatedElementsSearch.searchElements((PsiClass)annotationClass, (SearchScope)allScope, (Class[])new Class[]{PsiMethod.class, PsiParameter.class}).forEach(e -> {
                        if (e instanceof PsiMethod) {
                            MyTableModel.addCapturePointIfNeeded(e, (PsiMethod)e, annotationName, "this", capture, capturePointsFromAnnotations);
                        } else if (e instanceof PsiParameter) {
                            PsiParameter psiParameter = (PsiParameter)e;
                            PsiMethod psiMethod = (PsiMethod)psiParameter.getDeclarationScope();
                            MyTableModel.addCapturePointIfNeeded((PsiModifierListOwner)psiParameter, psiMethod, annotationName, "param_" + psiMethod.getParameterList().getParameterIndex(psiParameter), capture, capturePointsFromAnnotations);
                        }
                    });
                }
            }
            catch (IndexNotReadyException annotationName) {
            }
            catch (Exception e2) {
                LOG.error((Throwable)e2);
            }
        }

        private static void addCapturePointIfNeeded(PsiModifierListOwner psiElement, PsiMethod psiMethod, String annotationName, String defaultExpression, boolean capture, List<CapturePoint> capturePointsFromAnnotations) {
            PsiAnnotation annotation;
            CapturePoint capturePoint = new CapturePoint();
            capturePoint.myEnabled = false;
            if (capture) {
                capturePoint.myClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            } else {
                capturePoint.myInsertClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myInsertMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            }
            PsiModifierList modifierList = psiElement.getModifierList();
            if (modifierList != null && (annotation = modifierList.findAnnotation(annotationName)) != null) {
                String group;
                String keyExpression;
                PsiAnnotationMemberValue keyExpressionValue = annotation.findAttributeValue("keyExpression");
                String string = keyExpression = keyExpressionValue != null ? StringUtil.unquoteString((String)keyExpressionValue.getText()) : null;
                if (StringUtil.isEmpty((String)keyExpression)) {
                    keyExpression = defaultExpression;
                }
                if (capture) {
                    capturePoint.myCaptureKeyExpression = keyExpression;
                } else {
                    capturePoint.myInsertKeyExpression = keyExpression;
                }
                PsiAnnotationMemberValue groupValue = annotation.findAttributeValue("group");
                String string2 = group = groupValue != null ? StringUtil.unquoteString((String)groupValue.getText()) : null;
                if (!StringUtil.isEmpty((String)group)) {
                    for (CapturePoint capturePointsFromAnnotation : capturePointsFromAnnotations) {
                        if (!StringUtil.startsWith((CharSequence)group, (CharSequence)capturePointsFromAnnotation.myClassName) || !StringUtil.endsWith((CharSequence)group, (CharSequence)capturePointsFromAnnotation.myMethodName)) continue;
                        capturePointsFromAnnotation.myInsertClassName = capturePoint.myInsertClassName;
                        capturePointsFromAnnotation.myInsertMethodName = capturePoint.myInsertMethodName;
                        capturePointsFromAnnotation.myInsertKeyExpression = capturePoint.myInsertKeyExpression;
                        return;
                    }
                }
            }
            capturePointsFromAnnotations.add(capturePoint);
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public int getRowCount() {
            return this.myCapturePoints.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            CapturePoint point = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    return point.myEnabled;
                }
                case 1: {
                    return point.myClassName;
                }
                case 2: {
                    return point.myMethodName;
                }
                case 3: {
                    return point.myCaptureKeyExpression;
                }
                case 4: {
                    return point.myInsertClassName;
                }
                case 5: {
                    return point.myInsertMethodName;
                }
                case 6: {
                    return point.myInsertKeyExpression;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object value2, int row, int col) {
            CapturePoint point = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    point.myEnabled = (Boolean)value2;
                    break;
                }
                case 1: {
                    point.myClassName = (String)value2;
                    break;
                }
                case 2: {
                    point.myMethodName = (String)value2;
                    break;
                }
                case 3: {
                    point.myCaptureKeyExpression = (String)value2;
                    break;
                }
                case 4: {
                    point.myInsertClassName = (String)value2;
                    break;
                }
                case 5: {
                    point.myInsertMethodName = (String)value2;
                    break;
                }
                case 6: {
                    point.myInsertKeyExpression = (String)value2;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        CapturePoint get(int idx) {
            return this.myCapturePoints.get(idx);
        }

        int add(CapturePoint p) {
            this.myCapturePoints.add(p);
            int lastRow = this.getRowCount() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
            return lastRow;
        }

        int addIfNeeded(CapturePoint p) {
            CapturePoint clone = p;
            try {
                clone = p.clone();
                clone.myEnabled = !clone.myEnabled;
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
            }
            int idx = this.myCapturePoints.indexOf(p);
            if (idx < 0) {
                idx = this.myCapturePoints.indexOf(clone);
            }
            if (idx < 0) {
                idx = this.add(p);
            }
            return idx;
        }

        public void addRow() {
            this.add(new CapturePoint());
        }

        public void removeRow(int row) {
            this.myCapturePoints.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }
}

