/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThrownExceptionValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final SimpleTextAttributes DEFAULT_ATTRIBUTES = new SimpleTextAttributes(0, null);
    private static final SimpleTextAttributes SPECIAL_NODE_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
    private static final SimpleTextAttributes OBJECT_ID_HIGHLIGHT_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DebuggerTreeNodeImpl node;
        if (tree == null) {
            DebuggerTreeRenderer.$$$reportNull$$$0(0);
        }
        if ((node = (DebuggerTreeNodeImpl)value2) != null) {
            SimpleColoredText text2 = node.getText();
            if (text2 != null) {
                text2.appendToComponent((ColoredTextContainer)this);
            }
            this.setIcon(node.getIcon());
        }
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptor descriptor2) {
        Icon nodeIcon = null;
        if (descriptor2 instanceof ThreadGroupDescriptorImpl) {
            nodeIcon = ((ThreadGroupDescriptorImpl)descriptor2).isCurrent() ? AllIcons.Debugger.ThreadGroupCurrent : AllIcons.Debugger.ThreadGroup;
        } else if (descriptor2 instanceof ThreadDescriptorImpl) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)descriptor2;
            nodeIcon = threadDescriptor.getIcon();
        } else if (descriptor2 instanceof StackFrameDescriptorImpl) {
            StackFrameDescriptorImpl stackDescriptor = (StackFrameDescriptorImpl)descriptor2;
            nodeIcon = stackDescriptor.getIcon();
        } else if (descriptor2 instanceof ValueDescriptorImpl) {
            nodeIcon = DebuggerTreeRenderer.getValueIcon((ValueDescriptorImpl)descriptor2, null);
        } else if (descriptor2 instanceof MessageDescriptor) {
            MessageDescriptor messageDescriptor = (MessageDescriptor)descriptor2;
            if (messageDescriptor.getKind() == 0) {
                nodeIcon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 2) {
                nodeIcon = XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 3) {
                nodeIcon = null;
            }
        } else if (descriptor2 instanceof StaticDescriptorImpl) {
            nodeIcon = AllIcons.Nodes.Static;
        }
        return nodeIcon;
    }

    public static Icon getValueIcon(ValueDescriptorImpl valueDescriptor, @Nullable ValueDescriptorImpl parentDescriptor) {
        XDebugSessionTab tab;
        XDebugSession session2;
        EnumerationChildrenRenderer enumerationChildrenRenderer;
        Icon nodeIcon;
        if (valueDescriptor instanceof FieldDescriptorImpl) {
            Value value2;
            FieldDescriptorImpl fieldDescriptor = (FieldDescriptorImpl)valueDescriptor;
            nodeIcon = PlatformIcons.FIELD_ICON;
            if (parentDescriptor != null && (value2 = valueDescriptor.getValue()) instanceof ObjectReference && value2.equals(parentDescriptor.getValue())) {
                nodeIcon = AllIcons.Debugger.Selfreference;
            }
            if (fieldDescriptor.getField().isFinal()) {
                nodeIcon = new LayeredIcon(new Icon[]{nodeIcon, AllIcons.Nodes.FinalMark});
            }
            if (fieldDescriptor.isStatic()) {
                nodeIcon = new LayeredIcon(new Icon[]{nodeIcon, AllIcons.Nodes.StaticMark});
            }
        } else {
            nodeIcon = valueDescriptor instanceof ThrownExceptionValueDescriptorImpl ? AllIcons.Nodes.ExceptionClass : (valueDescriptor instanceof MethodReturnValueDescriptorImpl ? AllIcons.Debugger.WatchLastReturnValue : (DebuggerTreeRenderer.isParameter(valueDescriptor) ? PlatformIcons.PARAMETER_ICON : (valueDescriptor.isEnumConstant() ? PlatformIcons.ENUM_ICON : (valueDescriptor.isArray() ? AllIcons.Debugger.Db_array : (valueDescriptor.isPrimitive() ? AllIcons.Debugger.Db_primitive : (valueDescriptor instanceof WatchItemDescriptor ? AllIcons.Debugger.Watch : AllIcons.Debugger.Value))))));
        }
        if (valueDescriptor instanceof UserExpressionDescriptorImpl && (enumerationChildrenRenderer = EnumerationChildrenRenderer.getCurrent(((UserExpressionDescriptorImpl)valueDescriptor).getParentDescriptor())) != null && enumerationChildrenRenderer.isAppendDefaultChildren()) {
            nodeIcon = AllIcons.Debugger.Watch;
        }
        if (valueDescriptor instanceof WatchItemDescriptor && nodeIcon != AllIcons.Debugger.Watch && (session2 = XDebuggerManager.getInstance((Project)valueDescriptor.getProject()).getCurrentSession()) != null && (tab = ((XDebugSessionImpl)session2).getSessionTab()) != null && tab.isWatchesInVariables()) {
            nodeIcon = AllIcons.Debugger.Watch;
        }
        Icon valueIcon = valueDescriptor.getValueIcon();
        if (nodeIcon != null && valueIcon != null) {
            nodeIcon = new RowIcon(new Icon[]{nodeIcon, valueIcon});
        }
        return nodeIcon;
    }

    private static boolean isParameter(ValueDescriptorImpl valueDescriptor) {
        if (valueDescriptor instanceof LocalVariableDescriptorImpl) {
            try {
                return ((LocalVariableDescriptorImpl)valueDescriptor).getLocalVariable().getVariable().isArgument();
            }
            catch (EvaluateException evaluateException) {
            }
        } else if (valueDescriptor instanceof ArgumentValueDescriptorImpl) {
            return ((ArgumentValueDescriptorImpl)valueDescriptor).isParameter();
        }
        return false;
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2, EditorColorsScheme colorsScheme, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor2, colorsScheme, multiline, true);
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor2, DebuggerUIUtil.getColorScheme(null), multiline, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor2, DebuggerUIUtil.getColorScheme(null), false, false);
    }

    private static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2, EditorColorsScheme colorScheme, boolean multiline, boolean appendValue) {
        String[] strings;
        ValueMarkup markup;
        String nodeName;
        String text2;
        SimpleColoredText descriptorText = new SimpleColoredText();
        if (descriptor2 == null) {
            text2 = "";
            nodeName = null;
        } else {
            text2 = descriptor2.getLabel();
            nodeName = descriptor2.getName();
        }
        if (text2.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
            descriptorText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
            return descriptorText;
        }
        if (descriptor2 instanceof ValueDescriptor && (markup = ((ValueDescriptor)((Object)descriptor2)).getMarkup(debuggerContext.getDebugProcess())) != null) {
            descriptorText.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        if ((strings = DebuggerTreeRenderer.breakString(text2, nodeName))[0] != null) {
            if (descriptor2 instanceof MessageDescriptor && ((MessageDescriptor)descriptor2).getKind() == 3) {
                descriptorText.append(strings[0], SPECIAL_NODE_ATTRIBUTES);
            } else {
                descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
            }
        }
        if (strings[1] != null) {
            descriptorText.append(strings[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        }
        if (strings[2] != null) {
            if (descriptor2 instanceof ValueDescriptorImpl) {
                ValueDescriptorImpl valueDescriptor;
                String valueLabel;
                if (multiline && strings[2].indexOf(10) >= 0 && (strings = DebuggerTreeRenderer.breakString(strings[2], "="))[2] != null) {
                    strings[2] = strings[0] + strings[1] + "\n" + strings[2];
                }
                if ((strings = DebuggerTreeRenderer.breakString(strings[2], valueLabel = (valueDescriptor = (ValueDescriptorImpl)descriptor2).getValueLabel()))[0] != null) {
                    descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
                }
                if (appendValue && strings[1] != null) {
                    SimpleTextAttributes valueLabelAttribs;
                    if (valueLabel != null && StringUtil.startsWithChar((CharSequence)valueLabel, (char)'{') && valueLabel.indexOf(125) > 0 && !StringUtil.endsWithChar((CharSequence)valueLabel, (char)'}')) {
                        int idx = valueLabel.indexOf(125);
                        String objectId = valueLabel.substring(0, idx + 1);
                        valueLabel = valueLabel.substring(idx + 1);
                        descriptorText.append(objectId, OBJECT_ID_HIGHLIGHT_ATTRIBUTES);
                    }
                    valueLabel = DebuggerUtilsEx.truncateString(valueLabel);
                    if (valueDescriptor.isDirty()) {
                        valueLabelAttribs = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES;
                    } else {
                        TextAttributes attributes = null;
                        if (valueDescriptor.isNull()) {
                            attributes = colorScheme.getAttributes(JavaHighlightingColors.KEYWORD);
                        } else if (valueDescriptor.isString()) {
                            attributes = colorScheme.getAttributes(JavaHighlightingColors.STRING);
                        }
                        valueLabelAttribs = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : DEFAULT_ATTRIBUTES;
                    }
                    EvaluateException exception = descriptor2.getEvaluateException();
                    if (exception != null) {
                        String errorMessage = exception.getMessage();
                        if (valueLabel.endsWith(errorMessage)) {
                            DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel.substring(0, valueLabel.length() - errorMessage.length()), valueLabelAttribs, colorScheme);
                            descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        } else {
                            DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel, valueLabelAttribs, colorScheme);
                            descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        }
                    } else if (valueLabel.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
                        descriptorText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    } else {
                        DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel, valueLabelAttribs, colorScheme);
                    }
                }
            } else {
                descriptorText.append(strings[2], DEFAULT_ATTRIBUTES);
            }
        }
        return descriptorText;
    }

    private static void appendValueTextWithEscapesRendering(SimpleColoredText descriptorText, String valueText, SimpleTextAttributes attribs, EditorColorsScheme colorScheme) {
        SimpleTextAttributes escapeAttribs = null;
        StringBuilder buf = new StringBuilder();
        boolean slashFound = false;
        for (int idx = 0; idx < valueText.length(); ++idx) {
            char ch = valueText.charAt(idx);
            if (slashFound) {
                slashFound = false;
                if (ch == '\\' || ch == '\"' || ch == 'b' || ch == 't' || ch == 'n' || ch == 'f' || ch == 'r') {
                    if (buf.length() > 0) {
                        descriptorText.append(buf.toString(), attribs);
                        buf.setLength(0);
                    }
                    if (escapeAttribs == null) {
                        TextAttributes fromHighlighter = colorScheme.getAttributes(JavaHighlightingColors.VALID_STRING_ESCAPE);
                        escapeAttribs = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)fromHighlighter) : DEFAULT_ATTRIBUTES.derive(1, (Color)JBColor.GRAY, null, null);
                    }
                    if (ch != '\\' && ch != '\"') {
                        descriptorText.append("\\", escapeAttribs);
                    }
                    descriptorText.append(String.valueOf(ch), escapeAttribs);
                    continue;
                }
                buf.append('\\').append(ch);
                continue;
            }
            if (ch == '\\') {
                slashFound = true;
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            descriptorText.append(buf.toString(), attribs);
        }
    }

    private static String[] breakString(String source, String substr) {
        if (substr != null && substr.length() > 0) {
            int index = Math.max(source.indexOf(substr), 0);
            String prefix = index > 0 ? source.substring(0, index) : null;
            String suffix = (index += substr.length()) < source.length() - 1 ? source.substring(index) : null;
            return new String[]{prefix, substr, suffix};
        }
        return new String[]{source, null, null};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "customizeCellRenderer"));
    }
}

