/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicListUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteItemsComponent
extends JBList {
    private static final SimpleTextAttributes DEPRECATED_ATTRIBUTES = new SimpleTextAttributes(4, null);
    private final PaletteGroup myGroup;
    private final DesignerEditorPanel myDesigner;
    private int myBeforeClickSelectedRow = -1;
    private boolean myNeedClearSelection;
    private Integer myTempWidth;

    public PaletteItemsComponent(PaletteGroup group, @Nullable DesignerEditorPanel designer) {
        this.myGroup = group;
        this.myDesigner = designer;
        this.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return PaletteItemsComponent.this.myGroup.getItems().size();
            }

            @Override
            public Object getElementAt(int index) {
                return PaletteItemsComponent.this.myGroup.getItems().get(index);
            }
        });
        ColoredListCellRenderer renderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.clear();
                PaletteItem item = (PaletteItem)value2;
                boolean enabled = item.isEnabled();
                this.setEnabled(enabled);
                if (enabled) {
                    this.setIcon(item.getIcon());
                } else {
                    this.setIcon(IconLoader.getDisabledIcon((Icon)item.getIcon()));
                }
                String title = item.getTitle();
                String tooltip = item.getTooltip();
                String version = PaletteItemsComponent.this.myDesigner.getVersionLabel(item.getVersion());
                String deprecatedIn = item.getDeprecatedIn();
                boolean deprecated = PaletteItemsComponent.this.myDesigner.isDeprecated(deprecatedIn);
                this.append(title, deprecated ? DEPRECATED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (!version.isEmpty()) {
                    version = "<sup><i>" + version + "</i></sup>";
                }
                if (tooltip != null) {
                    String deprecatedMessage = "";
                    if (deprecated) {
                        deprecatedMessage = String.format("<b>This item is deprecated in version \"%1$s\".<br>", PaletteItemsComponent.this.myDesigner.getVersionLabel(deprecatedIn));
                        String hint = item.getDeprecatedHint();
                        if (!StringUtil.isEmpty((String)hint)) {
                            deprecatedMessage = deprecatedMessage + hint;
                        }
                        deprecatedMessage = deprecatedMessage + "</b><br><br>";
                    }
                    tooltip = "<html><body><center><b>" + StringUtil.escapeXml((String)title) + "</b>" + version + "</center><p style='width: 300px'>" + deprecatedMessage + tooltip + "</p></body></html>";
                }
                this.setToolTipText(tooltip);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/designer/palette/PaletteItemsComponent$2", "customizeCellRenderer"));
            }
        };
        renderer.getIpad().left = 2 * UIUtil.getTreeLeftChildIndent();
        renderer.getIpad().right = UIUtil.getTreeRightChildIndent();
        this.setCellRenderer((ListCellRenderer)renderer);
        this.setVisibleRowCount(0);
        this.setLayoutOrientation(2);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PaletteItemsComponent.this.myNeedClearSelection = SwingUtilities.isLeftMouseButton(e) && PaletteItemsComponent.this.myBeforeClickSelectedRow >= 0 && PaletteItemsComponent.this.locationToIndex(e.getPoint()) == PaletteItemsComponent.this.myBeforeClickSelectedRow && !UIUtil.isControlKeyDown((MouseEvent)e) && !e.isShiftDown();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && PaletteItemsComponent.this.myBeforeClickSelectedRow >= 0 && PaletteItemsComponent.this.locationToIndex(e.getPoint()) == PaletteItemsComponent.this.myBeforeClickSelectedRow && !UIUtil.isControlKeyDown((MouseEvent)e) && !e.isShiftDown() && PaletteItemsComponent.this.myNeedClearSelection) {
                    PaletteItemsComponent.this.clearSelection();
                }
            }
        });
        this.setDragEnabled(true);
        this.setTransferHandler(new TreeTransfer(PaletteItem.class));
        DnDManager.getInstance().registerSource(new DnDSource(){

            public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                int index = PaletteItemsComponent.this.locationToIndex(dragOrigin);
                if (index != -1 && PaletteItemsComponent.this.myDesigner != null) {
                    PaletteItem paletteItem = PaletteItemsComponent.this.myGroup.getItems().get(index);
                    PaletteItemsComponent.this.myDesigner.activatePaletteItem(paletteItem);
                }
                return false;
            }

            public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
                return null;
            }

            @Nullable
            public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
                return null;
            }

            public void dragDropEnd() {
            }

            public void dropActionChanged(int gestureModifiers) {
            }
        }, (JComponent)((Object)this));
        this.initActions();
    }

    public void updateUI() {
        this.setUI(new BasicListUI(){
            MouseListener myListener;

            @Override
            protected void updateLayoutState() {
                super.updateLayoutState();
                Insets insets = this.list.getInsets();
                int listWidth = this.list.getWidth() - (insets.left + insets.right);
                if (listWidth >= this.cellWidth) {
                    int columnCount = listWidth / this.cellWidth;
                    this.cellWidth = columnCount == 0 ? 1 : listWidth / columnCount;
                }
            }

            @Override
            protected void installListeners() {
                this.myListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        PaletteItemsComponent.this.myBeforeClickSelectedRow = list.getSelectedIndex();
                    }
                };
                PaletteItemsComponent.this.addMouseListener(this.myListener);
                super.installListeners();
            }

            @Override
            protected void uninstallListeners() {
                if (this.myListener != null) {
                    PaletteItemsComponent.this.removeMouseListener(this.myListener);
                }
                super.uninstallListeners();
            }
        });
        this.invalidate();
    }

    public int getWidth() {
        return this.myTempWidth == null ? super.getWidth() : this.myTempWidth.intValue();
    }

    public int getPreferredHeight(int width) {
        this.myTempWidth = width;
        try {
            int n = this.getUI().getPreferredSize((JComponent)((Object)this)).height;
            return n;
        }
        finally {
            this.myTempWidth = null;
        }
    }

    public void takeFocusFrom(int indexToSelect) {
        if (indexToSelect == -1) {
            indexToSelect = this.getModel().getSize() - 1;
        } else if (this.getModel().getSize() == 0) {
            indexToSelect = -1;
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this), true));
        this.setSelectedIndex(indexToSelect);
        if (indexToSelect >= 0) {
            this.ensureIndexIsVisible(indexToSelect);
        }
    }

    public void restoreSelection(PaletteItem paletteItem) {
        if (paletteItem == null) {
            this.clearSelection();
        } else {
            int index = this.myGroup.getItems().indexOf(paletteItem);
            if (index == -1) {
                this.clearSelection();
            } else {
                this.takeFocusFrom(index);
            }
        }
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("selectPreviousRow", new MoveFocusAction(map.get("selectPreviousRow"), false));
        map.put("selectNextRow", new MoveFocusAction(map.get("selectNextRow"), true));
        map.put("selectPreviousColumn", new MoveFocusAction(new ChangeColumnAction(map.get("selectPreviousColumn"), false), false));
        map.put("selectNextColumn", new MoveFocusAction(new ChangeColumnAction(map.get("selectNextColumn"), true), true));
    }

    private class ChangeColumnAction
    extends AbstractAction {
        private final Action myDefaultAction;
        private final boolean mySelectNext;

        public ChangeColumnAction(Action defaultAction, boolean selectNext) {
            this.myDefaultAction = defaultAction;
            this.mySelectNext = selectNext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selIndexBefore = PaletteItemsComponent.this.getSelectedIndex();
            this.myDefaultAction.actionPerformed(e);
            int selIndexCurrent = PaletteItemsComponent.this.getSelectedIndex();
            if (this.mySelectNext && selIndexBefore < selIndexCurrent || !this.mySelectNext && selIndexBefore > selIndexCurrent) {
                return;
            }
            if (this.mySelectNext) {
                if (selIndexCurrent == selIndexBefore + 1) {
                    ++selIndexCurrent;
                }
                if (selIndexCurrent < PaletteItemsComponent.this.getModel().getSize() - 1) {
                    PaletteItemsComponent.this.setSelectedIndex(selIndexCurrent + 1);
                    PaletteItemsComponent.this.scrollRectToVisible(PaletteItemsComponent.this.getCellBounds(selIndexCurrent + 1, selIndexCurrent + 1));
                }
            } else if (selIndexCurrent > 0) {
                PaletteItemsComponent.this.setSelectedIndex(selIndexCurrent - 1);
                PaletteItemsComponent.this.scrollRectToVisible(PaletteItemsComponent.this.getCellBounds(selIndexCurrent - 1, selIndexCurrent - 1));
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final Action myDefaultAction;
        private final boolean myFocusNext;

        public MoveFocusAction(Action defaultAction, boolean focusNext) {
            this.myDefaultAction = defaultAction;
            this.myFocusNext = focusNext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component next;
            int selIndexBefore = PaletteItemsComponent.this.getSelectedIndex();
            this.myDefaultAction.actionPerformed(e);
            int selIndexCurrent = PaletteItemsComponent.this.getSelectedIndex();
            if (selIndexBefore != selIndexCurrent) {
                return;
            }
            if (this.myFocusNext && selIndexCurrent == 0) {
                return;
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = kfm.getCurrentFocusCycleRoot();
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            if (policy == null) {
                policy = kfm.getDefaultFocusTraversalPolicy();
            }
            Component component = next = this.myFocusNext ? policy.getComponentAfter(container, (Component)((Object)PaletteItemsComponent.this)) : policy.getComponentBefore(container, (Component)((Object)PaletteItemsComponent.this));
            if (next instanceof PaletteGroupComponent) {
                PaletteItemsComponent.this.clearSelection();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(next, true));
                ((PaletteGroupComponent)next).scrollRectToVisible(next.getBounds());
            }
        }
    }
}

