/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.errordialog.LabeledTextComponent;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttachmentsTabForm {
    private static final Logger LOG = Logger.getInstance(AttachmentsTabForm.class);
    private JPanel myContentPane;
    private TableView<Attachment> myTable;
    private LabeledTextComponent myFileTextArea;
    private final EventDispatcher<ChangeListener> myInclusionEventDispatcher;
    private final ColumnInfo<Attachment, Boolean> ENABLED_COLUMN;
    private static final ColumnInfo<Attachment, String> PATH_COLUMN = new ColumnInfo<Attachment, String>(DiagnosticBundle.message("error.dialog.attachment.path.column.title", new Object[0])){

        public String valueOf(Attachment attachment) {
            return attachment.getPath();
        }
    };

    public AttachmentsTabForm() {
        this.$$$setupUI$$$();
        this.myInclusionEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.ENABLED_COLUMN = new ColumnInfo<Attachment, Boolean>(DiagnosticBundle.message("error.dialog.attachment.include.column.title", new Object[0])){

            public Boolean valueOf(Attachment attachment) {
                return attachment.isIncluded();
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public int getWidth(JTable table) {
                return 50;
            }

            public boolean isCellEditable(Attachment attachment) {
                return true;
            }

            public void setValue(Attachment attachment, Boolean value2) {
                attachment.setIncluded(value2.booleanValue());
                ((ChangeListener)AttachmentsTabForm.this.myInclusionEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(attachment));
            }
        };
        this.myFileTextArea.getTextComponent().setEditable(false);
        this.myFileTextArea.setTitle(DiagnosticBundle.message("error.dialog.filecontent.title", new Object[0]));
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                LabeledTextComponent.setText(AttachmentsTabForm.this.myFileTextArea.getTextComponent(), null, false);
                Attachment attachment = (Attachment)AttachmentsTabForm.this.myTable.getSelectedObject();
                if (attachment != null) {
                    try {
                        LabeledTextComponent.setText(AttachmentsTabForm.this.myFileTextArea.getTextComponent(), attachment.getDisplayText(), false);
                    }
                    catch (Throwable th) {
                        LOG.warn(th);
                    }
                }
            }
        });
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = AttachmentsTabForm.this.myTable.getSelectedRows();
                boolean aggregateValue = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !AttachmentsTabForm.this.myTable.isCellEditable(selectedRow, 0)) {
                        return;
                    }
                    Boolean value2 = (Boolean)AttachmentsTabForm.this.myTable.getValueAt(selectedRow, 0);
                    aggregateValue &= value2 == null || value2 != false;
                }
                for (int selectedRow : selectedRows) {
                    AttachmentsTabForm.this.myTable.setValueAt((Object)(aggregateValue ? Boolean.FALSE : Boolean.TRUE), selectedRow, 0);
                }
                AttachmentsTabForm.this.myTable.repaint();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.myContentPane.setPreferredSize((Dimension)JBUI.size((int)200, (int)210));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.myTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{this.ENABLED_COLUMN, PATH_COLUMN}, attachments, 1));
        this.myTable.setBorder(IdeBorderFactory.createBorder());
        this.myTable.setSelection(attachments.isEmpty() ? Collections.emptyList() : Collections.singletonList(attachments.get(0)));
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void addInclusionListener(ChangeListener listener2) {
        this.myInclusionEventDispatcher.addListener((EventListener)listener2);
    }

    public void selectFirstIncludedAttachment() {
        List items = ((ListTableModel)this.myTable.getModel()).getItems();
        for (Object item : items) {
            if (!((Attachment)item).isIncluded()) continue;
            this.myTable.setSelection(Collections.singleton((Attachment)item));
            break;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledTextComponent labeledTextComponent;
        TableView tableView;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 5, 0, 0), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>To investigate / fix the problem IDE wants to attach following files to the bug report. <br/>We recommend to include <b>all</b> the files providing maximum information.<br/><b>Note:</b> all the data you send will be kept private.</ntml>");
        jPanel.add((Component)jLabel, "North");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerSize(5);
        jSplitPane.setResizeWeight(0.25);
        jPanel.add((Component)jSplitPane, "Center");
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0), null, 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane);
        this.myTable = tableView = new TableView();
        tableView.setPreferredScrollableViewportSize(new Dimension(450, 100));
        jBScrollPane.setViewportView((Component)tableView);
        this.myFileTextArea = labeledTextComponent = new LabeledTextComponent();
        JComponent jComponent = labeledTextComponent.$$$getRootComponent$$$();
        jSplitPane.setRightComponent(jComponent);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

