/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareClipboardWithSelectionAction
extends BaseShowDiffAction {
    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
            return editor;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        return FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
    }

    @Nullable
    private static FileType getEditorFileType(@NotNull AnActionEvent e) {
        DiffContent content;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(1);
        }
        if ((content = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT)) != null && content.getContentType() != null) {
            return content.getContentType();
        }
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (request instanceof ContentDiffRequest) {
            for (DiffContent diffContent : ((ContentDiffRequest)request).getContents()) {
                FileType type2 = diffContent.getContentType();
                if (type2 == null || type2 == UnknownFileType.INSTANCE) continue;
                return type2;
            }
        }
        return null;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(2);
        }
        return (editor = CompareClipboardWithSelectionAction.getEditor(e)) != null;
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(3);
        }
        Project project2 = e.getProject();
        Editor editor = CompareClipboardWithSelectionAction.getEditor(e);
        FileType editorFileType = CompareClipboardWithSelectionAction.getEditorFileType(e);
        assert (editor != null);
        DocumentContent content2 = CompareClipboardWithSelectionAction.createContent(project2, editor, editorFileType);
        DocumentContent content1 = DiffContentFactory.getInstance().createClipboardContent(project2, content2);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = CompareClipboardWithSelectionAction.createContentTitle(editor);
        String title = DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]);
        SimpleDiffRequest request = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
        request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)editor.getCaretModel().getLogicalPosition().line));
        if (editor.isViewer()) {
            request.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{false, true});
        }
        return request;
    }

    @NotNull
    private static DocumentContent createContent(@Nullable Project project2, @NotNull Editor editor, @Nullable FileType type2) {
        if (editor == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(4);
        }
        DocumentContent content = DiffContentFactory.getInstance().create(project2, editor.getDocument(), type2);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            TextRange range = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            content = DiffContentFactory.getInstance().createFragment(project2, content, range);
        }
        DocumentContent documentContent = content;
        if (documentContent == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    @NotNull
    private static String createContentTitle(@NotNull Editor editor) {
        VirtualFile file2;
        String title;
        if (editor == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(6);
        }
        String string = title = (file2 = FileDocumentManager.getInstance().getFile(editor.getDocument())) != null ? DiffRequestFactory.getInstance().getContentTitle(file2) : "Editor";
        if (editor.getSelectionModel().hasSelection()) {
            title = DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{title});
        }
        String string2 = title;
        if (string2 == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareClipboardWithSelectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareClipboardWithSelectionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContentTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

